/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: manualContourContainer.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:14:56 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "manualContourContainer.h"

//////////////////////////////////////////////////////////////////////
// Constructor
//////////////////////////////////////////////////////////////////////

//--------------------------------------------------------
manualContourContainer::manualContourContainer()
{

	_manContourControlWall = NULL;
	_mContourModelWall = NULL;
	_mViewContourWall = NULL;


	_manContourControlLumen = NULL;
	_mContourModelLumen = NULL;
	_mViewContourLumen = NULL;
}




//--------------------------------------------------------
manualContourContainer::~manualContourContainer()
{

}

//--------------------------------------------------------
manualContourControler* manualContourContainer::getWallController()
{
	return _manContourControlWall;
}

//--------------------------------------------------------
manualContourControler* manualContourContainer::getLumenController()
{
	return _manContourControlLumen;
}

//--------------------------------------------------------
manualContourControler* manualContourContainer::getCalcController(int i)
{
	return _manContourControlCalc[i];
}

//--------------------------------------------------------
manualContourControler* manualContourContainer::getHypoController(int i)
{
	return _manContourControlHypo[i];
}

//--------------------------------------------------------
int manualContourContainer::addCalcificationContour(wxVtk2DBaseView	*_imageviewer2D_1)
{
	int tam = 0;
	manualContourControler *tempC	= new manualContourControler();
	manualContourModel *tempM		= new manualContourModel();
	manualViewContour *tempV		= new manualViewContour();
//EED 28Dic2006
	tempV->SetRange((int)(0.6) );

	_manContourControlCalc.push_back(tempC);
	_mContourModelCalc.push_back(tempM);
	_mViewContourCalc.push_back(tempV);

	tam = _mViewContourCalc.size() - 1;

	_mViewContourCalc[tam]->SetModel( _mContourModelCalc[tam] );
	_mViewContourCalc[tam]->SetWxVtkBaseView( _imageviewer2D_1 );
//	_mViewContourCalc[tam]->SetRange( 2 );
	_mViewContourCalc[tam]->SetZ( 1000 );
	_mViewContourCalc[tam]->SetColorNormalContour(0, 0.5, 0);
	_mViewContourCalc[tam]->SetColorEditContour(1, 1, 0.33);
	_manContourControlCalc[tam]->SetModelView( _mContourModelCalc[tam] , _mViewContourCalc[tam] );	
	_manContourControlCalc[tam]->CreateNewManualContour();
	_manContourControlCalc[tam]->SetActive(false);
	_mViewContourCalc[tam]->RefreshContour();

	return tam;
}
//--------------------------------------------------------
int manualContourContainer::addHypodenseContour(wxVtk2DBaseView	*_imageviewer2D_1)
{
	int tam = 0;
	manualContourControler *tempC = new manualContourControler();
	manualContourModel *tempM = new manualContourModel();
	manualViewContour *tempV = new manualViewContour();
//EED 28Dic2006
	tempV->SetRange( (int)(0.6) );

	_manContourControlHypo.push_back(tempC);
	_mContourModelHypo.push_back(tempM);
	_mViewContourHypo.push_back(tempV);

	tam = _mViewContourHypo.size() - 1;
	_mViewContourHypo[tam]->SetModel( _mContourModelHypo[tam] );
	_mViewContourHypo[tam]->SetWxVtkBaseView( _imageviewer2D_1 );
//	_mViewContourHypo[tam]->SetRange( 2 );
	_mViewContourHypo[tam]->SetZ( 1000 );
	_mViewContourHypo[tam]->SetColorNormalContour(0, 0.5, 0.5);
	_mViewContourHypo[tam]->SetColorEditContour(1, 1, 0.33);
	_manContourControlHypo[tam]->SetModelView( _mContourModelHypo[tam] , _mViewContourHypo[tam] );	
	_manContourControlHypo[tam]->CreateNewManualContour();
	_manContourControlHypo[tam]->SetActive(false);
	_mViewContourHypo[tam]->RefreshContour();

	return tam;
}

//--------------------------------------------------------
void manualContourContainer::setWallVisibility(bool visible)
{
	if (_mViewContourWall != NULL)
	{
		_mViewContourWall->SetVisible( visible );
		_mViewContourWall->Refresh();
	}
	
}

//--------------------------------------------------------
void manualContourContainer::setLumenVisibility(bool visible)
{
	if (_mViewContourLumen != NULL)
	{
		_mViewContourLumen->SetVisible( visible );
		_mViewContourLumen->Refresh();
	}
	
}

//--------------------------------------------------------
void manualContourContainer::setCalcVisibility(bool visible)
{
	int i;
	for (i = 0; i < (int)_mViewContourCalc.size(); i++)
	{
		_mViewContourCalc[i]->SetVisible( visible );
		_mViewContourCalc[i]->Refresh();
	}
	
}

//--------------------------------------------------------
void manualContourContainer::setHypoVisibility(bool visible)
{
	int i;
	for (i = 0; i < (int)_mViewContourHypo.size(); i++)
	{
		_mViewContourHypo[i]->SetVisible( visible );
		_mViewContourHypo[i]->Refresh();
	}
}

//--------------------------------------------------------
void manualContourContainer::setWallActive()
{
	_manContourControlWall -> SetActive(true);

	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}
	
	int i;
	for (i = 0; i < (int)_manContourControlCalc.size(); i++)
	{
		_manContourControlCalc[i] -> SetActive(false);
	}
	int j;
	for (j = 0; j < (int)_manContourControlHypo.size(); j++)
	{
		_manContourControlHypo[j] -> SetActive(false);
	}
}

//--------------------------------------------------------
void manualContourContainer::setLumenActive()
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}
	_manContourControlLumen -> SetActive(true);

	int i;
	for (i = 0; i < (int)_manContourControlCalc.size(); i++)
	{
		_manContourControlCalc[i] -> SetActive(false);
	}

	int j;
	for (j = 0; j < (int)_manContourControlHypo.size(); j++)
	{
		_manContourControlHypo[j] -> SetActive(false);
	}

	
}

//--------------------------------------------------------
void manualContourContainer::setCalcActive()
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}
	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}
	int i;
	for (i = 0; i < (int)_manContourControlHypo.size(); i++)
	{
		_manContourControlHypo[i] -> SetActive(false);
	}
	int j;
	for (j = 0; j < (int)_manContourControlCalc.size(); j++)
	{
		_manContourControlCalc[j] -> SetActive(true);
	}
}

//--------------------------------------------------------
void manualContourContainer::setHypoActive()
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}

	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}

	int i;
	for (i = 0; i < (int)_manContourControlCalc.size(); i++)
	{
		_manContourControlCalc[i] -> SetActive(false);
	}
	
	int j;
	for (j = 0; j < (int)_manContourControlHypo.size(); j++)
	{
		_manContourControlHypo[j] -> SetActive(true);
	}
}

//--------------------------------------------------------
void manualContourContainer::setCalcContourActive(int i)
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}
	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}

	int j;
	for (j = 0; j < (int)_manContourControlHypo.size(); j++)
	{
		_manContourControlHypo[j] -> SetActive(false);
	}

	_manContourControlCalc[i] -> SetActive(true);
}

//--------------------------------------------------------
void manualContourContainer::setHypoContourActive(int i)
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}
	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}

	int j;
	for (j = 0; j < (int)_manContourControlCalc.size(); j++)
	{
		_manContourControlCalc[j] -> SetActive(true);
	}

	_manContourControlHypo[i] -> SetActive(true);
}

//--------------------------------------------------------
int  manualContourContainer::getNumberOfCalcContours()
{
	return _manContourControlCalc.size();
}

//--------------------------------------------------------
int  manualContourContainer::getNumberOfHypoContours()
{
	return _manContourControlHypo.size();
}

//--------------------------------------------------------
void manualContourContainer::inactivate()
{
	if (_manContourControlWall != NULL)
	{
		_manContourControlWall -> SetActive(false);
	}
	if (_manContourControlLumen != NULL)
	{
		_manContourControlLumen -> SetActive(false);
	}

	int i;
	for (i = 0; i < (int)_manContourControlCalc.size(); i++)
	{
		_manContourControlCalc[i] -> SetActive(false);
	}
	int j;
	for (j = 0; j < (int)_manContourControlHypo.size(); j++)
	{
		_manContourControlHypo[j] -> SetActive(false);
	}
}

//--------------------------------------------------------
int manualContourContainer::getNumberOfWallContourPoints()
{
	return _manContourControlWall->GetNumberOfPointsSplineManualContour();
}

//--------------------------------------------------------
int manualContourContainer::getNumberOfLumenContourPoints()
{
	return _manContourControlLumen->GetNumberOfPointsSplineManualContour();
}

//--------------------------------------------------------
int manualContourContainer::getNumberOfCalcContourPoints(int i)
{
	return _manContourControlCalc[i]->GetNumberOfPointsSplineManualContour();
}

//--------------------------------------------------------
int manualContourContainer::getNumberOfHypoContourPoints(int i)
{
	return _manContourControlHypo[i]->GetNumberOfPointsSplineManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getXVectorWallPoints()
{
	return _manContourControlWall->GetVectorPointsXManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getXVectorLumenPoints()
{
	return _manContourControlLumen->GetVectorPointsXManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getXVectorCalcPoints(int i)
{
	return _manContourControlCalc[i]->GetVectorPointsXManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getXVectorHypoPoints(int i)
{
	return _manContourControlHypo[i]->GetVectorPointsXManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getYVectorWallPoints()
{
	return _manContourControlWall->GetVectorPointsYManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getYVectorLumenPoints()
{
	return _manContourControlLumen->GetVectorPointsYManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getYVectorCalcPoints(int i)
{
	return _manContourControlCalc[i]->GetVectorPointsYManualContour();
}

//--------------------------------------------------------
double* manualContourContainer::getYVectorHypoPoints(int i)
{
	return _manContourControlHypo[i]->GetVectorPointsYManualContour();
}

//--------------------------------------------------------
void manualContourContainer::clear()
{
	clearWall();
	clearLumen();
	clearCalc();	
	clearHypo();
}

//--------------------------------------------------------
void manualContourContainer::clearWall()
{
	if (_mViewContourWall != NULL)
	{
		_mViewContourWall->ClearContour();
	}
	
}

//--------------------------------------------------------
void manualContourContainer::clearLumen()
{
	if (_mViewContourLumen != NULL)
	{
		_mViewContourLumen->ClearContour();
	}
	
}

//--------------------------------------------------------
void manualContourContainer::clearCalc()
{
	int i;
	for (i = 0; i < (int)_mViewContourCalc.size(); i++)
	{
		_mViewContourCalc[i] -> ClearContour();
	}
}

//--------------------------------------------------------
void manualContourContainer::clearHypo()
{
	int j;
	for (j = 0; j < (int)_mViewContourHypo.size(); j++)
	{
		_mViewContourHypo[j] -> ClearContour();
	}
}


//--------------------------------------------------------
void manualContourContainer::refreshWall(wxVtk2DBaseView	*_imageviewer2D_1)
{

	if (_mContourModelWall == NULL)
	{
		return;
	}

	int size = _mContourModelWall->GetSizeLstPoints();
	std::vector<manualPoint *> points; 

	int i;
	for (i = 0; i < size; i++)
	{
		points.push_back(_mContourModelWall->GetManualPoint(i));
	}

	_mContourModelWall->DeleteAllPoints();
	_manContourControlWall->CreateNewManualContour();
	_manContourControlWall->SetActive(false);
	_mViewContourWall->RefreshContour();
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
					_manContourControlWall );
	for (i = 0; i < size; i++)
	{
		manualPoint* mp = points[i];
		int	id		= _manContourControlWall->GetManualContourModel()->AddPoint(mp->GetX(),mp->GetY(),mp->GetZ());
		_manContourControlWall->GetManualViewBaseContour()->AddPoint(); 
		_manContourControlWall->GetManualViewBaseContour()->Refresh();
	}
	
	
}

//--------------------------------------------------------
void manualContourContainer::refreshLumen(wxVtk2DBaseView	*_imageviewer2D_1)
{
	if (_mContourModelLumen == NULL)
	{
		return;
	}
	int size = _mContourModelLumen->GetSizeLstPoints();
	std::vector<manualPoint *> points; 

	int i;
	for (i = 0; i < size; i++)
	{
		points.push_back(_mContourModelLumen->GetManualPoint(i));
	}

	_mContourModelLumen->DeleteAllPoints();
	_manContourControlLumen->CreateNewManualContour();
	_manContourControlLumen->SetActive(false);
	_mViewContourLumen->RefreshContour();
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
					_manContourControlLumen );
	for (i = 0; i < size; i++)
	{
		manualPoint* mp = points[i];
		int	id		= _manContourControlLumen->GetManualContourModel()->AddPoint(mp->GetX(),mp->GetY(),mp->GetZ());
		_manContourControlLumen->GetManualViewBaseContour()->AddPoint(); 
		_manContourControlLumen->GetManualViewBaseContour()->Refresh();
	}
}

//--------------------------------------------------------
void manualContourContainer::refreshCalc(int j,wxVtk2DBaseView	*_imageviewer2D_1)
{

	int size = _mContourModelCalc[j]->GetSizeLstPoints();
	std::vector<manualPoint *> points; 

	int i;
	for (i = 0; i < size; i++)
	{
		points.push_back(_mContourModelCalc[j]->GetManualPoint(i));
	}

	_mContourModelCalc[j]->DeleteAllPoints();
	_manContourControlCalc[j]->CreateNewManualContour();
	_manContourControlCalc[j]->SetActive(false);
	_mViewContourCalc[j]->RefreshContour();
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
					_manContourControlCalc[j] );
	for (i = 0; i < size; i++)
	{
		manualPoint* mp = points[i];
		int	id		= _manContourControlCalc[j]->GetManualContourModel()->AddPoint(mp->GetX(),mp->GetY(),mp->GetZ());
		_manContourControlCalc[j]->GetManualViewBaseContour()->AddPoint(); 
		_manContourControlCalc[j]->GetManualViewBaseContour()->Refresh();
	}
	
	

}

//--------------------------------------------------------
void manualContourContainer::refreshHypo(int j,wxVtk2DBaseView	*_imageviewer2D_1)
{

	int size = _mContourModelHypo[j]->GetSizeLstPoints();
	std::vector<manualPoint *> points; 

	int i;
	for (i = 0; i < size; i++)
	{
		points.push_back(_mContourModelHypo[j]->GetManualPoint(i));
	}

	_mContourModelHypo[j]->DeleteAllPoints();
	_manContourControlHypo[j]->CreateNewManualContour();
	_manContourControlHypo[j]->SetActive(false);
	_mViewContourHypo[j]->RefreshContour();
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( 
					_manContourControlHypo[j] );
	for (i = 0; i < size; i++)
	{
		manualPoint* mp = points[i];
		int	id		= _manContourControlHypo[j]->GetManualContourModel()->AddPoint(mp->GetX(),mp->GetY(),mp->GetZ());
		_manContourControlHypo[j]->GetManualViewBaseContour()->AddPoint(); 
		_manContourControlHypo[j]->GetManualViewBaseContour()->Refresh();
	}
}

//--------------------------------------------------------
void manualContourContainer::restartWallContour(wxVtk2DBaseView	*_imageviewer2D_1)
{
	if (_manContourControlWall == NULL)
	{
		return;
	}
	delete _manContourControlWall;
	delete _mContourModelWall;
	delete _mViewContourWall;

	_manContourControlWall	= new manualContourControler();
	_mContourModelWall		= new manualContourModel();
	_mViewContourWall			= new manualViewContour();
//EED 28Dic2006
	_mViewContourWall->SetRange( (int)(0.6) );

	_mViewContourWall->SetModel( _mContourModelWall );
	_mViewContourWall->SetWxVtkBaseView( _imageviewer2D_1 );
//	_mViewContourWall->SetRange( 2 );
	_mViewContourWall->SetZ( 1000 );
	_mViewContourWall->SetColorNormalContour(0.2, 0.6, 1);
	_mViewContourWall->SetColorEditContour(1, 1, 0.33);

	_manContourControlWall->SetModelView( _mContourModelWall , _mViewContourWall );
	_manContourControlWall->CreateNewManualContour();
	_manContourControlWall->SetActive(false);
	_mViewContourWall->RefreshContour();
}
//--------------------------------------------------------
void manualContourContainer::restartLumenContour(wxVtk2DBaseView	*_imageviewer2D_1)
{

	if (_manContourControlLumen == NULL)
	{
		return;
	}
	delete _manContourControlLumen;
	delete _mContourModelLumen;
	delete _mViewContourLumen;

	_manContourControlLumen	= new manualContourControler();
	_mContourModelLumen		= new manualContourModel();
	_mViewContourLumen			= new manualViewContour();
	_mViewContourLumen->SetModel( _mContourModelLumen );
	_mViewContourLumen->SetWxVtkBaseView( _imageviewer2D_1 );
//EED 28Dic2006
	_mViewContourLumen->SetRange( (int)(0.6) );
	_mViewContourLumen->SetZ( 1000 );
	_mViewContourLumen->SetColorNormalContour(1, 0, 0);
	_mViewContourLumen->SetColorEditContour(1, 1, 0.33);

	_manContourControlLumen->SetModelView( _mContourModelLumen , _mViewContourLumen );	
	_manContourControlLumen->CreateNewManualContour();
	_manContourControlLumen->SetActive(false);
	_mViewContourLumen->RefreshContour();
}

//--------------------------------------------------------
void manualContourContainer::restartCalcContours()
{
	int i;
	for (i = 0; i < (int)_mContourModelCalc.size(); i++)
	{

		_manContourControlCalc[i] = NULL;
		_mContourModelCalc[i] = NULL;
		_mViewContourCalc[i] = NULL;

		delete _manContourControlCalc[i];
		delete _mContourModelCalc[i];
		delete _mViewContourCalc[i];
	}

	_manContourControlCalc.clear();	
	_mContourModelCalc.clear();
	_mViewContourCalc.clear();
}

//--------------------------------------------------------
void manualContourContainer::restartHypoContours()
{
	int i;
	for (i = 0; i < (int)_mContourModelHypo.size(); i++)
	{

		_manContourControlHypo[i] = NULL;
		_mContourModelHypo[i] = NULL;
		_mViewContourHypo[i] = NULL;

		delete _manContourControlHypo[i];
		delete _mContourModelHypo[i];
		delete _mViewContourHypo[i];
	}

	_manContourControlHypo.clear();	
	_mContourModelHypo.clear();
	_mViewContourHypo.clear();
}

//--------------------------------------------------------
void manualContourContainer::createWallContour(wxVtk2DBaseView	*_imageviewer2D_1)
{
	//Contorno 1
	_manContourControlWall	= new manualContourControler();
	_mContourModelWall 	= new manualContourModel();
	_mViewContourWall	= new manualViewContour();
	_mViewContourWall->SetModel( _mContourModelWall );
	_mViewContourWall->SetWxVtkBaseView( _imageviewer2D_1 );
//EED 28Dic2006
	_mViewContourWall->SetRange( (int)(0.6) );

	_mViewContourWall->SetZ( 1000 );
	_mViewContourWall->SetColorNormalContour(0.2, 0.6, 1);
	_mViewContourWall->SetColorEditContour(1, 1, 0.33);

	_manContourControlWall->SetModelView( _mContourModelWall , _mViewContourWall );
	_manContourControlWall->CreateNewManualContour();
	_manContourControlWall->SetActive(false);
	_mViewContourWall->RefreshContour();
}

//--------------------------------------------------------
void manualContourContainer::createLumenContour(wxVtk2DBaseView	*_imageviewer2D_1)
{

		//Contorno Lumen
	_manContourControlLumen	= new manualContourControler();
	_mContourModelLumen		= new manualContourModel();
	_mViewContourLumen			= new manualViewContour();
	_mViewContourLumen->SetModel( _mContourModelLumen );
	_mViewContourLumen->SetWxVtkBaseView( _imageviewer2D_1 );
//EED 28Dic2006
	_mViewContourLumen->SetRange( (int)(0.6) );

	_mViewContourLumen->SetZ( 1000 );
	_mViewContourLumen->SetColorNormalContour(1, 0, 0);
	_mViewContourLumen->SetColorEditContour(1, 1, 0.33);

	_manContourControlLumen->SetModelView( _mContourModelLumen , _mViewContourLumen );	
	_manContourControlLumen->CreateNewManualContour();
	_manContourControlLumen->SetActive(false);
	_mViewContourLumen->RefreshContour();
}
