/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: manualContourContainer.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef MANUAL_CONTOUR_CONTAINER_H
#define MANUAL_CONTOUR_CONTAINER_H


#include <vector>
#include "manualContourControler.h"
#include "manualContourModel.h"
#include "manualViewContour.h"

class manualContourContainer  
{
public:
	
	manualContourContainer();
	virtual ~manualContourContainer();

	manualContourControler* getWallController();
	manualContourControler* getLumenController();
	manualContourControler* getCalcController(int i);
	manualContourControler* getHypoController(int i);
	void createWallContour(wxVtk2DBaseView	*_imageviewer2D_1);
	void createLumenContour(wxVtk2DBaseView	*_imageviewer2D_1);

	int	addCalcificationContour(wxVtk2DBaseView	*_imageviewer2D_1);
	int	addHypodenseContour(wxVtk2DBaseView	*_imageviewer2D_1);

	void setWallVisibility(bool visible);
	
	void setLumenVisibility(bool visible);
	void setCalcVisibility(bool visible);
	void setHypoVisibility(bool visible);
	void setWallActive();
	void setLumenActive();
	void setCalcActive();
	void setHypoActive();
	void setCalcContourActive(int i);
	void setHypoContourActive(int i);
	int  getNumberOfCalcContours();
	int  getNumberOfHypoContours();
	void inactivate();

	int getNumberOfWallContourPoints();
	int getNumberOfLumenContourPoints();
	int getNumberOfCalcContourPoints(int i);
	int getNumberOfHypoContourPoints(int i);

	double* getXVectorWallPoints();
	double* getXVectorLumenPoints();
	double* getXVectorCalcPoints(int i);
	double* getXVectorHypoPoints(int i);

	double* getYVectorWallPoints();
	double* getYVectorLumenPoints();
	double* getYVectorCalcPoints(int i);
	double* getYVectorHypoPoints(int i);
	void clear();
	void clearWall();
	void clearLumen();
	void clearCalc();
	void clearHypo();
	void refreshWall(wxVtk2DBaseView	*_imageviewer2D_1);
	void refreshLumen(wxVtk2DBaseView	*_imageviewer2D_1);
	void refreshCalc(int i, wxVtk2DBaseView	*_imageviewer2D_1);
	void refreshHypo(int i, wxVtk2DBaseView	*_imageviewer2D_1);
	
	void restartWallContour(wxVtk2DBaseView	*_imageviewer2D_1);
	void restartLumenContour(wxVtk2DBaseView	*_imageviewer2D_1);
	void restartCalcContours();
	void restartHypoContours();

private:
	//Manual Contour Wall
	
	manualContourControler *_manContourControlWall;
	manualContourModel		*_mContourModelWall;
	manualViewContour		*_mViewContourWall;


	//Manual Contour Lumen
	manualContourControler	*_manContourControlLumen;
	manualContourModel		*_mContourModelLumen;
	manualViewContour			*_mViewContourLumen;

	//Manual Contour Calc
	std::vector <manualContourControler *> _manContourControlCalc;
	std::vector <manualContourModel *> _mContourModelCalc;
	std::vector <manualViewContour *> _mViewContourCalc;

	//Manual Contour Hypo
	std::vector <manualContourControler *> _manContourControlHypo;
	std::vector <manualContourModel *> _mContourModelHypo;
	std::vector <manualViewContour *> _mViewContourHypo;	



};

#endif //
