/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <stdio.h>
#include <stdlib.h> 
#include <string.h> 

#include "marDictionary.h"


marDictFrase::marDictFrase(int idfrase,char*frase){
  _idfrase	 = idfrase;
  _frase=(char*)malloc(strlen(frase));
  memcpy( _frase , frase , strlen(frase));
  _frase[strlen(frase)-1]='\0';
}
//-----------------------------------------------------

marDictFrase::~marDictFrase(){
	free(_frase);
}
//-----------------------------------------------------

int marDictFrase::GetIdFrase(){
	return _idfrase;
}
//-----------------------------------------------------

char* marDictFrase::GetFrase(){
	return _frase;
}
//-----------------------------------------------------
//-----------------------------------------------------
//-----------------------------------------------------
//-----------------------------------------------------

int marDictionary::_language						=	0;
std::vector<marDictFrase*>* marDictionary::_frases	=	0;

//-----------------------------------------------------

marDictionary::marDictionary(){
	strcpy( _emptyStr      , "(...)"         );		
}
//-----------------------------------------------------
marDictionary::~marDictionary(){
} 
//-----------------------------------------------------
bool marDictionary::ExistFileDictionary(char *dictionaryFileName){

	bool result=true;
	FILE *ff=fopen(dictionaryFileName,"r");
	if (ff==NULL){
		result=false;
	}
	return result;
}
//-----------------------------------------------------
void marDictionary::ResetDictionary(){
	if (_frases!=NULL){
		FreeDictionary();
		delete _frases;
	}
	_frases=new std::vector<marDictFrase*>();
}
//-----------------------------------------------------
bool marDictionary::LoadDictionaryFile(char *dictionaryFileName){
	ResetDictionary();

	bool result=false;

	if ((_frases->size()==0) && (ExistFileDictionary(dictionaryFileName)==true) ){
		long idText;
		long idLanguage;
		char idTextStr[50];
		char idLanguageStr[50];
		char text[256];
		char line[256];
		char name[50];
		FILE *fileIn;
		fileIn=fopen(dictionaryFileName,"r");

		fgets(line, 256, fileIn);
		sscanf(line,"%s %d" , name,&idLanguage);		

		if (strcmp(name,"MARACAS_LANGUAGE")==0){
			SetLanguage(idLanguage);
			while (!feof(fileIn)) {
				fgets(line, 256, fileIn);
				if (strlen(line)>5){
					sscanf(line,"%s %s " , idLanguageStr,idTextStr);		
					sscanf(idLanguageStr,"%d " , &idLanguage);	
					if (GetLanguage()==idLanguage){
						sscanf(idTextStr,"%d " , &idText);		
						char	*start	= line + strlen(idLanguageStr)+1 + strlen(idTextStr)+1;
						int		size	= strlen(line) -  (strlen(idLanguageStr)+1 + strlen(idTextStr)+1);
						memcpy(text,start,size-1);
						text[size]='\0';
						SetString(idText,text);
					}
				}
			}
			result=true;
		} else {
		}
		fclose(fileIn);
	}  // if _frases->size()==0
	return result;
} 

//-----------------------------------------------------
void marDictionary::LoadDictionary_English(){
	ResetDictionary();
	SetLanguage(1);

	SetString(   5 , "MARACAS: MAgnetic Resonance Angiography Computer ASisted analysis ");
	SetString(  10 , "Iso Surface values ");
	SetString(  15 , "Iso visible ");
	SetString(  20 , "Opacity (%) ");
	SetString(  25 , "Isovalue ");
	SetString(  30 , "0 ");
	SetString(  35 , "Select ");
	SetString(  40 , "artery ");
	SetString(  45 , "1 ");
	SetString(  50 , "Axis Extraction ");
	SetString(  55 , "2 ");
	SetString(  60 , "Quantification ");
	SetString(  65 , "Set an initial point. ");
	SetString(  70 , "(Double click over the interest artery.) ");
	SetString(  73 , "OK ");
	SetString(  75 , "Start 3D ");
	SetString(  80 , "Plan ");
	SetString(  85 , "Parameters ");
	SetString(  90 , "Slice ");
	SetString( 205 , "Healthy slice ");
	SetString( 210 , "Perpendicular section ");
	SetString( 215 , "Visible ring ");
	SetString( 220 , "Show surface ");
	SetString( 225 , "Opacity ");
	SetString( 230 , "grayscale         ");
	SetString( 235 , "color ");
	SetString( 240 , "Isovalue  ");
	SetString( 245 , "Add mark contour ");
	SetString( 248 , "Save Contours ");
	SetString( 250 , "Erase marks contours ");
	SetString( 253 , "Erase all marks contours ");
	SetString( 255 , "Stenosis (area) ");
	SetString( 260 , "Stenosis (diameter) ");
	SetString( 265 , "Stenosis search ");
	SetString( 270 , "Automatic stenosis search ");
	SetString( 273 , "0 ");
	SetString( 275 , "Select ");
	SetString( 280 , " slice ");
	SetString( 283 , "1 ");
	SetString( 285 , "    Validate ");
	SetString( 290 , "Healthy Slice ");
	SetString( 293 , "2 ");
	SetString( 295 , "   Validate ");
	SetString( 300 , "End Region ");
	SetString( 303 , "3 ");
	SetString( 305 , "   Find ");
	SetString( 310 , "stenosis ");
	SetString( 315 , "Automatic ");
	SetString( 320 , "Manual ");
	SetString( 325 , "Manual stenosis search ");
	SetString( 328 , "0 ");
	SetString( 330 , "Select ");
	SetString( 335 , " slice ");
	SetString( 338 , "1 ");
	SetString( 340 , "    Select ");
	SetString( 345 , "other slice ");
	SetString( 348 , "2 ");
	SetString( 350 , "    Validate ");
	SetString( 355 , "Healthy Slice ");
	SetString( 360 , "Healthy region size ");
	SetString( 365 , "Healthy region size ");
	SetString( 370 , "Size of the healthy region  ( 2xn+1 ) ");
	SetString( 373 , "n :  ");
	SetString( 375 , "Refresh healthy region ");
	SetString( 380 , "Total Axis Lenght ");
	SetString( 385 , "Seg. Length ");
	SetString( 390 , "Area ");
	SetString( 395 , "Ref. Area ");
	SetString( 400 , "Perimeter ");
	SetString( 405 , "Minimum Diameter ");
	SetString( 410 , "Maximum Diameter ");
	SetString( 415 , "Average Diameter ");
	SetString( 420 , "Ref Average Diam. ");
	SetString( 500 , "Maracas parameters... ");
	SetString( 505 , "Contour parameters ");
	SetString( 510 , "Contour calculation algorithm ");
	SetString( 515 , "% Thereshold ");
	SetString( 520 , "Debug ");
	SetString( 525 , "Visible Diameter? ");
	SetString( 530 , "Axis Parameters  ");
	SetString( 535 , "Extraction parameters ");
	SetString( 540 , "Flexion coefficient: ");
	SetString( 545 , "Tension coefficient: ");
	SetString( 550 , "Mask size (2*n+1), n: ");
	SetString( 555 , "Discret step for axis (1/N): ");
	SetString( 560 , "OK ");
	SetString( 565 , "Cancel ");
	SetString( 570 , "Default ");
	SetString( 575 , "Reset ");
	SetString( 580 , "Apply ");
	SetString( 605 , "The mask size was modified. ");
	SetString( 610 , "The threshold was modified. ");
	SetString( 615 , "The flexion coeficient was modified. ");
	SetString( 620 , "The tension coeficient was modified. ");
	SetString( 625 , "The discret step of the axis was modified.   ");
	SetString( 630 , " The axe will be regenereted and the contours will be eresed. ");
	SetString( 635 , " All contours will be erase.  ");
	SetString( 640 , " Do you want to continue?   ");
	SetString( 645 , "Alert   ");
	SetString( 650 , " %  Threshold  :   ");
	SetString( 655 , "Visible diameters? ");
	SetString( 660 , "Flexion coefficient: ");
	SetString( 665 , "Tension coefficient: ");
	SetString( 670 , "Mask size (2*n+1). n:  ");
	SetString( 675 , "Discret step for axis (1/N): ");
	SetString( 680 , "OK  ");
	SetString( 685 , "Cancel ");
	SetString( 690 , "Reset ");
	SetString( 695 , "Apply ");
	SetString( 700 , "Default ");
	SetString( 710 , "MARACAS Parameters... ");
	SetString( 720 , "Extraction parameters ");
	SetString( 725 , "Debug ");
	SetString( 730 , "Contour calculation algorithm ");
	SetString( 735 , "Contour Parameters ");
	SetString( 740 , "Axis Parameters ");
	SetString( 745 , "Invert slice order ");
	SetString( 800 , "Contour modification ");
	SetString( 803 , "Contour modification ");
	SetString( 805 , "1 ");
	SetString( 810 , "2 ");
	SetString( 815 , "3 ");
	SetString( 820 , "New ");
	SetString( 825 , "Contour ");
	SetString( 830 , "Replace ");
	SetString( 835 , "End ");
	SetString( 840 , "Insert point ");
	SetString( 845 , "Delete point ");
	SetString( 850 , "Move point ");
	SetString( 855 , "Use mouse left button to ");
	SetString( 860 , "create the new contour. ");
	SetString( 865 , "Alert ");
	SetString( 870 , "This option erase all 3D contours. ");
	SetString( 875 , "Do you want to continue? ");
	SetString( 905 , "Set an initial point. ");
	SetString( 910 , "(Double click over the interest artery.) ");
	SetString( 915 , "The initial point should be far ");
	SetString( 920 , "of the limits of the volume. ");
	SetString( 925 , "Threshold ");
	SetString( 930 , "Lumen Intensity % ");
	SetString( 935 , "Calcification Intensity % ");
	SetString( 940 , "Contour control ");
}
//-----------------------------------------------------
void marDictionary::LoadDictionary_French(){
	ResetDictionary();
	SetLanguage(2);

	SetString(   5 , "MARACAS: MAgnetic Resonance Angiography Computer ASisted analysis ");
	SetString(  10 , "Valeurs de l'Iso surface ");
	SetString(  15 , "Iso visible");
	SetString(  20 , "Opacit  (%) ");
	SetString(  25 , "Isovalue ");
	SetString(  30 , "0 ");
	SetString(  35 , "Choisir  ");
	SetString(  40 , "l'artre  ");
	SetString(  45 , "1 ");
	SetString(  50 , "Extraction de l'axe  ");
	SetString(  55 , "2 ");
	SetString(  60 , "Quantification ");
	SetString(  65 , "Placez un premier point. ");
	SetString(  70 , "(Double clique au-dessus de l'artre d'intrt.) ");
	SetString(  73 , "OK ");
	SetString(  75 , "Commencer 3D  ");
	SetString(  80 , "Plan ");
	SetString(  85 , "Paramtres ");
	SetString(  90 , "Coupe  ");
	SetString( 205 , "Coupe saine ");
	SetString( 210 , "Section perpendiculaire ");
	SetString( 215 , "Visibilit des anneaux ");
	SetString( 220 , "Montrer la surface ");
	SetString( 225 , "Opacit  ");
	SetString( 230 , "Niveaux des gris         ");
	SetString( 235 , "Couleur ");
	SetString( 240 , "Isovaleur  ");
	SetString( 245 , "Ajouter un marqueur de coupe ");
	SetString( 248 , "Enregistre les contours ");
	SetString( 250 , "Effacer un marqueur de coupe  ");
	SetString( 253 , "Effacer les marquer des coupes ");
	SetString( 255 , "Stnoses  (surface) ");
	SetString( 260 , "Stnoses (diamtre ) ");
	SetString( 265 , "Recherche des stnoses  ");
	SetString( 270 , "Recherche automatique de la stnose ");
	SetString( 273 , "0 ");
	SetString( 275 , "Choisissez ");
	SetString( 280 , " la coupe ");
	SetString( 283 , "1 ");
	SetString( 285 , "Valider la  ");
	SetString( 290 , "coupe saine ");
	SetString( 293 , "2 ");
	SetString( 295 , "Valider la fin ");
	SetString( 300 , "de la rgion ");
	SetString( 303 , "3 ");
	SetString( 305 , "   Chercher ");
	SetString( 310 , "   stnoses ");
	SetString( 315 , "Automatique ");
	SetString( 320 , "Manuel ");
	SetString( 325 , "Recherche manuel de la stnose ");
	SetString( 328 , "0 ");
	SetString( 330 , "Choisir ");
	SetString( 335 , " la coupe ");
	SetString( 338 , "1 ");
	SetString( 340 , " Choisissez ");
	SetString( 345 , "autre coupe ");
	SetString( 348 , "2 ");
	SetString( 350 , "Valider la ");
	SetString( 355 , "coupe saine ");
	SetString( 360 , "Taille de rgion saine  ");
	SetString( 365 , "Taille de rgion saine  ");
	SetString( 370 , "( 2xn+1 ) ");
	SetString( 373 , "n :  ");
	SetString( 375 , "Rgnrer la rgion saine ");
	SetString( 380 , "Longeur total de l'axe  ");
	SetString( 385 , "Longueur du segment ");
	SetString( 390 , "Surface ");
	SetString( 395 , "Surface de ref. ");
	SetString( 400 , "Primtre ");
	SetString( 405 , "Diamtre minimum ");
	SetString( 410 , "Diamtre maximum ");
	SetString( 415 , "Diamtre moyen ");
	SetString( 420 , "Diamtre moyen de ref. ");
	SetString( 500 , "Paramtres de MARACAS... ");
	SetString( 505 , "Paramtres du contour ");
	SetString( 510 , "Algorithme pour le calcule de contour ");
	SetString( 515 , "% Seuillage ");
	SetString( 520 , "Debug ");
	SetString( 525 , "Montrer diamtre? ");
	SetString( 530 , "Paramtres de l'axe  ");
	SetString( 535 , "Paramtres d'extraction ");
	SetString( 540 , "Coefficient de flexion: ");
	SetString( 545 , "Coefficient de tension : ");
	SetString( 550 , "Taille du masque (2*n+1), n: ");
	SetString( 555 , "Pas de discrtisation pour l'axe (1/N): ");
	SetString( 560 , "OK ");
	SetString( 565 , "Annule ");
	SetString( 570 , "Dfaut ");
	SetString( 575 , "Remise ");
	SetString( 580 , "Appliquer ");
	SetString( 605 , "La taille de masque a t modifie. ");
	SetString( 610 , "Le seuil a t modifi . ");
	SetString( 615 , "Le coefficient de flexion a t modifi. ");
	SetString( 620 , "Le coefficient de tension a t modifi . ");
	SetString( 625 , "Le pas de discrtisations a t modifi.   ");
	SetString( 630 , " L'axe sera rgnr et les coupes seront effaces. ");
	SetString( 635 , " Tous les contours seront effacs. ");
	SetString( 640 , " Voulez-vous continuer ?   ");
	SetString( 645 , "Atention   ");
	SetString( 650 , " %  Seuillage  :   ");
	SetString( 655 , "Diamtres visible? ");
	SetString( 660 , "Coefficient de flexion: ");
	SetString( 665 , "Coefficient de tension: ");
	SetString( 670 , "Taille du masque (2*n+1). n:  ");
	SetString( 675 , "Pas de discrtisations pour l'axe (1/N): ");
	SetString( 680 , "OK  ");
	SetString( 685 , "Annule ");
	SetString( 690 , "Rinitialisation ");
	SetString( 695 , "Appliquez ");
	SetString( 700 , "Dfaut ");
	SetString( 710 , "Paramtres de MARACAS... ");
	SetString( 720 , "Extraction de paramtres ");
	SetString( 725 , "Debug ");
	SetString( 730 , "Algorithme pour le calcul de contour  ");
	SetString( 735 , "Paramtres du contour ");
	SetString( 740 , "Paramtres de l'axe ");
	SetString( 745 , "Invertir l'ordre des coupes ");
	SetString( 800 , "Contour modification ");
	SetString( 803 , "Modification du contour ");
	SetString( 805 , "1 ");
	SetString( 810 , "2 ");
	SetString( 815 , "3 ");
	SetString( 820 , "Nouveau  ");
	SetString( 825 , "contour ");
	SetString( 830 , "Remplacer ");
	SetString( 835 , "Fin ");
	SetString( 840 , "Insertion de point ");
	SetString( 845 , "Effacement de point  ");
	SetString( 850 , "Dplacement de point  ");
	SetString( 855 , "Bouton gauche de la sourie  ");
	SetString( 860 , "pour crer le contour. ");
	SetString( 865 , "Atention ");
	SetString( 870 , "Cette option efface tous les contours 3D. ");
	SetString( 875 , "Voulez-vous continuer ? ");
	SetString( 905 , "Dfinissez  un  point initial. ");
	SetString( 910 , "(Double clique sur le vaisseau d'intrt.) ");
	SetString( 915 , "Le point initial doit tre ");
	SetString( 920 , "loin des bords du volume. ");
	SetString( 925 , "Seuil ");
	SetString( 930 , "Intensit du Lumen % ");
	SetString( 935 , "Intensit des calcifications % ");
	SetString( 940 , "Control du contour ");

}
//-----------------------------------------------------
void marDictionary::LoadDictionary_Japanese (){
	ResetDictionary();
	SetLanguage(3);
}
//-----------------------------------------------------
void marDictionary::FreeDictionary(){
	int i,size=_frases->size();
	for (i=0;i < size;i++){
		marDictFrase* tmp=(*_frases)[i];
		delete tmp;
	}
	_frases->clear();
} 

//-----------------------------------------------------
void marDictionary::SetLanguage(int language){
	_language=language;
}
//-----------------------------------------------------
char* marDictionary::GetString(int idfrase){
	int i,size;	
   	char *result=NULL;
	size=_frases->size();
	for (i=0;i<size;i++){
		marDictFrase* tmp=(*_frases)[i];
		if (tmp->GetIdFrase()==idfrase){
			result=tmp->GetFrase();
		}
	}
	if (result==NULL){
	    sprintf(_emptyStr,"(...%d-%d...)",_language,idfrase);
		result=_emptyStr;
	}
	return result;
}
//-----------------------------------------------------
int	marDictionary::GetLanguage(){
	return _language;
}
//-----------------------------------------------------
void marDictionary::SetString(int id,char *ss){
	if (_frases!=NULL){
		marDictFrase *mf = new marDictFrase(id,ss);
		_frases->push_back(mf);
	}
}

//-----------------------------------------------------
