/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas3DBrowser.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracas3DBrowser.h"
//#include <Crtdbg.h>


wxMaracas3DBrowser::wxMaracas3DBrowser( wxWindow* parent, marInterface* mar, wxWindowID id , int id_toolbar_plans  )
    : wxPanel( parent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL )
{
    _mar = mar;

    _3DSurf = new wxSurfaceWidget( this, -1 );
	_3DSurf->SetId_toolbar_plans(id_toolbar_plans);

    wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
    szTop->Add( _3DSurf, 1, wxEXPAND | wxALL, 0 );

    this->SetAutoLayout( true );
    this->SetSizer( szTop );

//    szTop->Fit( this );
    szTop->SetSizeHints( this );

}
//----------------------------------------------------------------------------
void wxMaracas3DBrowser::LoadData( ){
    _3DSurf->ShowMARACASData( _mar );
}
//----------------------------------------------------------------------------
int wxMaracas3DBrowser::GetIsovalue(){
	int result=0;
	if (_3DSurf!=NULL){
		result=_3DSurf->GetIsovalue();
	}
	return result;
}
//----------------------------------------------------------------------------
int wxMaracas3DBrowser::GetOpacity(){
	int result=0;
	if (_3DSurf!=NULL){
		result=_3DSurf->GetOpacity();
	}
	return result;
}
//----------------------------------------------------------------------------
void wxMaracas3DBrowser::RegenerateAll(bool all){
	if (_3DSurf!=NULL){
		_3DSurf->Clean3D();
		if (all==true){
			_mar->_experiment->RegenerateAxis();
		} else {
			_mar->_experiment->RecalculateAxis();
		}
		_3DSurf->AddAxisActors();	
		_3DSurf->RefreshAxis();	
	}
}
//----------------------------------------------------------------------------

// EOF - wxMaracas3DBrowser.cxx

