/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxMaracasApp.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:14:56 $
 Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


/*!
 \mainpage wxMaracas version wxWindows

 \section intro Introduction

 This is the introduction. 







  \dot


digraph example_0 {
	rankdir=LR
	graph [ ratio=fill];
    node [shape=record, fontname=Helvetica, fontsize=10];

	___wxMaracasFrame03			[ label="wxMaracasFrame03"	URL="\ref wxMaracasFrame03"];
	___wxMaracasApp02			[ label="wxMaracasApp02"	URL="\ref wxMaracasApp02"];
	__wxMaracasFrame02			[ label="wxMaracasFrame02"	URL="\ref wxMaracasFrame02"];
	__wxMaracasApp02			[ label="wxMaracasApp02"	URL="\ref wxMaracasApp02"];
	_wxMaracasFrame				[ label="wxMaracasFrame"	URL="\ref wxMaracasFrame"];
	_wxMaracasApp				[ label="wxMaracasApp"		URL="\ref wxMaracasApp"];

	_wxMaracas3DBrowser			[ label="wxMaracas3DBrowser"			URL="\ref wxMaracas3DBrowser"];
	_wxMaracasQuantification	[ label="wxMaracasQuantification"		URL="\ref wxMaracasQuantification"];


	__wxMaracasDataBrowser		[ label="wxMaracasDataBrowser"			URL="\ref wxMaracasDataBrowser"];
	__wxMaracasImageBrowser		[ label="wxMaracasImageBrowser"			URL="\ref wxMaracasImageBrowser"];
	__wxMaracasImageBrowser02	[ label="wxMaracasImageBrowser02"		URL="\ref wxMaracasImageBrowser02" ];
	__wxMaracas3DBrowser		[ label="wxMaracas3DBrowser"			URL="\ref wxMaracas3DBrowser"];
	__wxMaracasQuantification	[ label="wxMaracasQuantification"		URL="\ref wxMaracasQuantification"];
	__wxMaracasQuantificationCT	[ label="wxMaracasQuantificationCT"		URL="\ref wxMaracasQuantificationCT"];
	__wxMaracasMPR				[ label="wxMaracasMPR"					URL="\ref wxMaracasMPR"];
	__wxMaracasProcessingCT		[ label="wxMaracasProcessingCT"			URL="\ref wxMaracasProcessingCT"];
	__wxMaracasEmptyPanel		[ label="wxMaracasEmptyPanel"			URL="\ref wxMaracasEmptyPanel"];
	__wxMaracasEmptyPanel_2		[ label="wxMaracasEmptyPanel_2"			URL="\ref wxMaracasEmptyPanel_2"];
	__wxSurfaceSTLWidget		[ label="wxSurfaceSTLWidget"			URL="\ref wxSurfaceSTLWidget"];
	__wxILPD					[ label="wxILPD"						URL="\ref wxILPD"];


	_wxMaracasApp		-> _wxMaracasFrame 			
	_wxMaracasFrame		-> _wxMaracas3DBrowser 		
	_wxMaracasFrame		-> _wxMaracasQuantification 

	__wxMaracasApp02	-> __wxMaracasFrame02 		
	__wxMaracasFrame02	-> __wxMaracasDataBrowser 	
	__wxMaracasFrame02	-> __wxMaracasImageBrowser 	
	__wxMaracasFrame02	-> __wxMaracasImageBrowser02 
	__wxMaracasFrame02	-> __wxMaracas3DBrowser 
	__wxMaracasFrame02	-> __wxMaracasQuantification
	__wxMaracasFrame02	-> __wxMaracasQuantificationCT 
	__wxMaracasFrame02	-> __wxMaracasMPR 	
	__wxMaracasFrame02	-> __wxMaracasProcessingCT 
	__wxMaracasFrame02	-> __wxMaracasEmptyPanel
	__wxMaracasFrame02	-> __wxMaracasEmptyPanel_2
	__wxMaracasFrame02	-> __wxSurfaceSTLWidget 
	__wxMaracasFrame02	-> __wxILPD 


	___wxMaracasImageBrowser02	[ label="wxMaracasImageBrowser02"		URL="\ref wxMaracasImageBrowser02"];
	___wxMaracas3DBrowser		[ label="wxMaracas3DBrowser"			URL="\ref wxMaracas3DBrowser"];
	___wxMaracasQuantification	[ label="wxMaracasQuantification"		URL="\ref wxMaracasQuantification"];
	___wxMaracasQuantificationCT[ label="wxMaracasQuantificationCT"		URL="\ref wxMaracasQuantificationCT"];
	___wxMaracasMPR				[ label="wxMaracasMPR"					URL="\ref wxMaracasMPR"];
	___wxMaracasProcessingCT	[ label="wxMaracasProcessingCT"			URL="\ref wxMaracasProcessingCT"];
	___wxMaracasEmptyPanel_2	[ label="wxMaracasEmptyPanel_2"			URL="\ref wxMaracasEmptyPanel_2"];
	___wxSurfaceSTLWidget		[ label="wxSurfaceSTLWidget"			URL="\ref wxSurfaceSTLWidget"];
	___wxILPDwithImage			[ label="wxILPDwithImage"				URL="\ref wxILPDwithImage"];
	___wxMaracasEmptyPanel_3	[ label="wxMaracasEmptyPanel_3"			URL="\ref wxMaracasEmptyPanel_3"];


	___wxMaracasNoteBookPatientLstVoi			[ label="wxMaracasNoteBookPatientLstVoi"			URL="\ref wxMaracasNoteBookPatientLstVoi"];
	___wxMaracasNoteBookCTQuantification		[ label="wxMaracasNoteBookCTQuantification"			URL="\ref wxMaracasNoteBookCTQuantification"];
	___wxMaracasNoteBookIRMQuantification		[ label="wxMaracasNoteBookIRMQuantification"		URL="\ref wxMaracasNoteBookIRMQuantification"];
	___wxMaracasNoteBookSTLFormat				[ label="wxMaracasNoteBookSTLFormat"				URL="\ref wxMaracasNoteBookSTLFormat"];
	___wxMaracasNoteBookTests					[ label="wxMaracasNoteBookTests"					URL="\ref wxMaracasNoteBookTests"];
	___wxMaracasNoteBookVascularTreeExtraction	[ label="wxMaracasNoteBookVascularTreeExtraction"	URL="\ref wxMaracasNoteBookVascularTreeExtraction"];


	___wxMaracasApp02	-> ___wxMaracasFrame03 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookPatientLstVoi 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookCTQuantification 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookIRMQuantification 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookSTLFormat 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookTests 		
	___wxMaracasFrame03	-> ___wxMaracasNoteBookVascularTreeExtraction 		



	___wxMaracasNoteBookPatientLstVoi			-> ___wxILPDwithImage
	___wxMaracasNoteBookPatientLstVoi			-> ___wxMaracasImageBrowser02
	___wxMaracasNoteBookPatientLstVoi			-> ___wxMaracasMPR

	___wxMaracasNoteBookCTQuantification		-> ___wxMaracasMPR
	___wxMaracasNoteBookCTQuantification		-> ___wxMaracasProcessingCT
	___wxMaracasNoteBookCTQuantification		-> ___wxMaracasQuantificationCT

	___wxMaracasNoteBookIRMQuantification		-> ___wxMaracas3DBrowser
	___wxMaracasNoteBookIRMQuantification		-> ___wxMaracasQuantification

	___wxMaracasNoteBookSTLFormat				-> ___wxMaracas3DBrowser
	___wxMaracasNoteBookSTLFormat				-> ___wxSurfaceSTLWidget

	___wxMaracasNoteBookTests					-> ___wxMaracasEmptyPanel_3

	___wxMaracasNoteBookVascularTreeExtraction	-> ___wxMaracasEmptyPanel_2

}

\enddot









\dot

digraph example {
	graph [ ratio=fill];
    node [shape=record, fontname=Helvetica, fontsize=10];

	subgraph subgraph_App {
		rank = same;
		_wxMaracasApp			[ label="wxMaracasApp"				URL="\ref wxMaracasApp"];
    _wxMaracasApp02			[ label="wxMaracasApp02"			URL="\ref wxMaracasApp02"];
	}
	subgraph subgraph_Frame {
		rank = same;
		_wxMaracasFrame			[ label="wxMaracasFrame"			URL="\ref wxMaracasFrame"];
		_wxMaracasFrame02		[ label="wxMaracasFrame02"			URL="\ref wxMaracasFrame02"];
		_wxMaracasFrame03		[ label="wxMaracasFrame03"			URL="\ref wxMaracasFrame03"];
	}

	subgraph cluster_000 {
		label = "Interface Pages"
		style=filled;
		color=lightgrey;
		rank = same;
		_wxMaracasNoteBookPatientLstVoi			[ label="wxMaracasNoteBookPatientLstVoi"			URL="\ref wxMaracasNoteBookPatientLstVoi"];
		_wxMaracasNoteBookCTQuantification		[ label="wxMaracasNoteBookCTQuantification"			URL="\ref wxMaracasNoteBookCTQuantification"];
		_wxMaracasNoteBookIRMQuantification		[ label="wxMaracasNoteBookIRMQuantification"		URL="\ref wxMaracasNoteBookIRMQuantification"];
		_wxMaracasNoteBookSTLFormat				[ label="wxMaracasNoteBookSTLFormat"				URL="\ref wxMaracasNoteBookSTLFormat"];
		_wxMaracasNoteBookTests					[ label="wxMaracasNoteBookTests"					URL="\ref wxMaracasNoteBookTests"];
		_wxMaracasNoteBookVascularTreeExtraction[ label="wxMaracasNoteBookVascularTreeExtraction"	URL="\ref wxMaracasNoteBookVascularTreeExtraction"];
		_wxMaracasNoteBookManualRegistration	[ label="wxMaracasNoteBookManualRegistration"		URL="\ref wxMaracasNoteBookManualRegistration"];
	}

	subgraph cluster_PersistanceConfiguration {
		label = "Persistance Configuration"
		style=filled;
		color=lightgrey;
		rank = same;
		_wxReadWriteConf						[ label="wxReadWriteConf"			URL="\ref wxReadWriteConf"];
		_FileInformationModel					[ label="FileInformationModel"		URL="\ref FileInformationModel"];
		_FileInfoNode							[ label="FileInfoNode"				URL="\ref FileInfoNode"];


	}

	subgraph cluster_001 {
		style=filled;
		color=lightgrey;
		rank = same;
		_wxMaracasDataBrowser		[ label="wxMaracasDataBrowser"			URL="\ref wxMaracasDataBrowser"];
		_wxMaracasImageBrowser		[ label="wxMaracasImageBrowser"			URL="\ref wxMaracasImageBrowser"];
		_wxMaracasImageBrowser02	[ label="wxMaracasImageBrowser02"		URL="\ref wxMaracasImageBrowser02"];
		_wxMaracas3DBrowser			[ label="wxMaracas3DBrowser"			URL="\ref wxMaracas3DBrowser"];
		_wxMaracasQuantification	[ label="wxMaracasQuantification"		URL="\ref wxMaracasQuantification"];
		_wxMaracasMPR				[ label="wxMaracasMPR"					URL="\ref wxMaracasMPR"];
		_wxMaracasEmptyPanel		[ label="wxMaracasEmptyPanel"			URL="\ref wxMaracasEmptyPanel"];
		_wxMaracasEmptyPanel_2		[ label="wxMaracasEmptyPanel_2"			URL="\ref wxMaracasEmptyPanel_2"];
		_wxMaracasEmptyPanel_3		[ label="wxMaracasEmptyPanel_3"			URL="\ref wxMaracasEmptyPanel_3"];
		_wxILPDwithImage			[ label="wxILPDwithImage"				URL="\ref wxILPDwithImage"];

		subgraph cluster_00STL {
			rank=same;
			_wxSurfaceSTLWidget			[ label="wxSurfaceSTLWidget"			URL="\ref wxSurfaceSTLWidget"];
			_wxSTLWidget_02				[ label="wxSTLWidget_02"				URL="\ref wxSTLWidget_02"];
			_wxSTLWidget_03				[ label="wxSTLWidget_03"				URL="\ref wxSTLWidget_03"];
		}

		_wxMaracas_ManualTree_MPR	[ label="wxMaracas_ManualTree_MPR"		URL="\ref wxMaracas_ManualTree_MPR"];

		_wxManualRegistration3D		[ label="wxManualRegistration3D"		URL="\ref wxManualRegistration3D"];
	
		subgraph cluster_00NN {
			rank=same;
			_wxMaracasQuantificationCT	[ label="wxMaracasQuantificationCT"		URL="\ref wxMaracasQuantificationCT"];
			_wxMaracasProcessingCT		[ label="wxMaracasProcessingCT"			URL="\ref wxMaracasProcessingCT"];
		}

	}


	subgraph cluster_Widgets {
		label = "Imprtant Widgets";
		style=filled;
		color=lightgrey;
		_wxProcessingCTWidget	    [ label="wxProcessingCTWidget"		URL="\ref wxProcessingCTWidget" fillcolor=yellow style=filled];
		_wxEmptyPanelWidget			[ label="wxEmptyPanelWidget"		URL="\ref wxEmptyPanelWidget"];
		_wxEmptyPanelWidget_2	    [ label="wxEmptyPanelWidget_2"		URL="\ref wxEmptyPanelWidget_2"];
		_wxManualTree_MPRWidget	    [ label="wxManualTree_MPRWidget"	URL="\ref wxManualTree_MPRWidget"];
		_wxQuantificationWidget		[ label="wxQuantificationWidget"			URL="\ref wxQuantificationWidget"];
		_wxQuantificationWidgetCT	[ label="wxQuantificationWidgetCT"			URL="\ref wxQuantificationWidgetCT"  fillcolor=yellow style=filled];
		_vtk3DSurfaceSTLWidget		[ label="vtk3DSurfaceSTLWidget"		URL="\ref vtk3DSurfaceSTLWidget"];
	}

	_wxSurfaceWidget						[ label="wxSurfaceWidget"			URL="\ref wxSurfaceWidget"];
	_wxVTKRenderWindowInteractor			[ label=" wxVTKRenderWindowInteractor"	URL="\ref wxVTKRenderWindowInteractor"];
	_wxVTKRenderWindowInteractorEditContour	[ label=" wxVTKRenderWindowInteractorEditContour"	URL="\ref wxVTKRenderWindowInteractorEditContour"];
	_vtk3DSurfaceWidget						[ label="vtk3DSurfaceWidget"		URL="\ref vtk3DSurfaceWidget"];
	_InterfaceVtkPanelWidgets				[ label="InterfaceVtkPanelWidgets"	URL="\ref InterfaceVtkPanelWidgets"];

	subgraph cluster_marInterface {
		label = "marInterface";
		style=filled;
		color=lightgrey;
		_marInterface				[ label="marInterface"				URL="\ref marInterface"];
		_marParameters				[ label="marParameters"				URL="\ref marParameters"];
		_marExperiment				[ label="marExperiment"				URL="\ref marExperiment"];
		_marObject					[ label="marObject"					URL="\ref marObject"];
		_marDynData					[ label="marDynData"				URL="\ref marDynData"];
		_kVolume					[ label="kVolume"					URL="\ref kVolume"];
		_marAxis					[ label="marAxis"					URL="\ref marAxis"];
	} 

	subgraph cluster_002 {
		label = "Load Dicom Images";
		style=filled;
		color=lightgrey;
		_LoadRangeImage			[ label="LoadRangeImage"			URL="\ref LoadRangeImage"];
		_marGdcmDicom			[ label="marGdcmDicom"				URL="\ref marGdcmDicom"];
		_marGdcmDicomILPD		[ label="marGdcmDicomILPD"			URL="\ref marGdcmDicomILPD"];
		_marSimpleDicom			[ label="marSimpleDicom"			URL="\ref marSimpleDicom"];
		_marRAWFiles			[ label="marRAWFiles"				URL="\ref marRAWFiles"];
		_marRAW2Files			[ label="marRAW2Files"				URL="\ref marRAW2Files"];
		_marFilesBase   		[ label="marFilesBase"				URL="\ref marFilesBase"];
	}

	subgraph subgraph_003 {
		rank = same;
		node [style=rounded]

		_axisExtractor          [ label="axisExtractor"             URL="\ref axisExtractor"   fillcolor=yellow style=filled];
		_axisExtractor02		[ label="axisExtractor02"			URL="\ref axisExtractor02" fillcolor=yellow style=filled];	
	}
	_TreeExtraction_MH_JFC		[ label="TreeExtraction_MH_JFC"		URL="\ref TreeExtraction_MH_JFC"				 ];
	_carotidaBifurcacion		[ label="carotidaBifurcacion"		URL="\ref carotidaBifurcacion"	fillcolor=yellow style=filled];

subgraph cluster_MPRxxx {
		_wxMPRWidget					[ label="wxMPRWidget"					URL="\ref wxMPRWidget"];
		_wxMPRWidget2					[ label="wxMPRWidget2"					URL="\ref wxMPRWidget2"];
		_wxMaracas_ViewerWidget			[ label="wxMaracas_ViewerWidget"		URL="\ref wxMaracas_ViewerWidget"];
		_wxMaracas_N_ViewersWidget		[ label="wxMaracas_N_ViewersWidget"		URL="\ref wxMaracas_N_ViewersWidget"];

	subgraph cluster_2D3DBaseViewer {
		label = "2D 3D Base Viewer (Maracas+VTK+WxWindow)";
		style=filled;
		color=lightgrey;

		subgraph cluster_base_base {
			label = "base base ";
			style=filled;
			color=gray71;
			_wxVtkBaseView					[ label="wxVtkBaseView"					URL="\ref wxVtkBaseView"];
			_wxVtk2DView_TMP				[ label="wxVtk2DView_TMP"				URL="\ref wxVtk2DView_TMP"];
			_vtkImageViewer2_XYZ			[ label="vtkImageViewer2_XYZ"			URL="\ref vtkImageViewer2_XYZ"];
			_wxVtk2DBaseView				[ label="wxVtk2DBaseView"				URL="\ref wxVtk2DBaseView"];
			_wxVtk3DBaseView				[ label="wxVtk3DBaseView"				URL="\ref wxVtk3DBaseView"];
		} // cluster_base_base

		subgraph cluster_2DViewer {
			_wxVtkMPR2DView					[ label="wxVtkMPR2DView"				URL="\ref wxVtkMPR2DView"];
			_wxSphereView					[ label="wxSphereView"					URL="\ref wxSphereView"];
			_vtkPlane2DView					[ label="vtkPlane2DView"				URL="\ref vtkPlane2DView"];
		} // cluster_2DViewer

		subgraph cluster_Clipping3D {
			label = "Clipping 3D Viewer ";
			style=filled;
			color=gray71;
			_vtkClipping3DDataViewer 		[ label="vtkClipping3DDataViewer"		URL="\ref vtkClipping3DDataViewer"];
			_wxVtkClipping3DViewCntrlPanel	[ label="wxVtkClipping3DViewCntrlPanel" URL="\ref wxVtkClipping3DViewCntrlPanel"];
			_wxVtkClipping3DView			[ label="wxVtkClipping3DView"			URL="\ref wxVtkClipping3DView"];
		} //cluster_Clipping3D


		subgraph cluster_ViewerDATA {
			label = "Viewer DATA ";
			style=filled;
			color=gray71;
			_vtkBaseData				[ label="vtkBaseData"					URL="\ref vtkBaseData"];
			_vtkMPRBaseData				[ label="vtkMPRBaseData"				URL="\ref vtkMPRBaseData"];
			_vtkMPR3DDataViewer 		[ label="vtkMPR3DDataViewer"			URL="\ref vtkMPR3DDataViewer"];
		} // cluster_ViewerDATA

		subgraph cluster_MPR3DView {
			label = " MPR3D View ";
			style=filled;
			color=gray71;
			_wxVtkMPR3DView					[ label="wxVtkMPR3DView"				URL="\ref wxVtkMPR3DView"];
			_wxVtkMPR3DViewCntrlPanel 		[ label="wxVtkMPR3DViewCntrlPanel"		URL="\ref wxVtkMPR3DViewCntrlPanel"]; 
		} // cluster_MPR3DView

  } // cluster_2D3DBaseViewer
} // cluster_MPRxxx


	subgraph cluster_3DViewer {
		label = "3D Viewer (Maracas+VTK+WxWindow)";
		style=filled;
		color=lightgrey;
		_boxSurfaceObserver 			[ label="boxSurfaceObserver"			URL="\ref boxSurfaceObserver"];
		_boxVolumeObserver 				[ label="boxVolumeObserver"		     	URL="\ref boxVolumeObserver"];

		_vtkmyPWCallback_3DPointWidget	[ label="vtkmyPWCallback_3DPointWidget"	URL="\ref vtkmyPWCallback_3DPointWidget"];
	}


	_vtkInteractorStyleCutter		[ label="vtkInteractorStyleCutter"	URL="\ref vtkInteractorStyleCutter"];
	_vtkImagePolyDataSeedConnectivity	[ label="vtkImagePolyDataSeedConnectivity"		URL="\ref vtkImagePolyDataSeedConnectivity"];
	_wxImageViewerWidgetRoi			[ label="wxImageViewerWidgetRoi"	URL="\ref wxImageViewerWidgetRoi"];

	subgraph subgraph_005 {
		_marZoomROIObserver 				[ label="marZoomROIObserver"				URL="\ref marZoomROIObserver"];
		_wxImageViewerWidget				[ label="wxImageViewerWidget"				URL="\ref wxImageViewerWidget"];
	}

	_vtk2DQuantSliceWidget					[ label="vtk2DQuantSliceWidget"				URL="\ref vtk2DQuantSliceWidget"];

	subgraph cluster0 {
		label = "Manual Contour";
		style=filled;
		color=lightgrey;
		_manualContourModel					[ label="manualContourModel"				URL="\ref manualContourModel"];

		_manualViewBaseContour				[ label="manualViewBaseContour"				URL="\ref manualViewBaseContour"];
		_manualViewContour					[ label="manualViewContour"					URL="\ref manualViewContour"];
		_manualView3VContour				[ label="manualView3VContour"				URL="\ref manualView3VContour"];
		_manualView3DContour				[ label="manualView3DContour"				URL="\ref manualView3DContour"];
		_manualViewPerpPlaneContour         [ label="manualViewPerpPlaneContour"		URL="\ref manualViewPerpPlaneContour"];

		
		_manualViewRoi						[ label="manualViewRoi"						URL="\ref manualViewRoi"];
		  

		_manualContourBaseControler			[ label="manualContourBaseControler"		URL="\ref manualContourBaseControler"];
		_manualContourControler				[ label="manualContourControler"			URL="\ref manualContourControler"];
		_manualContour3VControler			[ label="manualContour3VControler"			URL="\ref manualContour3VControler"];
		_manualContour3DControler			[ label="manualContour3DControler"			URL="\ref manualContour3DControler"];
		_manualContour3V3DControler			[ label="manualContour3V3DControler"		URL="\ref manualContour3V3DControler"];
		_manualContourPerpPlaneControler	[ label="manualContourPerpPlaneControler"	URL="\ref manualContourPerpPlaneControler"];
		_manualRoiControler					[ label="manualRoiControler"				URL="\ref manualRoiControler"];

		_manualViewPoint					[ label="manualViewPoint"					URL="\ref manualViewPoint"];
		_manualPoint						[ label="manualPoint"						URL="\ref manualPoint"];

	}		

	subgraph cluster_interactor {
		label = "Interactors";
		style=filled;
		color=lightgrey;
		_vtkInteractorStyleBaseView			[ label="vtkInteractorStyleBaseView"		URL="\ref vtkInteractorStyleBaseView"];
		_vtkInteractorStyleBaseView2D		[ label="vtkInteractorStyleBaseView2D"		URL="\ref vtkInteractorStyleBaseView2D"];
		_vtkInteractorStyleBaseView3D		[ label="vtkInteractorStyleBaseView3D"		URL="\ref vtkInteractorStyleBaseView3D"];					
		_vtkInteractorStyle3DView			[ label="vtkInteractorStyle3DView"			URL="\ref vtkInteractorStyle3DView"];			
		_vtkInfoTextImageInteractor			[ label="vtkInfoTextImageInteractor"		URL="\ref vtkInfoTextImageInteractor"];
		_vtkInfoTextImageInteractorPlane2D	[ label="vtkInfoTextImageInteractorPlane2D"	URL="\ref vtkInfoTextImageInteractorPlane2D"];
		_vtkInfoTextImage					[ label="vtkInfoTextImage"					URL="\ref vtkInfoTextImage"];
		_vtkInteractorStyleMPRView			[ label="vtkInteractorStyleMPRView"			URL="\ref vtkInteractorStyleMPRView"];
		_vtkInteractorStylePlane2D			[ label="vtkInteractorStylePlane2D"			URL="\ref vtkInteractorStylePlane2D"];
		_vtkInteractorStyleSphere			[ label="vtkInteractorStyleSphere"			URL="\ref vtkInteractorStyleSphere"];
		_InteractorStyleMaracas				[ label="InteractorStyleMaracas"			URL="\ref InteractorStyleMaracas"];	
		_vtkInteractorScrollZ				[ label="vtkInteractorScrollZ"				URL="\ref vtkInteractorScrollZ"];			
		_manualInteractorWindowLevel		[ label="manualInteractorWindowLevel"		URL="\ref manualInteractorWindowLevel"];			

  }

    subgraph cluster_uniandeskernel {
		label = "Kernel CT (uniandes)";
		style=filled;
		color=lightgrey;
		_marAxisContours			[ label="marAxisContours"			URL="\ref marAxisContours"	fillcolor=yellow style=filled];
		_marAxisCT					[ label="marAxisCT"					URL="\ref marAxisCT" 	fillcolor=yellow style=filled];
		_marContourVO				[ label="marContourVO"						URL="\ref marContourVO" 	fillcolor=yellow style=filled];
		_marExperimentCT			[ label="marExperimentCT"				URL="\ref marExperimentCT"	fillcolor=yellow style=filled];
		_marInterfaceCT				[ label="marInterfaceCT"					URL="\ref marInterfaceCT"	fillcolor=yellow style=filled];
		_marIsocontour				[ label="marIsocontour"					URL="\ref marIsocontour"	fillcolor=yellow style=filled];
		_marPoint					[ label="marPoint"					URL="\ref marPoint"	fillcolor=yellow style=filled];
	}

  subgraph cluster_uniandesvisual {
		label = "Visualization CT (uniandes)";
		style=filled;
		color=lightgrey;
		_ContourView				[ label="ContourView"			URL="\ref ContourView"	fillcolor=yellow style=filled];
		_PointView					[ label="PointView"					URL="\ref PointView" 	fillcolor=yellow style=filled];
		_LineView					[ label="LineView"						URL="\ref LineView" 	fillcolor=yellow style=filled];
		_wxPnlContourControl		[ label="wxPnlContourControl"				URL="\ref wxPnlContourControl"	fillcolor=yellow style=filled];
		
	}

subgraph cluster_006 {
		label = "Thread";
		style=filled;
		color=lightgrey;
		_PriorityLoadImageBar			[ label="PriorityLoadImageBar"			URL="\ref PriorityLoadImageBar"];
		_BarLoading						[ label="BarLoading"					URL="\ref BarLoading"];
		_BarRange						[ label="BarRange"						URL="\ref BarRange"];
		_MyThread						[ label="MyThread"						URL="\ref MyThread"];
		_AdminThreadEED					[ label="AdminThreadEED"				URL="\ref AdminThreadEED"];
		_PriorityLoop					[ label="PriorityLoop"					URL="\ref PriorityLoop"];
}

		_vtkInteractorStyle2DMaracas		[ label="vtkInteractorStyle2DMaracas"		URL="\ref vtkInteractorStyle2DMaracas"];
		_wxQuantificationWidget_base		[ label="wxQuantificationWidget_base"		URL="\ref wxQuantificationWidget_base"];
		_wxPanelControlsHealthySickSlice2	[ label="wxPanelControlsHealthySickSlice2"	URL="\ref wxPanelControlsHealthySickSlice2"];


		_vtk3DQuantSurfaceWidget		[ label="vtk3DQuantSurfaceWidget"		URL="\ref vtk3DQuantSurfaceWidget"];
		_RectangleGuideVtk				[ label="RectangleGuideVtk"				URL="\ref RectangleGuideVtk"];


subgraph cluster_figureCutting {
		label = "Figure Cutting";
		style=filled;
		color=lightgrey;

		_wxPanelCuttingImageData		[ label="wxPanelCuttingImageData"		URL="\ref wxPanelCuttingImageData"];
		_figureCuttingModel				[ label="figureCuttingModel"			URL="\ref figureCuttingModel"];

		_figureCuttingCubeModel			[ label="figureCuttingCubeModel"		URL="\ref figureCuttingCubeModel"];
		_figureCuttingCylinderModel		[ label="figureCuttingCylinderModel"	URL="\ref figureCuttingCylinderModel"];
		_figureCuttingSphereModel		[ label="figureCuttingSphereModel"		URL="\ref figureCuttingSphereModel"];
}
		

subgraph cluster_mesure_tools {
		label = "Mesure tools widgets";
		style=filled;
		color=lightgrey;

		_wxWidgetMesure2D				[ label="wxWidgetMesure2D"				URL="\ref wxWidgetMesure2D"];
		_wxWidgetMesure2D_Plane			[ label="wxWidgetMesure2D_Plane"		URL="\ref wxWidgetMesure2D_Plane"];
		_wxWidgetMesure2D_Plane_in_MPR	[ label="wxWidgetMesure2D_Plane_in_MPR"	URL="\ref wxWidgetMesure2D_Plane_in_MPR"];
}

		_marImageData	[ label="marImageData"	URL="\ref marImageData"];


	  _wxMaracasApp		-> _wxMaracasFrame				[ arrowhead="open", style="dashed" ];
      _wxMaracasFrame	-> _wxMaracas3DBrowser			[ arrowhead="open", style="dashed" ];
      _wxMaracasFrame	-> _wxMaracasQuantification		[ arrowhead="open", style="dashed" ];

      _wxMaracasApp02	-> _wxMaracasFrame02			[ arrowhead="open", style="dashed" ];

//      _wxMaracasFrame02	-> _wxMaracasDataBrowser		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasImageBrowser		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasImageBrowser02		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracas3DBrowser			[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasQuantification		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasQuantificationCT	[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasMPR				[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasProcessingCT		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasEmptyPanel			[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxMaracasEmptyPanel_2		[ arrowhead="open", style="dashed" ];
//      _wxMaracasFrame02	-> _wxSurfaceSTLWidget			[ arrowhead="open", style="dashed" ];
//		_wxMaracasFrame02	-> _ILPDViewListPatient			[ arrowhead="open", style="dashed" ];
//		_wxMaracasFrame02	-> _wxILPD						[ arrowhead="open", style="dashed" ];



	_wxMaracasApp02		-> _wxMaracasFrame03 							[ arrowhead="open", style="dashed" ];
	_wxMaracasFrame03	-> _wxMaracasNoteBookPatientLstVoi 				[ arrowhead="open", style="dashed" ];
	_wxMaracasFrame03	-> _wxMaracasNoteBookCTQuantification			[ arrowhead="open", style="dashed" ];	
	_wxMaracasFrame03	-> _wxMaracasNoteBookIRMQuantification 			[ arrowhead="open", style="dashed" ];	
	_wxMaracasFrame03	-> _wxMaracasNoteBookSTLFormat 					[ arrowhead="open", style="dashed" ];
	_wxMaracasFrame03	-> _wxMaracasNoteBookTests 						[ arrowhead="open", style="dashed" ];
	_wxMaracasFrame03	-> _wxMaracasNoteBookVascularTreeExtraction		[ arrowhead="open", style="dashed" ];	
	_wxMaracasFrame03	-> _wxMaracasNoteBookManualRegistration			[ arrowhead="open", style="dashed" ];	


	_wxMaracasNoteBookPatientLstVoi			-> _wxILPD					[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookPatientLstVoi			-> _wxILPDwithImage			[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookPatientLstVoi			-> _wxMaracasImageBrowser02 [ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookPatientLstVoi			-> _wxMaracasMPR			[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookPatientLstVoi			-> _wxReadWriteConf			[ arrowhead="open", style="dashed" ];

	_wxILPDwithImage						-> _wxILPD					[ arrowhead="open", style="dashed" ];
	_wxILPDwithImage						-> _wxVtk2DBaseView			[ arrowhead="open", style="dashed" ];
	_wxILPDwithImage						-> _vtkBaseData				[ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookCTQuantification		-> _wxMaracasMPR			[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookCTQuantification		-> _wxMaracasProcessingCT	[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookCTQuantification		-> _wxMaracasQuantificationCT [ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookCTQuantification		-> _wxReadWriteConf			[ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookIRMQuantification		-> _wxMaracas3DBrowser		[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookIRMQuantification		-> _wxMaracasQuantification [ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookSTLFormat				-> _wxMaracas3DBrowser		[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookSTLFormat				-> _wxSurfaceSTLWidget		[ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookSTLFormat				-> _wxSTLWidget_02			[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookSTLFormat				-> _wxSTLWidget_03			[ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookTests					-> _wxMaracasEmptyPanel_3	[ arrowhead="open", style="dashed" ];
	_wxMaracasNoteBookTests					-> _wxMaracas_ManualTree_MPR [ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookVascularTreeExtraction-> _wxMaracasEmptyPanel_2	[ arrowhead="open", style="dashed" ];

	_wxMaracasNoteBookManualRegistration	-> _wxManualRegistration3D	[ arrowhead="open", style="dashed" ];

	_wxManualRegistration3D	-> _wxPanelCuttingImageData	[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _vtkMPRBaseData			[ arrowhead="open", style="dashed" ];

	_wxManualRegistration3D	-> _marImageData			[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _wxVtk3DBaseView			[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _wxVtkMPR3DView			[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _wxVtkClipping3DView		[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _wxVtkMPR3DView			[ arrowhead="open", style="dashed" ];
	_wxManualRegistration3D	-> _wxVtkClipping3DView		[ arrowhead="open", style="dashed" ];

	  _wxMaracasMPR				->_marInterface					[ arrowhead="open", style="dashed" ];
	  _wxMaracasEmptyPanel		->_wxEmptyPanelWidget			[ arrowhead="open", style="dashed" ];
	  _wxMaracasProcessingCT	->_wxProcessingCTWidget			[ arrowhead="open", style="dashed" ];
	  _wxMaracasEmptyPanel_2	->_wxEmptyPanelWidget_2			[ arrowhead="open", style="dashed" ];
	  _wxSurfaceSTLWidget		->_marInterface					[ arrowhead="open", style="dashed" ];
	  _wxSurfaceSTLWidget		->_vtk3DSurfaceSTLWidget		[ arrowhead="open", style="dashed" ];

	  _wxMaracas3DBrowser		->_marInterface					[ arrowhead="open", style="dashed" ];
	  _wxMaracas3DBrowser		->_wxSurfaceWidget				[ arrowhead="open", style="dashed" ];

	  _wxSurfaceWidget			-> _InterfaceVtkPanelWidgets	[ arrowhead="onormal"			   ];
	  _wxSurfaceWidget			-> _vtk3DSurfaceWidget			[ arrowhead="open", style="dashed" ];
	  _wxSurfaceWidget			-> _marInterface				[ arrowhead="open", style="dashed" ];

	  _vtk3DSurfaceWidget		-> _wxVTKRenderWindowInteractor	[ arrowhead="onormal"   ];
	  _vtk3DSurfaceWidget		-> _marInterface				[ arrowhead="open", style="dashed" ];
	  _vtk3DSurfaceWidget		-> _InterfaceVtkPanelWidgets	[ arrowhead="open", style="dashed" ];

	  _wxMaracas_ManualTree_MPR -> _wxManualTree_MPRWidget		[ arrowhead="open", style="dashed" ];


	  _wxReadWriteConf			-> _FileInformationModel 		[ arrowhead="open", style="dashed" ];
	  _FileInformationModel		-> _FileInfoNode 				[ arrowhead="open", style="dashed" ];


	  _marInterface		-> _marFilesBase			[ arrowhead="open", style="dashed" ];
	  _marInterface		-> _marParameters			[ arrowhead="open", style="dashed" ];
	  _marInterface		-> _marExperiment			[ arrowhead="open", style="dashed" ];

	  _marExperiment	-> _marObject				[ arrowhead="onormal"			   ];
	  _marExperiment	-> _marDynData				[ arrowhead="open", style="dashed" ];
	  _marExperiment	-> _marAxis					[ arrowhead="open", style="dashed" ];

	  _marDynData		-> _marObject				[ arrowhead="onormal"			   ];
	  _marDynData		-> _kVolume					[ arrowhead="open", style="dashed" ];

	  _marAxis			-> _marObject				[ arrowhead="onormal"			   ];
	  _marAxis			-> _kVolume					[ arrowhead="onormal"			   ];

  	  _marFilesBase		-> _marObject				[ arrowhead="onormal"			   ];
	  _marFilesBase		-> _kVolume					[ arrowhead="open", style="dashed" ];

  	  _marSimpleDicom	-> _marFilesBase			[ arrowhead="onormal"			   ];
  	  _marGdcmDicom		-> _marFilesBase			[ arrowhead="onormal"			   ];
  	  _marRAWFiles		-> _marFilesBase			[ arrowhead="onormal"			   ];
  	  _marRAW2Files		-> _marRAWFiles				[ arrowhead="onormal"			   ];
  	  _marGdcmDicomILPD	-> _marGdcmDicom			[ arrowhead="onormal"			   ];

	  _wxMaracasDataBrowser		-> _marInterface			[ arrowhead="open", style="dashed" ];

	  _wxImageViewerWidgetRoi	-> _wxImageViewerWidget		[ arrowhead="onormal"			   ];
	  _wxMaracasImageBrowser	-> _wxImageViewerWidgetRoi	[ arrowhead="open", style="dashed" ];

  	  _wxMaracasImageBrowser02	-> _LoadRangeImage			[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _manualViewRoi			[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _vtkBaseData				[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _wxVtk2DBaseView			[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _manualContourModel		[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _manualRoiControler		[ arrowhead="open", style="dashed" ];
	  _wxMaracasImageBrowser02	-> _marInterface			[ arrowhead="open", style="dashed" ];

 

	  _wxEmptyPanelWidget		-> _wxVtk3DBaseView				[ arrowhead="open", style="dashed" ];
	  _wxEmptyPanelWidget		-> _axisExtractor02				[ arrowhead="open", style="dashed" color=red];

	  _wxProcessingCTWidget		-> _vtkBaseData					[ arrowhead="open", style="dashed" ];
	  _wxProcessingCTWidget		-> _wxVtk2DBaseView				[ arrowhead="open", style="dashed" ];
	  _wxProcessingCTWidget		-> _marInterfaceCT				[ arrowhead="open", style="dashed" ];

	  _wxVtkBaseView			-> _wxVTKRenderWindowInteractor[ arrowhead="open", style="dashed"	];


	  _wxVtk2DBaseView			-> _wxVtkBaseView				[ arrowhead="onormal"				];
	  _wxVtk2DView_TMP			-> _wxVtkBaseView				[ arrowhead="onormal"				];

  	  _wxVtk2DBaseView			-> _vtkBaseData					[ arrowhead="open", style="dashed"	];
	  _wxVtk2DBaseView			-> _vtkImageViewer2_XYZ			[ arrowhead="open", style="dashed"	];

	  _vtkPlane2DView			-> _wxVtk2DBaseView				[ arrowhead="onormal"				];
	  _vtkPlane2DView			-> _vtkMPRBaseData				[ arrowhead="open", style="dashed"	];
	  _vtkPlane2DView			-> _vtkInteractorStylePlane2D	[ arrowhead="open", style="dashed" ];

	  _wxVtkMPR2DView			-> _wxVtk2DBaseView				[ arrowhead="onormal"				];
   	  _wxVtkMPR2DView			-> _vtkInteractorStyleMPRView	[ arrowhead="open", style="dashed" ];

	  _wxSphereView				-> _wxVtk2DBaseView				[ arrowhead="onormal"				];
	  _wxSphereView				-> _vtkMPRBaseData				[ arrowhead="open", style="dashed"	];
	  _wxSphereView				-> _vtkInteractorStyleSphere	[ arrowhead="open", style="dashed"	];



  		_vtkInteractorStyleBaseView		-> _wxVtkBaseView				[ arrowhead="open", style="dashed" ];
  		_wxVtkBaseView					-> _vtkInteractorStyleBaseView	[ arrowhead="open", style="dashed" ];
		_vtkInteractorStyleBaseView		-> _manualInteractorWindowLevel	[ arrowhead="open", style="dashed" ];
		_vtkInteractorStyleBaseView		-> _vtkInteractorScrollZ  		[ arrowhead="open", style="dashed" ];
		_vtkInteractorStyleSphere		-> _InteractorStyleMaracas		[ arrowhead="onormal"			   ];
		_vtkInteractorStyleMPRView		-> _InteractorStyleMaracas		[ arrowhead="onormal"			   ];
		_vtkInteractorStylePlane2D		-> _InteractorStyleMaracas		[ arrowhead="onormal"			   ];
		_vtkInteractorStyle3DView		-> _InteractorStyleMaracas		[ arrowhead="onormal"			   ];


		_vtkInteractorStyleBaseView2D	-> _vtkInteractorStyleBaseView	[ arrowhead="onormal"			   ];
		_vtkInteractorStyleBaseView3D	-> _vtkInteractorStyleBaseView	[ arrowhead="onormal"			   ];


	    _InteractorStyleMaracas		->  _vtkInteractorStyleBaseView		[ arrowhead="open", style="dashed"	];
	    _vtkInteractorStyleBaseView ->  _InteractorStyleMaracas			[ arrowhead="open", style="dashed"	];


		_vtkInteractorScrollZ		-> _InteractorStyleMaracas			[ arrowhead="onormal"			   ];



		_wxManualTree_MPRWidget		-> _wxMPRWidget2					[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _wxVtkClipping3DView 			[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _wxVtk3DBaseView 				[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _wxVtkMPR3DView 					[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _manualContourModel 				[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _manualContour3VControler		[ arrowhead="open", style="dashed" ];
		_wxManualTree_MPRWidget		-> _manualContour3V3DControler 		[ arrowhead="open", style="dashed" ];



		_manualContourBaseControler		->	_InteractorStyleMaracas			[ arrowhead="onormal"				];
		_manualContourBaseControler		->	_manualContourModel				[ arrowhead="open", style="dashed"	];
	    _manualContourBaseControler		->	_manualViewBaseContour			[ arrowhead="open", style="dashed"	];
	    _manualContourControler			->	_manualContourBaseControler		[ arrowhead="onormal"				];
	    _manualContour3VControler		->	_manualContourControler			[ arrowhead="onormal"				];
	    _manualContour3DControler		->	_manualContourControler			[ arrowhead="onormal"				];
	    _manualContour3V3DControler		->	_manualContour3DControler		[ arrowhead="onormal"				];
  		_manualContour3V3DControler		->	_manualContour3VControler		[ arrowhead="open", style="dashed"	];
  		_manualContourPerpPlaneControler->	_manualContourControler			[ arrowhead="onormal"				];
		_manualRoiControler				->	_manualContourBaseControler		[ arrowhead="onormal"				];
	    _manualViewBaseContour			->	_manualContourModel				[ arrowhead="open", style="dashed"	];
		_manualViewBaseContour			->	_manualViewPoint				[ arrowhead="open", style="dashed"	];
		_manualViewBaseContour			->	_wxVtkBaseView					[ arrowhead="open", style="dashed"	];

		_manualContourModel				->	_manualPoint					[ arrowhead="open", style="dashed"	];
		_manualViewContour				->	_manualViewBaseContour			[ arrowhead="onormal"				];
		_manualView3VContour			->	_manualViewContour				[ arrowhead="onormal"				];
		_manualView3DContour			->	_manualViewContour				[ arrowhead="onormal"				];
		_manualViewPerpPlaneContour		->	_manualViewContour				[ arrowhead="onormal"				];
		_manualViewRoi					->	_manualViewBaseContour			[ arrowhead="onormal"				];
		_manualInteractorWindowLevel	->	_InteractorStyleMaracas			[ arrowhead="onormal"				];


	  _wxVtkMPR3DView				-> _wxVtk3DBaseView					[ arrowhead="open", style="dashed"	];
	  _wxVtkMPR3DView				-> _vtkMPR3DDataViewer 				[ arrowhead="open", style="dashed"	];
	  _wxVtkMPR3DView				-> _wxVtkMPR3DViewCntrlPanel  		[ arrowhead="open", style="dashed"	];
 	  _wxVtkMPR3DView				-> _vtkmyPWCallback_3DPointWidget	[ arrowhead="open", style="dashed" ];
	  _vtkmyPWCallback_3DPointWidget-> _wxVtkMPR3DView					[ arrowhead="open", style="dashed" ];

  	  _wxVtk3DBaseView			-> _wxVtkBaseView						[ arrowhead="onormal"				];

	  _wxEmptyPanelWidget_2		-> _wxVtk3DBaseView						[ arrowhead="open", style="dashed"	];
	  _wxEmptyPanelWidget_2		-> _axisExtractor						[ arrowhead="open", style="dashed"	color=red];
	  _wxEmptyPanelWidget_2		-> _axisExtractor02						[ arrowhead="open", style="dashed"	color=red];
	  _wxEmptyPanelWidget_2		-> _marInterface						[ arrowhead="open", style="dashed"	];
	  _wxEmptyPanelWidget_2		-> _wxSurfaceWidget						[ arrowhead="open", style="dashed"	];
	  _wxEmptyPanelWidget_2		-> _TreeExtraction_MH_JFC				[ arrowhead="open", style="dashed"	];
	  _TreeExtraction_MH_JFC	-> _carotidaBifurcacion					[ arrowhead="open", style="dashed"	];

	  _vtk3DSurfaceSTLWidget	-> _wxVTKRenderWindowInteractor			[ arrowhead="onormal"			   ];
	  _vtk3DSurfaceSTLWidget	-> _marInterface						[ arrowhead="open", style="dashed" ];
	  _vtk3DSurfaceSTLWidget	-> _vtkInteractorStyleCutter			[ arrowhead="open", style="dashed" ];
	  _vtk3DSurfaceSTLWidget	-> _vtkImagePolyDataSeedConnectivity	[ arrowhead="open", style="dashed" ];

	  _marZoomROIObserver		->	_wxImageViewerWidget			[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_marZoomROIObserver				[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_manualContourModel				[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_manualViewContour				[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_manualContourControler		    [ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_vtkInteractorStyle2DMaracas	[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_wxVTKRenderWindowInteractorEditContour	[ arrowhead="open", style="dashed"  ];
	  _wxImageViewerWidget		->	_InterfaceVtkPanelWidgets		[ arrowhead="open", style="dashed"  ];


	  _vtk2DQuantSliceWidget	->	_wxImageViewerWidget			[ arrowhead="onormal"				];

	  _wxVTKRenderWindowInteractorEditContour	->	_wxVTKRenderWindowInteractor	[ arrowhead="onormal"				];

	  _wxQuantificationWidget_base	-> _InterfaceVtkPanelWidgets			[ arrowhead="onormal"			    ];
	  _wxQuantificationWidget		-> _wxQuantificationWidget_base			[ arrowhead="onormal"			    ];
	  _wxQuantificationWidgetCT		-> _wxQuantificationWidget_base			[ arrowhead="onormal"			    ];

      _wxMaracasQuantification		-> _marInterface 						[ arrowhead="open", style="dashed" ];
      _wxMaracasQuantification		-> _wxQuantificationWidget 				[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidget		-> _vtk2DQuantSliceWidget 				[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidget		-> _marInterface 						[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidget		-> _wxPanelControlsHealthySickSlice2	[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidget		-> _vtk3DQuantSurfaceWidget 			[ arrowhead="open", style="dashed" ];

      _wxMaracasQuantificationCT	-> _marInterfaceCT 						[ arrowhead="open", style="dashed" ];
      _wxMaracasQuantificationCT	-> _wxQuantificationWidgetCT 			[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidgetCT		-> _vtk2DQuantSliceWidget 				[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidgetCT		-> _marInterfaceCT 						[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidgetCT		-> _wxPanelControlsHealthySickSlice2	[ arrowhead="open", style="dashed" ];
      _wxQuantificationWidgetCT		-> _vtk3DQuantSurfaceWidget 			[ arrowhead="open", style="dashed" ];


  
	   _vtk3DQuantSurfaceWidget		-> _vtk3DSurfaceWidget					[ arrowhead="onormal"			   ];
 	   _vtk3DQuantSurfaceWidget		-> _RectangleGuideVtk					[ arrowhead="open", style="dashed" ];
	

		_vtkMPRBaseData				-> _vtkBaseData							[ arrowhead="onormal"			   ];

		_wxMaracasMPR				->	_wxMPRWidget						[ arrowhead="open", style="dashed" ];
		_wxMPRWidget2				->	_wxMPRWidget						[ arrowhead="onormal"			   ];
		_wxMPRWidget				->	_wxWidgetMesure2D_Plane_in_MPR		[ arrowhead="open", style="dashed" ];
		_wxMPRWidget				->	_wxVtkMPR2DView						[ arrowhead="open", style="dashed" ];
		_wxMPRWidget				->	_wxSphereView						[ arrowhead="open", style="dashed" ];
		_wxMPRWidget				->	_vtkMPRBaseData						[ arrowhead="open", style="dashed" ];
		_wxMPRWidget				->	_wxVtkMPR3DView						[ arrowhead="open", style="dashed" ];
		_wxMPRWidget				->	_wxVtk3DBaseView					[ arrowhead="open", style="dashed" ];


		_wxMaracas_N_ViewersWidget	->	_wxMaracas_ViewerWidget				[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_vtkMPRBaseData						[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxVtk2DBaseView					[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxVtkMPR2DView						[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxWidgetMesure2D_Plane_in_MPR		[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_vtkPlane2DView						[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxVtkClipping3DView				[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxVtk3DBaseView					[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxVtkMPR3DView						[ arrowhead="open", style="dashed" ];
		_wxMaracas_ViewerWidget		->	_wxSphereView						[ arrowhead="open", style="dashed" ];



		_vtkMPR3DDataViewer			->	_vtkMPRBaseData						[ arrowhead="open", style="dashed" ];
		_wxVtkMPR3DViewCntrlPanel	->	_wxVtkMPR3DView						[ arrowhead="open", style="dashed" ];
		

		_wxVtkClipping3DView			->	_wxVtk3DBaseView 				[ arrowhead="open", style="dashed" ];
		_wxMPRWidget					->	_wxVtkClipping3DView			[ arrowhead="open", style="dashed" ];
		_wxVtkClipping3DView			->	_vtkClipping3DDataViewer		[ arrowhead="open", style="dashed" ];
		_vtkClipping3DDataViewer		->  _boxSurfaceObserver 			[ arrowhead="open", style="dashed" ];
		_vtkClipping3DDataViewer		->  _boxVolumeObserver 				[ arrowhead="open", style="dashed" ];
		_vtkClipping3DDataViewer		->	_vtkMPRBaseData					[ arrowhead="open", style="dashed" ];
		_wxVtkClipping3DViewCntrlPanel	->	_wxVtkClipping3DView			[ arrowhead="open", style="dashed" ];
		_wxVtkClipping3DView			->	_wxVtkClipping3DViewCntrlPanel	[ arrowhead="open", style="dashed" ];
	  
		_LoadRangeImage			-> _InterfaceVtkPanelWidgets	[ arrowhead="onormal"			   ];
		_LoadRangeImage			-> _wxImageViewerWidget 		[ arrowhead="open", style="dashed" ];
		_LoadRangeImage			-> _marFilesBase		 		[ arrowhead="open", style="dashed" ];
		_LoadRangeImage			-> _PriorityLoadImageBar 		[ arrowhead="open", style="dashed" ];
		_PriorityLoadImageBar	-> _PriorityLoop				[ arrowhead="onormal"			   ];
		_PriorityLoadImageBar	-> _marGdcmDicom		 		[ arrowhead="open", style="dashed" ];
		_PriorityLoadImageBar	-> _BarLoading			 		[ arrowhead="open", style="dashed" ];
		_LoadRangeImage			-> _BarLoading			 		[ arrowhead="open", style="dashed" ];	
		_LoadRangeImage			-> _BarRange			 		[ arrowhead="open", style="dashed" ];
		_LoadRangeImage			-> _MyThread			 		[ arrowhead="open", style="dashed" ];
		_MyThread				-> _AdminThreadEED				[ arrowhead="open", style="dashed" ];
		_LoadRangeImage			-> _AdminThreadEED				[ arrowhead="open", style="dashed" ];


  	  _vtkInfoTextImageInteractor		-> _InteractorStyleMaracas			[ arrowhead="onormal"			   ];
	  _vtkInfoTextImageInteractor		-> _vtkInfoTextImage				[ arrowhead="open", style="dashed" ];
	  _vtkInfoTextImage					-> _wxVtk2DBaseView					[ arrowhead="open", style="dashed" ];
	  _wxVtk2DBaseView					-> _vtkInfoTextImage				[ arrowhead="open", style="dashed" ];
	  _wxVtk2DBaseView					-> _vtkInfoTextImageInteractor		[ arrowhead="open", style="dashed" ];
	  
  	  _vtkInfoTextImageInteractorPlane2D-> _vtkInfoTextImageInteractor		[ arrowhead="onormal"			   ];


      _marInterfaceCT			-> _marExperimentCT 			[ arrowhead="open", style="dashed" ];
	  _marInterfaceCT			-> _marFilesBase				[ arrowhead="open", style="dashed" ];
	  _marInterfaceCT			-> _marParameters				[ arrowhead="open", style="dashed" ];
	  _marInterfaceCT			-> _marExperiment				[ arrowhead="open", style="dashed" ];
	  _marAxisCT				-> _marIsocontour				[ arrowhead="open", style="dashed" ];
	  _marIsocontour			-> _marPoint 					[ arrowhead="open", style="dashed" ];
	  _marAxis					-> _marAxisContours				[ arrowhead="open", style="dashed" ];
	  _marAxisContours			-> _marContourVO 				[ arrowhead="open", style="dashed" ];
	  _marExperimentCT			-> _marExperiment				[ arrowhead="onormal"			   ];
	  _marAxisCT				-> _marAxis						[ arrowhead="onormal"			   ];

	  
	  _vtk3DSurfaceWidget		-> _marInterfaceCT				[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _ContourView					[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _PointView					[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _LineView					[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualViewContour			[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualViewContour			[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualContourModel			[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualContourModel			[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualContourControler		[ arrowhead="open", style="dashed" ];
	  _wxQuantificationWidgetCT	-> _manualContourControler		[ arrowhead="open", style="dashed" ];
	  _ContourView				-> _wxVtkBaseView				[ arrowhead="open", style="dashed" ];
	  _PointView				-> _wxVtkBaseView				[ arrowhead="open", style="dashed" ];
	  _LineView					-> _wxVtkBaseView				[ arrowhead="open", style="dashed" ];
  

	  _figureCuttingCubeModel			-> _figureCuttingModel					[ arrowhead="onormal"			   ];
	  _figureCuttingCylinderModel		-> _figureCuttingModel					[ arrowhead="onormal"			   ];
	  _figureCuttingSphereModel			-> _figureCuttingModel					[ arrowhead="onormal"			   ];
	  _wxPanelCuttingImageData			-> _wxVtk3DBaseView 					[ arrowhead="open", style="dashed" ];
	  _wxPanelCuttingImageData			-> _figureCuttingModel					[ arrowhead="open", style="dashed" ];
	  _wxPanelCuttingImageData			-> _figureCuttingCubeModel				[ arrowhead="open", style="dashed" ];
	  _wxPanelCuttingImageData			-> _figureCuttingCylinderModel			[ arrowhead="open", style="dashed" ];
	  _wxPanelCuttingImageData			-> _figureCuttingSphereModel			[ arrowhead="open", style="dashed" ];
	  _wxMPRWidget						-> _wxPanelCuttingImageData				[ arrowhead="open", style="dashed" ];


	  _wxWidgetMesure2D_Plane			-> _wxWidgetMesure2D					[ arrowhead="onormal"			   ];
	  _wxWidgetMesure2D_Plane_in_MPR	-> _wxWidgetMesure2D_Plane				[ arrowhead="onormal"			   ];
	  _wxWidgetMesure2D					-> _manualContourControler				[ arrowhead="open", style="dashed" ];
	  _wxWidgetMesure2D					-> _manualViewContour					[ arrowhead="open", style="dashed" ];
	  _wxWidgetMesure2D					-> _manualContourModel 					[ arrowhead="open", style="dashed" ];
	  _wxWidgetMesure2D					-> _wxVtk2DBaseView 					[ arrowhead="open", style="dashed" ];
	  _wxWidgetMesure2D_Plane_in_MPR	-> _vtkPlane2DView 						[ arrowhead="open", style="dashed" ];
 		  
	  
subgraph cluster1 {
	style=filled;
	color=lightgrey;
	label = "ILPD - Interface List Patient Dicom";

	subgraph subgraph_ILPD_003 {
		rank = "same";
		_ILPDViewListPatient		[ label="ILPDViewListPatient "		URL="\ref ILPDViewListPatient"];
		_ILPDViewWxWindow			[ label="ILPDViewWxWindow "			URL="\ref ILPDViewWxWindow "];
		_ILPDViewMFC				[ label="ILPDViewMFC "				URL="\ref ILPDViewMFC "];
	}		

		_ILPDBaseView				[ label="ILPDBaseView "				URL="\ref ILPDBaseView "];
		_wxILPD						[ label="wxILPD "					URL="\ref wxILPD "];
		_mfcILPD					[ label="mfcILPD "					URL="\ref mfcILPD "];
		_ILPD_MySQL 				[ label="ILPD_MySQL "				URL="\ref ILPD_MySQL "];

	subgraph subgraph_ILPD_004 {
		rank = "same";
		_ILPDBaseModel 				[ label="ILPDBaseModel "			URL="\ref ILPDBaseModel "];
		_ILPDBaseDB 				[ label="ILPDBaseDB "				URL="\ref ILPDBaseDB "];
	}

		_MySql 						[ label="MySql "					URL="\ref MySql "];
		_ILPD_Oracle 				[ label="ILPD_Oracle "				URL="\ref ILPD_Oracle "];
		_Oracle 					[ label="Oracle "					URL="\ref Oracle "];
		_ILPDLectureLoic 			[ label="ILPDLectureLoic "			URL="\ref ILPDLectureLoic "];
		_ILPDLectureGDCM 			[ label="ILPDLectureGDCM "			URL="\ref ILPDLectureGDCM "];
		_GDCM 						[ label="GDCM "						URL="\ref GDCM "];
		_Loic						[ label="Loic "						URL="\ref Loic "];

	subgraph subgraph_ILPD_005 {
		rank = "same";
		_ILPDModel 					[ label="ILPDModel "				URL="\ref ILPDModel "];
		_ILPDBaseLecture			[ label="ILPDBaseLecture "			URL="\ref ILPDBaseLecture "];
	}

	subgraph subgraph_ILPD_006 {
		rank	= "same";
		rankdir = "LR";
		_ILPDListPatient 			[ label="ILPDListPatient "			URL="\ref ILPDListPatient "];
		_ILPDPatient				[ label="ILPDPatient"				URL="\ref ILPDPatient "];
		_ILPDStudy					[ label="ILPDStudy "				URL="\ref ILPDStudy "];
		_ILPDSeries					[ label="ILPDSeries "				URL="\ref ILPDSeries "];
		_ILPDImage					[ label="ILPDImage "				URL="\ref ILPDImage "];
	}
		_ILPDBase					[ label="ILPDBase "					URL="\ref ILPDBase "];

	subgraph subgraph_ILPD_007 {
		rank = "same";
		_ILPDNode					[ label="ILPDNode "					URL="\ref ILPDNode "];
		_ILPDControlNode			[ label="ILPDControlNode "			URL="\ref ILPDControlNode "];
	}
		_ILPDControler				[ label="ILPDControler "			URL="\ref ILPDControler"];	


	_ILPD_MySQL 			-> _ILPDBaseDB				[ arrowhead="onormal"	 		   	   ];
	_ILPDBaseModel			-> _ILPDBaseDB				[ arrowhead="open"	style="dashed"	   ];

	_ILPD_MySQL 			-> _MySql					[ arrowhead="open"	style="dashed"	   ];
	_ILPD_Oracle 			-> _Oracle					[ arrowhead="open"	style="dashed"	   ];
	_ILPD_Oracle 			-> _ILPDBaseDB				[ arrowhead="onormal"				   ];
	_ILPDLectureGDCM		-> _GDCM					[ arrowhead="open"	style="dashed"	   ];
	_ILPDLectureLoic		-> _Loic					[ arrowhead="open"	style="dashed"	   ];
	_ILPDLectureGDCM 		-> _ILPDBaseLecture			[ arrowhead="onormal"				   ];
	_ILPDLectureLoic 		-> _ILPDBaseLecture			[ arrowhead="onormal"				   ];
	_ILPDModel				-> _ILPDBaseModel			[ arrowhead="onormal"				   ];
	_ILPDModel				-> _ILPDBaseLecture			[ arrowhead="open"	style="dashed"     ];
	
	_ILPDBaseModel			-> _ILPDListPatient			[ arrowhead="open", style="dashed" ];
	_ILPDListPatient		-> _ILPDBase				[ arrowhead="onormal"			   ];
	_ILPDPatient			-> _ILPDBase				[ arrowhead="onormal"			   ];
	_ILPDStudy				-> _ILPDBase				[ arrowhead="onormal"			   ];
	_ILPDSeries				-> _ILPDBase				[ arrowhead="onormal"			   ];
	_ILPDImage				-> _ILPDBase				[ arrowhead="onormal"			   ];
	_ILPDBase				-> _ILPDBase				[ arrowhead="open", style="dashed" ];
	_ILPDNode				-> _ILPDBase				[ arrowhead="open", style="dashed" ];
	_ILPDNode				-> _ILPDNode				[ arrowhead="open", style="dashed" ];
	_ILPDControlNode		-> _ILPDNode				[ arrowhead="open", style="dashed" ];
	_ILPDBaseView			-> _ILPDControlNode			[ arrowhead="open", style="dashed" ];

	_ILPDControler			-> _ILPDBaseView			[ arrowhead="open", style="dashed" ];
	_ILPDControler			-> _ILPDModel				[ arrowhead="open", style="dashed" ];
	_ILPDBaseView			-> _ILPDControler			[ arrowhead="open", style="dashed" ];
	_ILPDViewWxWindow		-> _ILPDBaseView			[ arrowhead="onormal"			   ];
	_ILPDViewMFC			-> _ILPDBaseView			[ arrowhead="onormal"			   ];
	_ILPDViewWxWindow		-> _wxILPD					[ arrowhead="open", style="dashed" ];
	_ILPDViewMFC			-> _mfcILPD					[ arrowhead="open", style="dashed" ];
	_wxILPD					-> _ILPDBaseView			[ arrowhead="open", style="dashed" ];
	_mfcILPD				-> _ILPDBaseView			[ arrowhead="open", style="dashed" ];
	_ILPDViewListPatient	-> _ILPDModel				[ arrowhead="open", style="dashed" ];
	_ILPDViewListPatient	-> _ILPDControler			[ arrowhead="open", style="dashed" ];
	_ILPDViewListPatient	-> _ILPDBaseView			[ arrowhead="open", style="dashed" ];
 }


}
  \enddot



 \section install Installation

 \subsection step1 Step 1: Opening the box

 etc...
*/

// ----------------------------------------------------------------------------
// wx headers
// ----------------------------------------------------------------------------
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#   include <wx/wx.h>
#endif

// ----------------------------------------------------------------------------
// Local headers
// ----------------------------------------------------------------------------
#include "wxMaracasApp.h"
#include "wxMaracasFrame.h"
#include <wx/log.h>


#ifdef __WXGTK__
# include <locale.h>
#endif

// ----------------------------------------------------------------------------
// This macro implements the entry point (main function) for the application
// ----------------------------------------------------------------------------
IMPLEMENT_APP( wxMaracasApp );

// ----------------------------------------------------------------------------
// The `main program' equivalent, creating the windows and returning the
// main frame
bool wxMaracasApp::OnInit( )
{
#ifdef __WXGTK__
	//See http://www.wxwindows.org/faqgtk.htm#locale
	setlocale(LC_NUMERIC, "C");
#endif


// PS -> #ifndef DXMM
// PS -> 	// GO !
// PS -> 	SetExitOnFrameDelete(true);
// PS -> 	m_pFrame->Show( true );
// PS -> #else
	SetExitOnFrameDelete(false);
// PS -> #endif

	return( true );
}
// ----------------------------------------------------------------------------
int wxMaracasApp::OnExit(){
	if (Initialized())
	{
		initialized=false;
//		delete  _mar;
		m_pFrame->Destroy();
	}
	ProcessIdle();

//EEDxx2.4 DEBuG
//	wxLogDebug("----------- Exiting application");
//	wxLogDebug("---------------------------------------------------");

	return true;
}

// ----------------------------------------------------------------------------
void wxMaracasApp::Run(){

	m_pFrame->Show( true );
	wxCommandEvent cmdEvt=wxCommandEvent();
	m_pFrame->OnStartExperiment(cmdEvt);
	m_pFrame->Maximize(true);

//EEDxx2.4 DEBuG
//	wxLogDebug("----------- Running application");
}

// ----------------------------------------------------------------------------
void wxMaracasApp::Reset(){
	// TODO : we can make it more nicely
//EEDxx2.4 DEBuG
//	wxLogDebug("---------------------------------------------------");
//	wxLogDebug("----------- Reseting application");
//	wxLogDebug("---------------------------------------------------");
	//OnExit();
//	OnInit();
	Initialize();
}

// ----------------------------------------------------------------------------
void wxMaracasApp::Initialize(){
#ifdef __WXDEBUG__
	//static wxLogWindow * myLogWindow=new wxLogWindow(NULL,"Log Window",false,false);
	static wxLogWindow * myLogWindow=new wxLogWindow(NULL,"Log Window",true,false);
	wxLog::SetActiveTarget(myLogWindow);
	myLogWindow->ClearTraceMasks();
#endif
//EEDxx2.4 DEBuG
//	wxLogDebug("---------------------------------------------------");
//	wxLogDebug("----------- Initialising application");


	int nSize=_MAX_PATH;
	LPTSTR lpFilename=(LPTSTR) (new char[nSize]);
	GetModuleFileName(NULL,lpFilename,nSize);
	
	wxString moduleFileName(lpFilename);

	wxString paramFileName=moduleFileName.BeforeLast('\\')
		+wxString('\\')
		+wxString(MAR_DEFAULT_FILE_PARAMETERS);

	wxString dictionaryFileName=moduleFileName.BeforeLast('\\')
		+wxString('\\')
		+wxString(MAR_DEFAULT_FILE_DICTIONARY);

	// Initialize MARACAS


	_mar = new marInterface();
	_mar->SetParamFileName(paramFileName.c_str());
	_mar->loadParameters();
	_marSimpleDicom = new marSimpleDicom( _mar->_parameters );
	_mar->SetDicom(_marSimpleDicom);



	// Create the main frame window
	m_pFrame = new wxMaracasFrame( ( wxFrame* )NULL,  -1 , _mar , _marSimpleDicom ,(const char*)dictionaryFileName.mb_str());

		
	m_pFrame->Maximize( );
	this->SetTopWindow( m_pFrame );
	_mar->saveParameters( );

	initialized=true;
	SetExitOnFrameDelete(false);
}

// ----------------------------------------------------------------------------
bool wxMaracasApp::Initialized(){
	return initialized;
}
// PS -> #endif

void wxMaracasApp::ShowFrame(int cmdShow)
{
//EEDxx2.4 DEBuG
//	wxLogDebug("----------- Show Frame");
	if (Initialized())
	{
		if ( SHOW_WINDOW_MINIMIZED == cmdShow )
		{
			m_pFrame->Iconize();
		}
		else if ( SHOW_WINDOW_RESTORE == cmdShow )
		{
			m_pFrame->Maximize(false);
			m_pFrame->Raise();
		}
		else if (SW_NORMAL == cmdShow )
		{
			m_pFrame->Raise();
		}
		else if ( SHOW_WINDOW_MAXIMIZED == cmdShow )
		{
			m_pFrame->Maximize(true);
			m_pFrame->Raise();
		}
		else
		{
			m_pFrame->Raise();
		}
	}
}


void wxMaracasApp::SetVolumeData(int dimX, int dimY, int dimZ, 
								 float spacingX,float spacingY, float spacingZ, 
								 float rescaleSlope, float rescaleIntercept,
								 unsigned short *pixels)
{
	if (Initialized())
	{
		_marSimpleDicom->SetInvestSliceOrder( _mar->_parameters->getInvestSliceOrder() );
		_marSimpleDicom->SetVolumeData(dimX, dimY, dimZ,
									   spacingX, spacingY, spacingZ,
									   rescaleSlope, rescaleIntercept,
									   pixels);
	}
}

wxBitmap*	wxMaracasApp::GetSnapshot(){
	wxWindowDC *wxwindc = new wxWindowDC(m_pFrame);
	wxCoord w, h;
	wxwindc->GetSize(&w, &h);
	wxBitmap *wxbitmap	= new wxBitmap(w, h);

	wxMemoryDC *wxmemorydc = new wxMemoryDC();
	wxmemorydc->SelectObject(*wxbitmap);
	wxmemorydc->Blit(0,0,w,h,wxwindc,0,0);

	delete wxwindc;
	delete wxmemorydc;

	return wxbitmap;
}
