/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxMaracasApp02.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:14:56 $
 Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

/**
* \mainpage wxMaracas version wxWindows
*
* \section intro Introduction
*
* This is the introduction.
*
* \section install Installation
*
* \subsection step1 Step 1: Opening the box
*
* etc...
*/

// ----------------------------------------------------------------------------
// wx headers
// ----------------------------------------------------------------------------
#include "wx/wxprec.h"
#include <wx/datetime.h>
#ifndef WX_PRECOMP
#   include <wx/wx.h>
#endif

#include <wx/log.h>


// ----------------------------------------------------------------------------
// Local headers
// ----------------------------------------------------------------------------

#include <vtkDebugLeaks.h> 


#include "wxMaracasFrame02.h"
#include "wxMaracasApp02.h"
#include "marGdcmDicom.h"


#ifdef __WXGTK__
# include <locale.h>
#endif




//EED
// http://lists.wxwidgets.org/archive/wx-dev/msg30449.html
wxString getExecutablePath()
{
    char buf[512];
    char* slash;

#if defined(WIN32)

    wchar_t buf2[512];
    long result = GetModuleFileName(NULL, buf2, 511);
	int ret = wcstombs ( buf, buf2, sizeof(pname) );	
//    GetModuleFileName(NULL, buf, 511);

    slash = strrchr(buf, '\\');
    if (slash)
    {
        *slash = 0;
    }
#elif defined(__LINUX__)
    int res;
    res = readlink("/proc/self/exe", buf, 512);
    if (res == -1)
        return _T("");
    buf[res] = 0;
    slash = strrchr(buf, '/');
    if (slash)
    {
        *slash = 0;
    }
#else
    return "";
#endif

    return wxString(buf, wxConvUTF8 );
}





// ----------------------------------------------------------------------------
// This macro implements the entry point (main function) for the application
// ----------------------------------------------------------------------------
IMPLEMENT_APP( wxMaracasApp02 );


// ----------------------------------------------------------------------------
// The `main program' equivalent, creating the windows and returning the
// main frame
bool wxMaracasApp02::OnInit( )
{
#ifdef __WXGTK__
	//See http://www.wxwindows.org/faqgtk.htm#locale
	setlocale(LC_NUMERIC, "C");
#endif
/*
#ifdef __WXDEBUG__
	//static wxLogWindow * myLogWindow=new wxLogWindow(NULL,"Log Window",false,false);
	static wxLogWindow * myLogWindow=new wxLogWindow(NULL,"Log Window",true,false);
	wxLog::SetActiveTarget(myLogWindow);
	myLogWindow->ClearTraceMasks();
#endif
	wxLogDebug("---------------------------------------------------");
	wxLogDebug("----------- Initialising application");
*/
//	int nSize=_MAX_PATH;
//	LPTSTR lpFilename=(LPTSTR) (new char[nSize]);
//	GetModuleFileName(NULL,lpFilename,nSize);
//	wxString moduleFileName( lpFilename );

	wxString moduleFileName = getExecutablePath();

	wxString paramFileName=moduleFileName.BeforeLast( wxChar(92) )   // caracter '\'
		+wxString( wxChar(92) )
		+wxString( MAR_DEFAULT_FILE_PARAMETERS , wxConvUTF8 );
	wxString dictionaryFileName=moduleFileName.BeforeLast( wxChar(92) )
		+wxString( wxChar(92) )
		+wxString( MAR_DEFAULT_FILE_DICTIONARY, wxConvUTF8 );

	// Initialize MARACAS
	_mar = new marInterface();

	_mar->SetParamFileName( (const char*)(paramFileName.mb_str()) );
	_mar->loadParameters();

/*
	// Initialize MARACASCT
	_marCT = new marInterfaceCT();
	_marCT->SetParamFileName(paramFileName.c_str());
	_marCT->loadParameters();
*/

// EED ILPD

//EED 4 oct 2006
//	_mar->SetDicom( new marGdcmDicomILPD( _mar->_parameters ) );

	//	_marCT->SetDicom( new marGdcmDicomILPD( _marCT->getParameters() ) );
//	_mar->SetDicom( new marGdcmDicom( _mar->_parameters ) );

/*
//--
	// Create the main frame window	
	wxMaracasFrame02* frame = new wxMaracasFrame02( ( wxFrame* )NULL,  -1 , _mar, _marCT, (const char*)dictionaryFileName.mb_str());
	frame->Show( true );
	frame->Maximize( );
	this->SetTopWindow( frame );


	//If no dir was set for DICOM force user to set it !
 	wxString dirHome = _mar->_parameters->getStringParam(
 		marParameters::e_dicom_images_directory );
 	if( dirHome == "NO_DIRECTORY" || dirHome == "")
	{
//		_mar->_parameters->setStringParam(
// 			marParameters::e_dicom_images_directory, "c:\\temp" );
		
		wxDirDialog dialog( frame, "Choose a DICOM directory...",
 			( !dirHome.IsEmpty( ) )? dirHome: wxGetHomeDir( ) );

 		if( dialog.ShowModal( ) == wxID_OK )
		{
			_mar->_parameters->setStringParam(
 				marParameters::e_dicom_images_directory, dialog.GetPath( ) );
			_marCT->getParameters()->setStringParam(
 				marParameters::e_dicom_images_directory, dialog.GetPath( ) );

			
 		}
		
 	}
	else
	{
		_marCT->getParameters()->setStringParam(
			marParameters::e_dicom_images_directory, dirHome );

	}


 	wxCommandEvent cmd;
 	frame->OnLoadPatientData( cmd );
	_mar->saveParameters( );
	_marCT->saveParameters( );
//EED	initialized=true;


// PS -> #ifndef DXMM
// PS -> 	// GO !
// PS -> 	SetExitOnFrameDelete(true);
// PS -> 	m_pFrame->Show( true );
// PS -> #else
//	SetExitOnFrameDelete(true);
// PS -> #endif
//--
*/

//--	

        string tmpstring = (const char*) (dictionaryFileName.mb_str());
	wxMaracasFrame03 *frame03 = new wxMaracasFrame03( (wxFrame*) NULL,  -1 , _mar, (char*)tmpstring.c_str() );
	frame03->SetTitle(_T("Maracas - Evaluation version 1 July 2008 - Use limited to the research team - (Creatis-LRMN,Uniandes)"));

	frame03->Show( true );
	frame03->Maximize( );
	this->SetTopWindow( frame03 );
//--

/*
	wxDateTime date;
	int year=date.GetCurrentYear();
	int month=date.GetCurrentMonth()+1;
	if (!((year==2006) && (month==01)))	
	{
		wxMessageDialog msg(frame03, "ERROR EED:1010", "Message box", wxOK );
		msg.ShowModal();
		return	false;
	}
*/

	return( true );
}
// ----------------------------------------------------------------------------
int wxMaracasApp02::OnExit(){


	if (_mar!=NULL) { delete _mar; }


//EED	vtkDebugLeaks::PrintCurrentLeaks  (    ) ;

	return true;

}

// EOF - wxMaracasApp02.cxx
