/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxMaracasFrame.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:14:56 $
 Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

   This software is distributed WITHOUT ANY WARRANTY; without even
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// PS -> #include "wxMaracasDataBrowser.h"
#include "wxMaracasParametersDialog.h"
#include "wxMaracasImageBrowser.h"
#include "wxMaracasHelpDialog.h"
#include "wxMaracasFrame.h"
#include "marDictionary.h"

#include <wx/panel.h>
#include <wx/toolbar.h>
#include <wx/dialog.h>
#include <wx/colordlg.h>
// ----------------------------------------------------------------------------
// Maracas "logic world" headers
// ----------------------------------------------------------------------------


//#ifndef __WXMSW__
#   include "res/bitmaps/connect.xpm"
#   include "res/bitmaps/params.xpm"
#   include "res/bitmaps/imagebrowser.xpm"
#   include "res/bitmaps/3D.xpm"
#   include "res/bitmaps/plans.xpm"
#   include "res/bitmaps/quant.xpm"
#   include "res/bitmaps/rotate.xpm"
#   include "res/bitmaps/bright.xpm"
#   include "res/bitmaps/pan.xpm"
#   include "res/bitmaps/zoom.xpm"
#   include "res/bitmaps/clear.xpm"
#   include "res/bitmaps/intensity.xpm"
#   include "res/bitmaps/help.xpm"
#   include "res/bitmaps/creatis_logo.xpm"
#   include "res/icons/maracas.xpm"
//#endif

BEGIN_EVENT_TABLE( wxMaracasFrame, wxFrame )
	// PS -> EVT_MENU( ID_TOOLBAR_DATA_BROWSER, wxMaracasFrame::OnLoadPatientData )
	EVT_MENU( ID_TOOLBAR_PARAMETERS, wxMaracasFrame::OnParameters )
	// PS -> EVT_MENU( ID_TOOLBAR_IMAGE_BROWSER, wxMaracasFrame::OnLoadImageData )
	EVT_MENU( ID_TOOLBAR_3D_BROWSER, wxMaracasFrame::OnStartExperiment )
	// PS -> EVT_MENU( ID_TOOLBAR_HELP, wxMaracasFrame::OnHelp )
	EVT_MENU( ID_TOOLBAR_PLANS, wxMaracasFrame::OnQuant )

// EED : This is not top  !!!!!!!!!!!
	EVT_TOOL( 19999, wxMaracasFrame::OnRegenerateAll		)
	EVT_TOOL( 19998, wxMaracasFrame::OnRegenerateSplineAxe	)
	EVT_TOOL( 19997, wxMaracasFrame::OnCleanContours		)
	EVT_TOOL( 19996, wxMaracasFrame::OnRegenerateSignal		)


	EVT_CLOSE( wxMaracasFrame::OnQuit )

	EVT_TOOL(wxSurfaceWidget::ID_BUTTON_NEW_AXIS, wxMaracasFrame::OnNewAxis )
	EVT_TOOL(wxSurfaceWidget::ID_BUTTON_DELETE_AXIS, wxMaracasFrame::OnDeleteAxis )
END_EVENT_TABLE( );

//----------------------------------------------------------------------------
wxMaracasFrame::wxMaracasFrame( wxFrame *parent, wxWindowID id,
							   marInterface *mar,marSimpleDicom *simpleDicom, char *dictionaryFileName,
							   const wxString& title, const wxPoint& pos,
							   const wxSize& size, long style)
							   : wxFrame( parent, id, title, pos, size, style)
{
    _mar						= mar;
	_marSimpleDicom				= simpleDicom;
	_wxmaracasquantification	= NULL;
	_wxmaracas3dbrowser			= NULL;

	marDictionary marDict;
//	marDict.LoadDictionary_French();
	marDict.LoadDictionary_English();
//	marDict.LoadDictionary_Japanese();
	

/*
	if (!marDict.LoadDictionaryFile(dictionaryFileName)){
			wxMessageBox( "Error: File(s) marDict.txt not found...",
					  "DxMM : MARACAS", wxOK | wxCENTRE | wxICON_ERROR , this);
	}
*/

    //good luck !
    vtkObject *a = vtkObject::New();
    a->GlobalWarningDisplayOff();
    a->Delete();

    // At the begining, there were nothing, just a window...
    _actual_panel = NULL;

    // And the programmer said: let there be a status bar
    this->CreateStatusBar( );

    this->GetStatusBar()->SetFieldsCount( 2 );
    wxRect rect;
    this->GetStatusBar()->GetFieldRect(1, rect);
    //wxPoint pos;
    //wxSize size;
    //_progressGauge = new wxGauge( this->GetStatusBar(), -1, 100);
	//    _progressGauge = new wxGauge( this->GetStatusBar(), -1, 50,
	//    rect.GetPosition(), rect.GetSize());
    this->GetStatusBar()->Show();
    this->PositionStatusBar();

    // And an icon (to be unique)
    //TODO change the icon to the real one!
    this->SetIcon( wxICON( maracas_icon ) );

    // And a toolbar (for dummy users)
    this->RecreateToolbar( );

}
//----------------------------------------------------------------------------
void wxMaracasFrame::RecreateToolbar( )
{
    wxToolBar* toolBar = this->GetToolBar( );
    delete toolBar;
    this->SetToolBar( NULL );

    toolBar = this->CreateToolBar( TOOLBAR_STYLE, ID_TOOLBAR );

    // Set up toolbar
    wxBitmap toolBarBitmaps[ 22+1 ];

	/**
	* wxBitmap vs. wxBITMAP -> add _xpm at the end of the file
	*/
    toolBarBitmaps[  0 ] = wxBITMAP( toolbar_connect );
    toolBarBitmaps[  4 ] = wxBITMAP( toolbar_params );
    toolBarBitmaps[  7 ] = wxBITMAP( toolbar_imagebrowser );
    toolBarBitmaps[  9 ] = wxBITMAP( toolbar_triD );

    toolBarBitmaps[ 10 ] = wxBITMAP( toolbar_plans );
    toolBarBitmaps[ 11 ] = wxBITMAP( toolbar_quant );
    toolBarBitmaps[ 12 ] = wxBITMAP( toolbar_rotate );
    toolBarBitmaps[ 13 ] = wxBITMAP( toolbar_bright );
    toolBarBitmaps[ 14 ] = wxBITMAP( toolbar_pan );
    toolBarBitmaps[ 15 ] = wxBITMAP( toolbar_zoom );
    toolBarBitmaps[ 16 ] = wxBITMAP( toolbar_clear );
    toolBarBitmaps[ 17 ] = wxBITMAP( toolbar_intensity );
    toolBarBitmaps[ 20 ] = wxBITMAP( toolbar_help );
    toolBarBitmaps[ 22 ] = wxBITMAP( creatis_logo );

    /*
	toolBarBitmaps[  1 ] = wxBitmap( toolbar_loadexp );
	toolBarBitmaps[  2 ] = wxBitmap( toolbar_save );
	toolBarBitmaps[  3 ] = wxBitmap( toolbar_excel );
	toolBarBitmaps[  5 ] = wxBitmap( toolbar_wizard );
	toolBarBitmaps[  6 ] = wxBitmap( toolbar_back );
	toolBarBitmaps[  8 ] = wxBitmap( toolbar_subtract );

	 toolBarBitmaps[ 18 ] = wxBitmap( toolbar_linear );
	 toolBarBitmaps[ 19 ] = wxBitmap( toolbar_area );
    */
    // Set size & margins
    toolBar->SetMargins( 4, 4 );
// PS -> #ifdef DXMM
    toolBar->SetToolBitmapSize( wxSize( toolBarBitmaps[ 4 ].GetWidth( ), toolBarBitmaps[ 4 ].GetHeight( ) ) );
// PS -> #else
// PS ->     toolBar->SetToolBitmapSize( wxSize( toolBarBitmaps[ 0 ].GetWidth( ), toolBarBitmaps[ 0 ].GetHeight( ) ) );
// PS -> #endif

    // Adding tools
// PS -> #ifndef DXMM
// PS ->     toolBar->AddTool( ID_TOOLBAR_DATA_BROWSER, toolBarBitmaps[ 0 ], "Patient data", "Load patient data: studies & series" );
// PS ->     toolBar->AddSeparator( );
// PS ->     toolBar->AddTool( ID_TOOLBAR_IMAGE_BROWSER, toolBarBitmaps[ 7 ], "Load image data", "Load DICOM images from disk" );
// PS ->     toolBar->AddSeparator( );
// PS -> #endif
    toolBar->AddTool( ID_TOOLBAR_3D_BROWSER, toolBarBitmaps[ 9 ], _T("Start 3D"), _T("Load 3D representation") );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_PLANS, toolBarBitmaps[ 10 ], _T("Plan"), _T("Planes") );
    toolBar->AddSeparator( );
//    toolBar->AddTool( ID_TOOLBAR_QUANT, toolBarBitmaps[ 11 ], "Quant", "Quant" );
//    toolBar->AddSeparator( );
    //The following has been commented out temporarlily
    /*
    toolBar->AddTool( ID_TOOLBAR_ROTATE, toolBarBitmaps[ 12 ], "Rotate", "Rotate" );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_BRIGHT, toolBarBitmaps[ 13 ], "Bright", "Bright" );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_PAN, toolBarBitmaps[ 14 ], "Pan", "Pan" );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_ZOOM, toolBarBitmaps[ 15 ], "Zoom", "Zoom" );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_CLEAR, toolBarBitmaps[ 16 ], "Clear", "Clear" );
    toolBar->AddSeparator( );
    toolBar->AddTool( ID_TOOLBAR_INTENSITY, toolBarBitmaps[ 17 ], "Intensity", "Intensity" );
    toolBar->AddSeparator( );*/
    toolBar->AddTool( ID_TOOLBAR_PARAMETERS, toolBarBitmaps[ 4 ], _T("Parameters"), _T("Load parameters for modifying") );
    //toolBar->AddTool( ID_TOOLBAR_HELP, toolBarBitmaps[ 20 ], "Help", "Help" );
    toolBar->AddSeparator( );

	wxBitmapButton *btnCreatisLogo = new wxBitmapButton(toolBar,-1,toolBarBitmaps[ 22 ] );
	btnCreatisLogo->SetSize(81+10,20+10);
	btnCreatisLogo->SetBackgroundColour(wxColour(0,0,153));
	Connect(btnCreatisLogo->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxMaracasFrame::OnAboutCreatis	);

	toolBar->AddControl(btnCreatisLogo);



    toolBar->Realize( );
    toolBar->SetRows( 1 );
    toolBar->EnableTool(ID_TOOLBAR_3D_BROWSER, true);
    toolBar->EnableTool(ID_TOOLBAR_PLANS, false);
    toolBar->EnableTool(ID_TOOLBAR_QUANT, false);
}

//----------------------------------------------------------------------------
void wxMaracasFrame::OnAboutCreatis( wxCommandEvent& event ){
	wxMaracasHelpDialog *dlg = new wxMaracasHelpDialog(this, -1, "Creatis", wxPoint(200,200), wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
	dlg->ShowModal();
	dlg->Close();
}

//----------------------------------------------------------------------------
void wxMaracasFrame::OnQuit( wxCloseEvent& event ){

	DeletePanels();
	if (_mar!=NULL) { delete _mar; }
	_mar=NULL;
	marDictionary marDict;
	marDict.FreeDictionary();


//	this->Show(FALSE);
	this->Destroy();
	delete this;
}
//----------------------------------------------------------------------------
// PS -> void wxMaracasFrame::OnLoadPatientData( wxCommandEvent& event )
// PS -> {
// PS -> 	wxBusyCursor wait;
// PS ->     wxToolBar* toolBar = this->GetToolBar( );
// PS ->     //Disabling tool
// PS ->     //wxToolBar::EnableTool This function should only be called after Realize.
// PS ->     toolBar->EnableTool(ID_TOOLBAR_IMAGE_BROWSER, false);
// PS ->     toolBar->EnableTool(ID_TOOLBAR_3D_BROWSER, true);
// PS ->     toolBar->EnableTool(ID_TOOLBAR_PLANS, true);
// PS ->     toolBar->EnableTool(ID_TOOLBAR_QUANT, false);
// PS -> 
// PS -> 	//  Create panel
// PS -> 	if( _actual_panel != NULL ) delete _actual_panel;
// PS -> 	wxMaracasDataBrowser* pnl = new wxMaracasDataBrowser( this, _mar, -1 );
// PS -> 
// PS -> 	_actual_panel = pnl;
// PS -> 
// PS -> 	// cf.: http://www.wxwindows.org/manuals/2.4.0/wx490.htm
// PS -> 	// Force a resize. This should probably be replaced by a call to a wxFrame
// PS -> 	// function that lays out default decorations and the remaining content window.
// PS -> 	wxSizeEvent myevent(wxSize(-1, -1), this->GetId());
// PS -> 	this->OnSize(myevent);
// PS -> 	this->Show(true);
// PS -> 
// PS -> 	// Load panel data
// PS -> 	pnl->LoadData( );
// PS -> 	//this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, false);
// PS -> }
//----------------------------------------------------------------------------
void wxMaracasFrame::OnParameters( wxCommandEvent& event )
{
/* EED Photo Maracas
  //-- 
	wxWindowDC *wxwindc =new wxWindowDC(this);
	wxCoord w, h;
	wxwindc->GetSize(&w, &h);
	wxBitmap *wxbitmap =new wxBitmap(w, h);
	wxMemoryDC *wxmemorydc = new wxMemoryDC();

	wxmemorydc->SelectObject(*wxbitmap);
	wxmemorydc->Blit(0,0,w,h,wxwindc,0,0);

	wxbitmap->SaveFile("c:/tmp/MaracasPlamavic.bmp", wxBITMAP_TYPE_BMP  );
	delete wxwindc;
	delete wxbitmap;
	delete wxmemorydc;
  //--	
*/
	wxMaracasParametersDialog *d = new wxMaracasParametersDialog( this, _mar );
	d->ShowModal( );
	d->Close(true);
/*
	if (d->IfInitContour()==true){
	} else {
	}
	if (d->GetInitContour()==true){
	}
	wxmaracasquantification;
	if (wxmaracas3dbrowser!=NULL){ 
	}
*/
}
//----------------------------------------------------------------------------
// PS -> void wxMaracasFrame::OnLoadImageData( wxCommandEvent& event )
// PS -> {
// PS -> 	wxBusyCursor wait;
// PS -> 
// PS -> 	//  Create panel
// PS -> 	if( _actual_panel != NULL ) delete _actual_panel;
// PS -> 	wxMaracasImageBrowser* pnl = new wxMaracasImageBrowser( this, _mar, -1 );
// PS -> 
// PS -> 	// Resize
// PS -> 	_actual_panel = pnl;
// PS -> 
// PS -> 	// Load panel data
// PS -> 	wxSizeEvent myevent(wxSize(-1, -1), this->GetId());
// PS -> 	this->OnSize(myevent);
// PS -> 	//this->Show(true);
// PS -> 
// PS -> 	//wxDialog dialog(this, -1, "coucou");
// PS -> 	//dialog.ShowModal();
// PS -> 	//dialog.Show(true);
// PS -> 	//wxGauge gauge( this, -1, 50);
// PS -> 
// PS ->     /**
// PS -> 	AS a first step I'll pass a wxGauge as parameter this doesn't
// PS -> 	sound very good, should use EVT_TIMER instead...
// PS ->     */
// PS ->     _mar->_dicom->loadActualSerie( this->_progressGauge );
// PS ->     vtkImageData *dummy = _mar->_dicom->getVolume( )->castVtk();
// PS ->     //float range[2];
// PS ->     //dummy->GetScalarRange( range );
// PS -> 
// PS ->     pnl->LoadData( dummy );
// PS ->     //_view_image->ConstructVTK(  (vtkImageData *)_mar->_dicom->getVolume( ));
// PS ->     //^ this is not working ??? I don't understand why, some VTK pipeline mystery
// PS -> 
// PS ->     this->GetToolBar()->EnableTool(ID_TOOLBAR_IMAGE_BROWSER, false);
// PS ->     this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, true);
// PS -> 	//Add patient name to the frame title
// PS ->     this->SetTitle( "Patient Name : " + _mar->_dicom->GetPatientName() );
// PS -> }
//----------------------------------------------------------------------------
void wxMaracasFrame::OnStartExperiment( wxCommandEvent& event )
{
	
	wxBusyCursor wait;

	int voi[ 6 ];
// PS -> #ifndef DXMM
// PS ->     ((wxMaracasImageBrowser*)_actual_panel )->GetROI( voi );
// PS -> #else

	_marSimpleDicom->loadActualSerie( this->_progressGauge );
	_mar->_dicom->SetVolume( _marSimpleDicom->getVolume() );


	voi[0] = 0;
	voi[1] = (_mar->_dicom->getVolume( )->getXdim( ))-1;
	voi[2] = 0;
	voi[3] = (_mar->_dicom->getVolume( )->getYdim( ))-1;
	voi[4] = 0;
	voi[5] = (_mar->_dicom->getVolume( )->getZdim( ))-1;
// PS -> #endif

	_mar->_experiment->setVOI( voi );
	_mar->initExperiment( );

	//  Create panel
    DeletePanels();
	_wxmaracas3dbrowser = new wxMaracas3DBrowser( this, _mar, -1 ,ID_TOOLBAR_PLANS);

	// Resize
	_actual_panel = _wxmaracas3dbrowser;

	wxSizeEvent myevent(wxSize(-1, -1), this->GetId());
	this->OnSize(myevent);
	//this->Show(true);

	// Load panel data
	_wxmaracas3dbrowser->LoadData( );

// PS -> #ifndef DXMM
// PS -> 	this->GetToolBar()->EnableTool(ID_TOOLBAR_IMAGE_BROWSER, true);
// PS -> 	this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, false);
// PS -> #else
	this->GetToolBar()->EnableTool(ID_TOOLBAR_PLANS, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_QUANT, false);
// PS -> #endif
}
//----------------------------------------------------------------------------
// PS -> void wxMaracasFrame::OnHelp (wxCommandEvent& event )
// PS -> {
// PS -> 	wxMaracasHelpDialog* help = new wxMaracasHelpDialog(this, -1);
// PS -> 
// PS -> 	help->ShowModal();
// PS -> }

//----------------------------------------------------------------------------
void wxMaracasFrame::DeletePanels ( ){
	if (_wxmaracasquantification!=NULL){ 
		delete _wxmaracasquantification;
		_wxmaracasquantification=NULL;
	}
	if (_wxmaracas3dbrowser!=NULL){ 
		delete _wxmaracas3dbrowser;
		_wxmaracas3dbrowser=NULL;
	}
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnQuant (wxCommandEvent& event ){
	int isovalue = 50;
	int opacity  = 50;

	if (_wxmaracas3dbrowser!=NULL){ 
		isovalue = _wxmaracas3dbrowser->GetIsovalue();
		opacity	 = _wxmaracas3dbrowser->GetOpacity();
	}

    DeletePanels();
	_wxmaracasquantification = new wxMaracasQuantification( this, _mar, -1 );
	_actual_panel = _wxmaracasquantification;

	wxSizeEvent myevent(wxSize(-1, -1), this->GetId());
	this->OnSize(myevent);
	this->Show(true);

	// Load panel data
	_wxmaracasquantification->LoadData( );
	_wxmaracasquantification->SetSlider_Isovalue_Opacity(isovalue,opacity);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_PLANS, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, true);
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnNewAxis(wxCommandEvent &WXUNUSED(event))
{
	this->GetToolBar()->EnableTool(ID_TOOLBAR_PLANS, true);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_QUANT, true);
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnDeleteAxis(wxCommandEvent &WXUNUSED(event))
{
	this->GetToolBar()->EnableTool(ID_TOOLBAR_PLANS, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, false);
	this->GetToolBar()->EnableTool(ID_TOOLBAR_QUANT, false);
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnRegenerateAll(  wxCommandEvent& event  ){
	if (_wxmaracas3dbrowser!=NULL)		{ _wxmaracas3dbrowser->RegenerateAll(true);		}
	if (_wxmaracasquantification!=NULL) { _wxmaracasquantification->RegenerateAll(true);}
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnRegenerateSplineAxe(  wxCommandEvent& event  ){
	if (_wxmaracas3dbrowser!=NULL)		{ _wxmaracas3dbrowser->RegenerateAll(false);		}
	if (_wxmaracasquantification!=NULL) { _wxmaracasquantification->RegenerateAll(false);	}
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnCleanContours(  wxCommandEvent& event  ){
	if (_wxmaracasquantification!=NULL) { _wxmaracasquantification->CleanContours();	}
}
//----------------------------------------------------------------------------
void wxMaracasFrame::OnRegenerateSignal(  wxCommandEvent& event  ){
	if (_wxmaracasquantification!=NULL) { _wxmaracasquantification->RegenerateSignal();	}
}
//----------------------------------------------------------------------------



