/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasFrame.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__MARACAS__FRAME__HXX__
#define __WX__MARACAS__FRAME__HXX__

#include <wx/wx.h>
#include <wx/frame.h>
#include "marTypes.h"
#include "wxMaracas3DBrowser.h"
#include "wxMaracasQuantification.h"
#include <kernel/marSimpleDicom.h>

class marInterface;

/**
 * \brief Principal Frame of the application 
 * MARACAS: MAgnetic Resonance Angiography Computer ASsisted analysis
 *
 */

class MAR_INTERFACEWX_EXPORT wxMaracasFrame: public wxFrame
{
public:

    wxMaracasFrame( wxFrame *parent, wxWindowID id = -1,
            marInterface* mar = NULL, marSimpleDicom *simpleDicom=NULL, char *dictionaryFileName=NULL,
            const wxString& title = wxT("MARACAS: MAgnetic Resonance Angiography Computer ASsisted analysis"),
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = wxDEFAULT_FRAME_STYLE);
	
	void OnDeleteAxis(wxCommandEvent &event);
	void OnNewAxis(wxCommandEvent &event);
	
    void RecreateToolbar( );

	void OnAboutCreatis( wxCommandEvent& event );
    void OnQuit( wxCloseEvent& event );
// PS ->     void OnLoadPatientData( wxCommandEvent& event );
    void OnParameters( wxCommandEvent& event );
// PS ->     void OnLoadImageData( wxCommandEvent& event );
    void OnStartExperiment( wxCommandEvent& event );
// PS ->     void OnHelp (wxCommandEvent& event );
    void OnQuant (wxCommandEvent& event );

	void OnRegenerateAll( wxCommandEvent& event );
	void OnRegenerateSplineAxe(	wxCommandEvent& event );
	void OnCleanContours( wxCommandEvent& event );
	void OnRegenerateSignal( wxCommandEvent& event );



	wxMaracas3DBrowser*			Getwxmaracas3dbrowser()			{ return _wxmaracas3dbrowser;		}
	wxMaracasQuantification*	Getwxmaracasquantification()	{ return _wxmaracasquantification;	}

private:
    wxPanel					*_actual_panel;
    wxGauge					*_progressGauge;
    marInterface			*_mar;
	marSimpleDicom			*_marSimpleDicom;

	wxMaracas3DBrowser		*_wxmaracas3dbrowser;
	wxMaracasQuantification *_wxmaracasquantification;

    DECLARE_EVENT_TABLE( );

	void DeletePanels();
};

static const long TOOLBAR_STYLE = wxNO_BORDER | wxTB_FLAT | wxTB_DOCKABLE | wxTB_HORIZONTAL;

enum
{
    //! Toolbar & menu buttons
    ID_TOOLBAR = 200,
    ID_TOOLBAR_DATA_BROWSER,
    ID_TOOLBAR_PARAMETERS,
    ID_TOOLBAR_IMAGE_BROWSER,
    ID_TOOLBAR_3D_BROWSER,
    ID_TOOLBAR_PLANS,
    ID_TOOLBAR_QUANT,
    ID_TOOLBAR_ROTATE,
    ID_TOOLBAR_BRIGHT,
    ID_TOOLBAR_PAN,
    ID_TOOLBAR_ZOOM,
    ID_TOOLBAR_CLEAR,
    ID_TOOLBAR_INTENSITY,
    ID_TOOLBAR_HELP,
};

#endif // __WX__MARACAS__FRAME__HXX__
