/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasHelpDialog.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasHelpDialog.h"

#if defined(__WXGTK__) || defined(__WXX11__) || defined(__WXMOTIF__) || defined(__WXMAC__)
#include "res/bitmaps/authors.xpm"
#endif



wxMaracasHelpDialog::wxMaracasHelpDialog(wxWindow* parent, int id, const char* title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, wxString(title, wxConvUTF8), pos, size, style)
{


	wxPanel			*logoPanel	= new wxPanel(this,-1);
	logoPanel->SetBackgroundColour(wxColour(0,0,153));
    wxStaticBitmap	*logo		= new wxStaticBitmap(logoPanel, -1, wxBITMAP( authors ),wxPoint(0,0));
	wxBoxSizer		*logoSizer	= new wxBoxSizer(wxVERTICAL );
	int wx=logo->GetBitmap().GetWidth();
	int wy=logo->GetBitmap().GetHeight();
	logoPanel->SetSize(wx,wy);
	logoSizer->Add(logo);
	logoPanel->SetSizer(logoSizer);
	logoPanel->SetAutoLayout(true);

	wxBoxSizer		*sizer		= new wxBoxSizer(wxVERTICAL );
	sizer->Add(logoPanel,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);

	this->SetSizer(sizer);
	this->SetAutoLayout(true);
	SetSize(wx,wy+20);
	

}

/*

wxMaracasHelpDialog::wxMaracasHelpDialog(wxWindow* parent, int id, const char* title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, style)
{

	SetSize(350,350);
	SetBackgroundColour(wxColour(0,0,153));

  
	wxStaticText	*text0		= new wxStaticText(this, -1,"");
	wxStaticText	*text1		= new wxStaticText(this, -1,"System created by");
	wxStaticText	*text2		= new wxStaticText(this, -1,"Research and Applications Center \n for Image and Signal Processing");
	wxStaticText	*text3		= new wxStaticText(this, -1,"www.creatis.insa-lyon.fr");

	wxPanel			*logoPanel	= new wxPanel(this,-1);
	logoPanel->SetBackgroundColour(wxColour(0,0,153));
    wxStaticBitmap	*logo		= new wxStaticBitmap(logoPanel, -1, wxBITMAP( creatis_logo2 ),wxPoint(0,0));
	wxBoxSizer		*logoSizer		= new wxBoxSizer(wxVERTICAL );
	logoPanel->SetSize(logo->GetBitmap().GetWidth(),logo->GetBitmap().GetHeight());
	logoSizer->Add(logo);
	logoPanel->SetSizer(logoSizer);
	logoPanel->SetAutoLayout(true);

	text0->SetForegroundColour(wxColour(255,255,255));
	text1->SetForegroundColour(wxColour(255,255,255));
	text2->SetForegroundColour(wxColour(255,255,255));
	text3->SetForegroundColour(wxColour(255,255,255));



	wxFont font1(12, wxDEFAULT    , wxNORMAL, wxBOLD);
	wxFont font2(11, wxDEFAULT    , wxNORMAL, wxBOLD);
	text0->SetFont( font1 );
	text1->SetFont( font1 );
	text2->SetFont( font1 );
	text3->SetFont( font2 );


	wxBoxSizer		*sizer		= new wxBoxSizer(wxVERTICAL );
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text1	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(logoPanel,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text2	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text3	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);

	this->SetSizer(sizer);
	this->SetAutoLayout(true);




//        staticBitmap1->SetFont(wxFont(12, wxSWISS, wxNORMAL, wxNORMAL, false, ""));
}






wxMaracasHelpDialog2::wxMaracasHelpDialog2(wxWindow* parent, int id, const char* title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, style)
{

	SetSize(550,460);
	SetBackgroundColour(wxColour(0,0,153));

  
	wxStaticText	*text0		= new wxStaticText(this, -1,"");
	wxStaticText	*text1		= new wxStaticText(this, -1,"System created by");
	wxStaticText	*text2		= new wxStaticText(this, -1,"Research and Applications Center \n for Image and Signal Processing");
	wxStaticText	*text3		= new wxStaticText(this, -1,"CREATIS, UMR CNRS 5515, INSA 502, 69621 Villurbanne cedex, France");
	wxStaticText	*text4	= new wxStaticText(this, -1,"www.creatis.insa-lyon.fr");
	wxString authors;
	authors="AUTHORS : Marcela Hernandez-Hoyos, Maciej Orkisz, Catherine Mansard,\n";
	authors=authors+ "                   Alfred AnwanderBruno Neyran, Jean-Pierre Roux,Eric Boix,  \n";
	authors=authors+ "                   Isabelle E. Magnin, Phillippe Douek \n";
	wxStaticText	*text5		= new wxStaticText(this, -1,authors);

	wxPanel			*logoPanel	= new wxPanel(this,-1);
	logoPanel->SetBackgroundColour(wxColour(0,0,153));
    wxStaticBitmap	*logo		= new wxStaticBitmap(logoPanel, -1, wxBITMAP( creatis_logo2 ),wxPoint(0,0));
	wxBoxSizer		*logoSizer		= new wxBoxSizer(wxVERTICAL );
	logoPanel->SetSize(logo->GetBitmap().GetWidth(),logo->GetBitmap().GetHeight());
	logoSizer->Add(logo);
	logoPanel->SetSizer(logoSizer);
	logoPanel->SetAutoLayout(true);

	text0->SetForegroundColour(wxColour(255,255,255));
	text1->SetForegroundColour(wxColour(255,255,255));
	text2->SetForegroundColour(wxColour(255,255,255));
	text3->SetForegroundColour(wxColour(255,255,255));
	text4->SetForegroundColour(wxColour(255,255,255));
	text5->SetForegroundColour(wxColour(255,255,255));



	wxFont font1(12, wxDEFAULT    , wxNORMAL, wxBOLD);
	wxFont font2(10, wxDEFAULT    , wxNORMAL, wxBOLD);
	wxFont font3(8, wxDEFAULT    , wxNORMAL, wxBOLD);
	text0->SetFont( font1 );
	text1->SetFont( font1 );
	text2->SetFont( font1 );
	text3->SetFont( font2 );
	text4->SetFont( font2 );
	text5->SetFont( font3 );

	wxBoxSizer		*sizer		= new wxBoxSizer(wxVERTICAL );
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text1	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(logoPanel,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text2	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text3	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text4	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text5	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);
	sizer->Add(text0	,	0, wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL, 0);

	this->SetSizer(sizer);
	this->SetAutoLayout(true);

}


*/

