/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasImageBrowser.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include <wx/image.h>
#include "wxMaracasImageBrowser.h"
//----------------------------------------------------------------------------
wxMaracasImageBrowser::wxMaracasImageBrowser( wxFrame* parent, marInterface* mar, wxWindowID id )
    : wxPanel( parent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL )
{
//    _mar = mar;

    _view_image = new wxImageViewerWidgetRoi( this, -1 );
    //parent->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, _view_image->_bboxEnabled);

    wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
    szTop->Add( _view_image, 1, wxEXPAND | wxALL, 10 );
    SetAutoLayout( true );
    SetSizer( szTop );
    szTop->Fit( this );
    szTop->SetSizeHints( this );

}
//----------------------------------------------------------------------------
wxMaracasImageBrowser::~wxMaracasImageBrowser()
{
  delete _view_image;
//  delete szTop
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser::LoadData( vtkImageData *imagedata )
{

//    _mar->_dicom->loadActualSerie();
//    vtkImageData *dummy = _mar->_dicom->getVolume( )->castVtk();
    //float range[2];
    //dummy->GetScalarRange( range );

    _view_image->ConstructVTK( imagedata );
    //_view_image->ConstructVTK(  (vtkImageData *)_mar->_dicom->getVolume( ));
    //^ this is not working ??? I don't understand why, some VTK pipeline mystery
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser::GetROI( int ext[6] )
{
    _view_image->GetROI( ext );
}

// EOF - wxImageBrowser.cxx
