/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasImageBrowser02.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include <wx/image.h>
#include <wx/filedlg.h>
#include "wxMaracasImageBrowser02.h"

DEFINE_EVENT_TYPE(wxEVT_MARACASIMAGEBROWSERCUTIMAGE)

BEGIN_EVENT_TABLE( wxMaracasImageBrowser02, wxPanel )
	EVT_MENU( 12121, wxMaracasImageBrowser02::OnRefreshView  )
	EVT_MENU( 12122, wxMaracasImageBrowser02::OnRefreshView2 )
END_EVENT_TABLE( );



//----------------------------------------------------------------------------

//EED 15Avril2008
//wxMaracasImageBrowser02::wxMaracasImageBrowser02( wxWindow* parent, marInterface* mar, wxWindowID id )
//    : wxPanel( parent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL ){

wxMaracasImageBrowser02::wxMaracasImageBrowser02( wxWindow* parent, marFilesBase *dicom ,marParameters* parameters )
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL ){

	this->SetSize(100,100);

    //parent->GetToolBar()->EnableTool(ID_TOOLBAR_3D_BROWSER, _view_image->_bboxEnabled);
	_parameters = parameters;

    wxPanel *panel1=new wxPanel(this,-1);
	_btnRestRoi	= new wxButton (panel1,-1,_T("Set VOI"),wxDefaultPosition ,wxSize(100,80)  );
	_loadRangeImage = new LoadRangeImage(panel1,dicom);
	_loadRangeImage->SetSize(100,100);
	wxButton *bt_SavePerpSlice	= new wxButton(panel1,-1,_T("Save VOI image"));
	wxButton *bt_CutVolume	= new wxButton(panel1,-1,_T("Cut Volume"));
	Connect(bt_SavePerpSlice->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxMaracasImageBrowser02::OnBtSaveVOIData );
	Connect(bt_CutVolume->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &wxMaracasImageBrowser02::OnBtnCutVolume );
	Connect(_btnRestRoi->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED	, (wxObjectEventFunction) (wxCommandEventFunction) &wxMaracasImageBrowser02::OnBtnResetRoi	);


    wxPanel *panel2=new wxPanel(this,-1);
	_imageviewer2D_1 = new wxVtk2DBaseView(panel2);
	wxVTKRenderWindowInteractor *iren = _imageviewer2D_1->GetWxVTKRenderWindowInteractor();
    wxBoxSizer *sizerDown= new wxBoxSizer(wxVERTICAL);
	sizerDown->Add(	iren		, 1,  wxEXPAND , 0 );
    panel2->SetSizer( sizerDown );
    panel2->SetAutoLayout( true );
    panel2->SetSize( 100,100 );
    panel2->Layout();



//    wxBoxSizer *sizer1= new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer *sizer1= new wxFlexGridSizer(10);
    panel1->SetSizer( sizer1 );
	sizer1->AddGrowableCol(1);
	sizer1->Add( _btnRestRoi	);
	sizer1->Add( _loadRangeImage,1,wxEXPAND,0		);
	sizer1->Add( bt_SavePerpSlice);
	sizer1->Add( bt_CutVolume);


    wxFlexGridSizer *sizer= new wxFlexGridSizer(1);
	sizer->AddGrowableCol(0);
	sizer->AddGrowableRow(1);


	sizer->Add(	panel1	,1,wxEXPAND,0 );
	sizer->Add(	panel2		, 1,  wxGROW , 0 );

    this->SetSizer( sizer );
    this->SetAutoLayout( true );
    this->Layout();
}
//----------------------------------------------------------------------------
wxMaracasImageBrowser02::~wxMaracasImageBrowser02()
{
  delete _imageviewer2D_1;
}

//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::OnBtnCutVolume( wxCommandEvent &  event )
{
		wxCommandEvent cevent( wxEVT_MARACASIMAGEBROWSERCUTIMAGE, GetId() );
		cevent.SetEventObject( this );
		GetEventHandler()->ProcessEvent( cevent );
}

//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::OnBtnResetRoi( wxCommandEvent &  event )
{
	if (_loadRangeImage!=NULL) {_loadRangeImage->Reset();}

	vtkImageData *imagedata = _vtkbasedata_1->GetImageData();
	int dim[3];
	imagedata->GetDimensions(dim);


	vtkImageViewer2		*IV2= this->_imageviewer2D_1->_imageViewer2XYZ->GetVtkImageViewer2();
	vtkCamera		*camera = IV2->GetRenderer()->GetActiveCamera();
	double pos[3];
	camera->GetPosition(pos);


// EED 27 sep 2006
//	double spc[3];
//	imagedata->GetSpacing(spc);
//	_manRoiControl->InitRoi( dim[0]*spc[0] , dim[1]*spc[1] , 0.2 );

	_manRoiControl->InitRoi( dim[0]  , dim[1] , 0.2);
	_manRoiControl->SetActive(true);

	_btnRestRoi->SetLabel( _T("Reset VOI") );

	_imageviewer2D_1->Refresh();

}


//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::LoadData( marImageData *marimagedata )
{
	vtkImageData *imagedata = marimagedata->GetImageData();
	imagedata->UpdateInformation();
	imagedata->SetUpdateExtent(imagedata->GetWholeExtent());
	imagedata->Update();

	_vtkbasedata_1 = new vtkBaseData();
	_vtkbasedata_1->SetMarImageData( marimagedata );
	_imageviewer2D_1->SetVtkBaseData( _vtkbasedata_1 );
	_imageviewer2D_1->Configure(true);

//	vtkImageViewer2 *_imageViewer=_imageviewer2D_1->_imageViewer2XYZ->GetVtkImageViewer2();

	_manRoiControl  = new manualRoiControler();

//JSTG 25-02-08 -------------------------------------
	//_mContourModel  = new manualContourModel();
	_mContourModel  = new manualContourModelRoi();
//---------------------------------------------------
	_mViewRoi		= new manualViewRoi();
	_mViewRoi->SetModel( _mContourModel );
	_mViewRoi->SetWxVtkBaseView( _imageviewer2D_1 );
	_mViewRoi->SetRange( (int)1.5 );


// EED 3 oct 2006
	double spc[3];
	imagedata->GetSpacing(spc);
	_mViewRoi->SetSpacing(spc);

	_manRoiControl->SetModelView( _mContourModel , _mViewRoi );
	_imageviewer2D_1->GetInteractorStyleBaseView()->AddInteractorStyleMaracas( _manRoiControl );
	_manRoiControl->CreateNewManualContour();
	_manRoiControl->SetState(0);
	_manRoiControl->SetActive(false);
	_mViewRoi->RefreshContour();

	_imageviewer2D_1->GetWxVTKRenderWindowInteractor()->Render();
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::SetROI( int voi[6] )
{	
	_loadRangeImage->Reset();
	_loadRangeImage->SetStartEnd( voi[4],voi[5]);
	_manRoiControl->SetRoi( voi[0],voi[2], voi[1],voi[3] );
	_manRoiControl->SetActive(true);
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::GetROI( int ext[6] )
{	
	double minX,minY,maxX,maxY;
	_mViewRoi->GetMinMax(minX,minY,maxX,maxY);
	ext[0]=(int)minX;
	ext[1]=(int)maxX;
	ext[2]=(int)minY;
	ext[3]=(int)maxY;



// EED 27 sep 206
//	double spacing[3];
//	_vtkbasedata_1->GetImageData ()->GetSpacing( spacing );
//	ext[0] /= spacing[0];
//	ext[1] /= spacing[0];
//	ext[2] /= spacing[1];
//	ext[3] /= spacing[1];

	_loadRangeImage->GetROI( ext ); // ext[4..5]

	if ( (ext[0]==ext[1]) || (ext[2]==ext[3]) || (ext[4]==ext[5]) )
	{
		int border[6];
		_vtkbasedata_1->GetImageData ()->GetExtent( border );
		ext[0] = border[0];
		ext[1] = border[1];
		ext[2] = border[2];
		ext[3] = border[3];
		ext[4] = border[4];
		ext[5] = border[5];
	}

}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::Start( ){
	_loadRangeImage->Start();
}

//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::ForceToFinisReadActiveImages(){
	_loadRangeImage->ForceToFinisReadActiveImages();
}
//----------------------------------------------------------------------------
bool wxMaracasImageBrowser02::GetRoiSelected()
{
	double minX,minY,maxX,maxY;
	_mViewRoi->GetMinMax(minX,minY,maxX,maxY);

	bool result=true;
	if ( (minX==maxX) || (minY==maxY) )
	{
		result=false;
	}
	return result;
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::Refresh()
{
	int z = (int)_vtkbasedata_1->GetZ( ); 
	_loadRangeImage->SetActualSlice( z );
	_loadRangeImage->RefreshSlice();
	z = _loadRangeImage->GetActualSlice(  );
	_vtkbasedata_1->SetZ( z );

//	_imageviewer2D_1->Refresh();
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::OnRefreshView(wxCommandEvent & event)
{
	Refresh();
}
//----------------------------------------------------------------------------
void wxMaracasImageBrowser02::OnRefreshView2(wxCommandEvent & event)
{
	_loadRangeImage -> ResetActualSlice();//SIL//
	int z = _loadRangeImage->GetActualSlice();	
	_vtkbasedata_1->SetZ( z );
	_imageviewer2D_1->Refresh();
}



// EED 04Janvier2007
//------------------------------------------------------------------------
void wxMaracasImageBrowser02::OnBtSaveVOIData(wxCommandEvent& event)
{
	wxFileDialog dialog(this, _T("Choose a file"), _T(""), _T(""), _T("*.maracas"), wxSAVE );
	if (dialog.ShowModal() == wxID_OK)
	{
		ForceToFinisReadActiveImages();
		std::string directory		= (const char *)(dialog.GetDirectory().mb_str());
		std::string filename		= (const char *)(dialog.GetFilename().mb_str());
		float rescalaSlope          =  _parameters->getRescaleSlope();
		float rescalaIntercept      =  _parameters->getRescaleIntercept();
		vtkImageData *vtkimagedata	= this->_vtkbasedata_1->GetMarImageData()->GetImageData();
		int voi[6];
		this->GetROI(voi);
		marRAW2Files marraw2;
		marraw2.saveVolume(directory,filename,vtkimagedata,voi,rescalaSlope,rescalaIntercept);
	}
}


// EOF - wxImageBrowser.cxx
