/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasImageBrowser02.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__IMAGE__BROWSER02__
#define __WX__IMAGE__BROWSER02__

#include "wx/wxprec.h"
#ifdef __BORLANDC__
#  pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif



#include <wx/window.h>
#include <wx/imaglist.h>
#include <wx/panel.h>
#include <wx/listctrl.h>
#include <wx/splitter.h>

#include "marParameters.h" 
#include "widgets/wxVtkBaseView.h" 
//#include "widgets/wxImageViewerWidget.h"
#include "widgets/wxReadingPriorityPanel.h"

#include "manualContourModelRoi.h"
#include "manualRoiControler.h"
#include "manualViewRoi.h"


BEGIN_DECLARE_EVENT_TYPES()
 DECLARE_EVENT_TYPE(wxEVT_MARACASIMAGEBROWSERCUTIMAGE, -1)
END_DECLARE_EVENT_TYPES()


/**
 * \brief Panel class that show thumbnails images
 */
class wxMaracasImageBrowser02 : public wxPanel
{
public:
    wxMaracasImageBrowser02( wxWindow* parent, marFilesBase *dicom ,marParameters* parameters );
    //wxMaracasImageBrowser02( wxWindow* parent, marInterface* mar, wxWindowID id = -1 );
    ~wxMaracasImageBrowser02();

    void LoadData( marImageData *marimagedata);
    void GetROI( int ext[6] );
    void SetROI( int voi[6] );
	bool GetRoiSelected();
	

	void Start();
	void ForceToFinisReadActiveImages();

	void Refresh();
	void OnRefreshView(wxCommandEvent & event);
	void OnRefreshView2(wxCommandEvent & event);
	void OnBtnResetRoi( wxCommandEvent &  event );
	void OnBtSaveVOIData(wxCommandEvent& event);
	void OnBtnCutVolume( wxCommandEvent &  event );

private:

	wxButton 			*_btnRestRoi;

	marParameters			*_parameters;
	LoadRangeImage			*_loadRangeImage;

	vtkBaseData				*_vtkbasedata_1;
	wxVtk2DBaseView			*_imageviewer2D_1;

	manualRoiControler		*_manRoiControl;
	manualContourModel		*_mContourModel;

	manualViewRoi			*_mViewRoi;



	DECLARE_EVENT_TABLE( );
};

#endif // __WX__IMAGE__BROWSER02__
