/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

 Program:   wxMaracas
 Module:    $RCSfile: wxMaracasParametersDialog.cxx,v $
 Language:  C++
 Date:      $Date: 2012/11/15 14:14:56 $
 Version:   $Revision: 1.2 $
 
  Copyright: (c) 2002, 2003
  License:
  
   This software is distributed WITHOUT ANY WARRANTY; without even 
   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
   PURPOSE.  See the above copyright notice for more information.
   
=========================================================================*/

#include "wxMaracasParametersDialog.h"
#include "marDictionary.h"

// ----------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxMaracasParametersDialog, wxDialog )
	EVT_BUTTON( wxID_OK, wxMaracasParametersDialog::OnOk )
	EVT_BUTTON( wxID_CANCEL, wxMaracasParametersDialog::OnCancel )
	EVT_BUTTON( ID_BTN_DEFAULT, wxMaracasParametersDialog::OnDefault )
	EVT_BUTTON( ID_BTN_RESET, wxMaracasParametersDialog::OnReset )
	EVT_BUTTON( ID_BTN_APPLY, wxMaracasParametersDialog::OnApply )
	// PS -> 	EVT_BUTTON( ID_BTN_BROWSE_WORK_DIR, wxMaracasParametersDialog::OnBrowseWorkDir )
	// PS -> 	EVT_BUTTON( ID_BTN_BROWSE_DICOM_DIR, wxMaracasParametersDialog::OnBrowseDICOMDir )
	// PS -> 	EVT_BUTTON( ID_BTN_3D_BACK_COLOR, wxMaracasParametersDialog::OnChoose3DColor )
	// PS -> 	EVT_BUTTON( ID_BTN_AXIS_COLOR, wxMaracasParametersDialog::OnChooseAxisColor )
END_EVENT_TABLE( );

// ----------------------------------------------------------------------------
wxMaracasParametersDialog::wxMaracasParametersDialog( wxWindow* parent, marInterface* mar )
: wxParametersDialog( parent, -1, _T(""))
{
	_parent=parent;
    _mar = mar;
    Reset( );

	SetBakEdit();
}

// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::Reset( )
{
	// PS -> //    wxColour col, col2;
    int qt, st;
	
    // General parameters
	// PS -> //    edtWorkDir->SetValue( _mar->_parameters->getStringParam( marParameters::e_installation_directory ) );
	// PS ->     edtDICOMDir->SetValue( _mar->_parameters->getStringParam( marParameters::e_dicom_images_directory ) );
	// PS ->     chkMIP->SetValue( _mar->_parameters->getBoolParam( marParameters::e_calculate_mip_default ) );
	// PS ->     chkSlices->SetValue( _mar->_parameters->getBoolParam( marParameters::e_choose_all_slices_default ) );
	// PS ->     chkDebugWindow->SetValue( _mar->_parameters->getBoolParam( marParameters::e_debug_window_visible ) );
	// PS ->     chkConsole->SetValue( _mar->_parameters->getBoolParam( marParameters::e_debug_console_visible ) );
	// PS -> //    col.Set(
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_back_color_3D_r ),
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_back_color_3D_g ),
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_back_color_3D_b )
	// PS -> //        );
	// PS -> //    btn3DBackColor->SetBackgroundColour( col );
    
    // Contour parameters
    edtThresholdIsoContours->SetValue( wxString::Format( _T("%.2f"), 
		_mar->_parameters->getDoubleParam( marParameters::e_threshold_isocontour ) ) );
	// PS -> //    edtThresholdSnake->SetValue( wxString::Format( "%.4f", 
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_threshold_snake_isocontour ) ) );
	// PS -> //    edtIterationsSnake->SetValue( wxString::Format( "%d", 
	// PS -> //		_mar->_parameters->getIntParam( marParameters::e_number_of_iterations_snake_isocontour ) ) );
	// PS -> //    edtExternCoefSnake->SetValue( wxString::Format( "%.4f", 
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_extern_coeficient ) ) );
	// PS -> //    edtIterationsDeriche->SetValue( wxString::Format( "%d", 
	// PS -> //		_mar->_parameters->getIntParam( marParameters::e_number_of_iterations_snake_deriche ) ) );
	// PS -> //    edtBallonCoefDeriche->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_ballon_coeficient ) ) );
	// PS -> //    edtGradientCoefDeriche->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_gradient_coeficient ) ) );
	// PS -> //    edtSigmaDeriche->SetValue( wxString::Format( "%.4f", 
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_sigma ) ) );
	// PS -> //    edtScale->SetValue( wxString::Format( "%.4f", 
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_scale ) ) );
	// PS -> //    edtSample->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_sampling ) ) );
//EED    chkIsoContoursVis->SetValue( _mar->_parameters->getBoolParam( marParameters::e_debug_isocontour ) );
//EED    chkDiametersVis->SetValue( _mar->_parameters->getBoolParam( marParameters::e_debug_diameters ) );
//EED    chkInvertSliceOrder->SetValue( _mar->_parameters->getBoolParam( marParameters::e_invest_slice_order ) );
	// PS -> //    chkFillContours->SetValue( _mar->_parameters->getBoolParam( marParameters::e_debug_fill_area ) );
	// PS -> //    radIsoContours->SetValue( _mar->_parameters->getIntParam( marParameters::e_algorithm_type ) == marParameters::ISOCONTOURS );
	// PS -> //    radSnake->SetValue( _mar->_parameters->getIntParam( marParameters::e_algorithm_type ) == marParameters::SNAKE );
	// PS -> //    radDeriche->SetValue( _mar->_parameters->getIntParam( marParameters::e_algorithm_type ) == marParameters::DERICHE );
	
	
    // Axis parameters
	// PS -> //    edtDistanceCdg->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_gravity_distance ) ) );
    edtFlexionCoef->SetValue( wxString::Format( _T("%g"), 
		_mar->_parameters->getDoubleParam( marParameters::e_flexion_coeficient ) ) );
   edtTensionCoef->SetValue( wxString::Format( _T("%g"), 
		_mar->_parameters->getDoubleParam( marParameters::e_tension_coeficient ) ) );
    int sizemask = _mar->_parameters->getIntParam( marParameters::e_mask_size );
	sizemask=(sizemask-1)/2;
    edtMaskSize->SetValue( wxString::Format( _T("%d"), sizemask ) );
    edtDiscreetStep->SetValue( wxString::Format( _T("%#.2f"), 
		_mar->_parameters->getDoubleParam( marParameters::e_axis_discret_step ) ) );
	// PS -> //    edtVoxelX->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_voxel_x_dimension ) ) );
	// PS -> //    edtVoxelY->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_voxel_y_dimension ) ) );
	// PS -> //    edtVoxelZ->SetValue( wxString::Format( "%.4f",
	// PS -> //		_mar->_parameters->getDoubleParam( marParameters::e_voxel_z_dimension ) ) );
	// PS ->     edtDistanceInt->SetValue( wxString::Format( "%.4f",
	// PS -> 		_mar->_parameters->getDoubleParam( marParameters::e_distance_to_maximum_intensity ) ) );
	// PS ->     edtCellMaxIntCoef->SetValue( wxString::Format( "%d",
	// PS -> 		_mar->_parameters->getIntParam( marParameters::e_coef_cell_max_int ) ) );
	// PS ->     edtCellCoef->SetValue( wxString::Format( "%.4f",
	// PS -> 		_mar->_parameters->getDoubleParam( marParameters::e_cell_coeficient ) ) );
	// PS ->     edtStepCoef->SetValue( wxString::Format( "%d",
	// PS -> 		_mar->_parameters->getIntParam( marParameters::e_step_coeficient ) ) );
	// PS ->     edtMassPower->SetValue( wxString::Format( "%d", 
	// PS -> 		_mar->_parameters->getIntParam( marParameters::e_mass_power ) ) );
	// PS ->     edtROIDimension->SetValue( wxString::Format( "%d", 
	// PS -> 		_mar->_parameters->getIntParam( marParameters::e_roi_dimension ) ) );
	// PS ->     edtStep->SetValue( wxString::Format( "%d", 
	// PS -> 		_mar->_parameters->getIntParam( marParameters::e_step ) ) );
	// PS -> //    chkShowCell->SetValue( _mar->_parameters->getBoolParam( marParameters::e_show_cell ) );
	// PS -> //    chkShowIntCell->SetValue( _mar->_parameters->getBoolParam( marParameters::e_show_int_cell ) );
	// PS -> //    radMinimum->SetValue( _mar->_parameters->getIntParam( marParameters::e_voxel_type ) == marParameters::VOX_TYPE_MINIMUM );
	// PS -> //    radNormal->SetValue( _mar->_parameters->getIntParam( marParameters::e_voxel_type ) == marParameters::VOX_TYPE_NORMAL );
	// PS -> //    col2.Set(
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_axis_color_r ),
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_axis_color_g ),
	// PS -> //        _mar->_parameters->getDoubleParam( marParameters::e_axis_color_b )
	// PS -> //        );
	// PS -> //    btnAxisColor->SetBackgroundColour( col2 );
	
	
    // Quantification parameters
    qt = _mar->_parameters->getIntParam( marParameters::e_quantification_type );
    st = _mar->_parameters->getIntParam( marParameters::e_stenosis_type );

/* // EED borrame
    chkArea->SetValue( ( qt & marParameters::TYPE_AREA ) == marParameters::TYPE_AREA );
    chkPerimeter->SetValue( ( qt & marParameters::TYPE_PERIMETER ) == marParameters::TYPE_PERIMETER );
    chkDiameterFromArea->SetValue( ( qt & marParameters::TYPE_DIAMETER_FROM_AREA ) == marParameters::TYPE_DIAMETER_FROM_AREA );
    chkDiameterFromPerimeter->SetValue( ( qt & marParameters::TYPE_DIAMETER_FROM_PERIMETER ) == marParameters::TYPE_DIAMETER_FROM_PERIMETER );
    chkMinimumDiameter->SetValue( ( qt & marParameters::TYPE_MINIMUM_DIAMETER ) == marParameters::TYPE_MINIMUM_DIAMETER );
    chkMaximumDiameter->SetValue( ( qt & marParameters::TYPE_MAXIMUM_DIAMETER ) == marParameters::TYPE_MAXIMUM_DIAMETER );
    chkAverageDiameter->SetValue( ( qt & marParameters::TYPE_AVERAGE_DIAMETER ) == marParameters::TYPE_AVERAGE_DIAMETER );
    radArea->SetValue( st == marParameters::TYPE_AREA );
    radPerimeter->SetValue( st == marParameters::TYPE_PERIMETER );
    radDiameterFromArea->SetValue( st == marParameters::TYPE_DIAMETER_FROM_AREA );
    radDiameterFromPerimeter->SetValue( st == marParameters::TYPE_DIAMETER_FROM_PERIMETER );
    radMinimumDiameter->SetValue( st == marParameters::TYPE_MINIMUM_DIAMETER );
    radMaximumDiameter->SetValue( st == marParameters::TYPE_MAXIMUM_DIAMETER );
    radAverageDiameter->SetValue( st == marParameters::TYPE_AVERAGE_DIAMETER );
*/	
}
// ----------------------------------------------------------------------------
bool wxMaracasParametersDialog::Apply( )
{
	marDictionary marDict;
	char tmp[256];

	bool alertRegenerateAll		= false;
	bool alertRegenerateSignal	= false;
	bool alertClearContours		= false;
	bool alertRegenerateSplineAxe	= false;

	wxMessageDialog *wxdiag;
	wxString wxtext;

	if ( _bak_edtMaskSize_String.CompareTo( edtMaskSize->GetValue().GetData() )!=0  ) {
		alertRegenerateSignal=true;
		strcpy(tmp , marDict.GetString(605) ); strcat(tmp,"\n");
		wxtext=wxString(tmp, wxConvUTF8); //"The mask size was modified. \n"
	}
	if ( _bak_edtThresholdIsoContours_String.CompareTo( edtThresholdIsoContours->GetValue().GetData() )!=0  ) {
		alertClearContours=true;
		strcpy(tmp , marDict.GetString(610) ); strcat(tmp,"\n");
		wxtext=wxString(tmp, wxConvUTF8); //"The threshold was modified. \n"
	}
	if ( _bak_edtFlexionCoef_String.CompareTo( edtFlexionCoef->GetValue().GetData() )!=0  ) {
		alertRegenerateAll=true;
		strcpy(tmp , marDict.GetString(615) ); strcat(tmp,"\n");
		wxtext=wxtext+wxString(tmp, wxConvUTF8);//"The flexion coeficient was modified.\n"
	}
	if ( _bak_edtTensionCoef_String.CompareTo( edtTensionCoef->GetValue().GetData() )!=0  ) {
		alertRegenerateAll=true;
		strcpy(tmp , marDict.GetString(620) ); strcat(tmp,"\n");
		wxtext=wxtext+wxString(tmp, wxConvUTF8);//"The tension coeficient was modified.\n"
	}	
	if ( _bak_edtDiscreetStep_String.CompareTo( edtDiscreetStep->GetValue().GetData() )!=0  ) {
		alertRegenerateSplineAxe=true;
		strcpy(tmp , marDict.GetString(625) ); strcat(tmp,"\n");
		wxtext=wxtext+wxString(tmp, wxConvUTF8);//"The discret step of the axis was modified.\n"
	}	

	if ((alertRegenerateAll==true) ||(alertRegenerateSplineAxe==true) ) {		
		strcpy(tmp,"\n"); strcat(tmp , marDict.GetString(630) ); strcat(tmp,"\n");
		wxtext=wxtext+wxString(tmp, wxConvUTF8);//"\n The axe will be regenereted and the contours will be eresed. \n"
	} else {
		if ((alertRegenerateAll==true) ||(alertRegenerateSplineAxe==true) ) {	
			strcpy(tmp,"\n"); strcat(tmp , marDict.GetString(635) ); strcat(tmp,"\n");
			wxtext=wxtext+wxString(tmp, wxConvUTF8); //"\n All contours will be erase. \n"
		}
	}

	if ( (alertRegenerateAll==true) || 
		 (alertClearContours==true) || 
		 (alertRegenerateSignal==true) || 
		 (alertRegenerateSplineAxe==true) ) {
		strcpy(tmp,"\n"); strcat(tmp , marDict.GetString(640) ); 
		wxdiag= new wxMessageDialog(this, wxtext + wxString(tmp, wxConvUTF8), wxString(marDict.GetString(645), wxConvUTF8), wxOK | wxCANCEL);//"\n Do you want to continue?"   "Alert" 
		if ( wxdiag->ShowModal() != wxID_OK ) {
			return true; 
		}
		wxdiag->Destroy();
	}


	// PS -> //    wxColour col;
    double td;
	long tl;
    int ti;
	
    // General parameters
	
	// PS -> //    _mar->_parameters->setStringParam( marParameters::e_installation_directory, edtWorkDir->GetValue( ) );
	// PS ->     _mar->_parameters->setStringParam( marParameters::e_dicom_images_directory, edtDICOMDir->GetValue( ) );
		
	// PS ->     _mar->_parameters->setBoolParam( marParameters::e_calculate_mip_default, chkMIP->GetValue( ) );
	// PS ->     _mar->_parameters->setBoolParam( marParameters::e_choose_all_slices_default, chkSlices->GetValue( ) );
	// PS ->     _mar->_parameters->setBoolParam( marParameters::e_debug_window_visible, chkDebugWindow->GetValue( ) );
	// PS ->     _mar->_parameters->setBoolParam( marParameters::e_debug_console_visible, chkConsole->GetValue( ) );
	
	// PS -> //	col = btn3DBackColor->GetBackgroundColour( );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_back_color_3D_r, col.Red( ) );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_back_color_3D_g, col.Green( ) );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_back_color_3D_b, col.Blue( ) );
	// PS -> 	
	// PS ->     // Axis parameters
	// PS -> //   	if (!edtDistanceCdg->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //	_mar->_parameters->setDoubleParam( marParameters::e_gravity_distance, td );
	
    if (!edtFlexionCoef->GetValue( ).ToDouble( &td ))
		return false;
    _mar->_parameters->setDoubleParam( marParameters::e_flexion_coeficient, td );
	
    if (!edtTensionCoef->GetValue( ).ToDouble( &td ))
		return false;
    _mar->_parameters->setDoubleParam( marParameters::e_tension_coeficient, td );
	
    if (!edtDiscreetStep->GetValue( ).ToDouble( &td ))
		return false;
    _mar->_parameters->setDoubleParam( marParameters::e_axis_discret_step, td );
	
	// PS -> //    if (!edtVoxelX->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_voxel_x_dimension, td );
	// PS -> 
	// PS -> //    if (!edtVoxelY->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_voxel_y_dimension, td );
	// PS -> 
	// PS -> //    if (!edtVoxelZ->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_voxel_z_dimension, td );
	// PS -> 
	// PS ->     if (!edtDistanceInt->GetValue( ).ToDouble( &td ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setDoubleParam( marParameters::e_distance_to_maximum_intensity, td );
	// PS -> 
	// PS ->     if (!edtCellCoef->GetValue( ).ToDouble( &td ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setDoubleParam( marParameters::e_cell_coeficient, td );
	// PS -> 
	if (!edtMaskSize->GetValue( ).ToLong( &tl ))
	  return false;
	_mar->_parameters->setIntParam( marParameters::e_mask_size, ( int )tl * 2 +1);
	 
	// PS ->     if (!edtCellMaxIntCoef->GetValue( ).ToLong( &tl ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setIntParam( marParameters::e_coef_cell_max_int, ( int )tl );
	// PS -> 
	// PS ->     if (!edtStepCoef->GetValue( ).ToLong( &tl ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setIntParam( marParameters::e_step_coeficient, ( int )tl );
	// PS -> 
	// PS ->     if (!edtMassPower->GetValue( ).ToLong( &tl ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setIntParam( marParameters::e_mass_power, ( int )tl );
	// PS -> 
	// PS ->     if (!edtROIDimension->GetValue( ).ToLong( &tl ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setIntParam( marParameters::e_roi_dimension, ( int )tl );
	// PS -> 
	// PS ->     if (!edtStep->GetValue( ).ToLong( &tl ))
	// PS -> 		return false;
	// PS ->     _mar->_parameters->setIntParam( marParameters::e_step, ( int )tl );
	// PS -> 
	// PS -> //    _mar->_parameters->setBoolParam( marParameters::e_show_cell, chkShowCell->GetValue( ) );
	// PS -> //    _mar->_parameters->setBoolParam( marParameters::e_show_int_cell, chkShowIntCell->GetValue( ) );
	// PS -> 
	// PS -> //    _mar->_parameters->setIntParam( marParameters::e_voxel_type, radNormal->GetValue( ) ? marParameters::VOX_TYPE_NORMAL: marParameters::VOX_TYPE_MINIMUM );
	// PS ->     
	// PS -> //	wxColour col2 = btnAxisColor->GetBackgroundColour( );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_axis_color_r, col2.Red( ) );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_axis_color_g, col2.Green( ) );
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_axis_color_b, col2.Blue( ) );
	
    // Contour parameters
    if (!edtThresholdIsoContours->GetValue( ).ToDouble( &td ))
		return false;
    _mar->_parameters->setDoubleParam( marParameters::e_threshold_isocontour, td );
	
	// PS -> //    if (!edtThresholdSnake->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_threshold_snake_isocontour, td );
	// PS -> 
	// PS -> //    if (!edtExternCoefSnake->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_extern_coeficient, td );
	// PS -> 
	// PS -> //    if (!edtBallonCoefDeriche->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_ballon_coeficient, td );
	// PS -> 
	// PS -> //    if (!edtGradientCoefDeriche->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_gradient_coeficient, td );
	// PS -> 
	// PS -> //    if (!edtSigmaDeriche->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_sigma, td );
	// PS -> 
	// PS -> //    if (!edtScale->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_scale, td );
	// PS -> 
	// PS -> //   if (!edtSample->GetValue( ).ToDouble( &td ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setDoubleParam( marParameters::e_sampling, td );
	// PS -> 
	// PS -> //    if (!edtIterationsSnake->GetValue( ).ToLong( &tl ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setIntParam( marParameters::e_number_of_iterations_snake_isocontour, ( int )tl );
	// PS -> 
	// PS -> //    if (!edtIterationsDeriche->GetValue( ).ToLong( &tl ))
	// PS -> //		return false;
	// PS -> //    _mar->_parameters->setIntParam( marParameters::e_number_of_iterations_snake_deriche, ( int )tl );
	
//EED    _mar->_parameters->setBoolParam( marParameters::e_debug_isocontour, chkIsoContoursVis->GetValue( ) );
//EED    _mar->_parameters->setBoolParam( marParameters::e_debug_diameters, chkDiametersVis->GetValue( ) );
//EED    _mar->_parameters->setBoolParam( marParameters::e_invest_slice_order, chkInvertSliceOrder->GetValue( ) );
	// PS -> //    _mar->_parameters->setBoolParam( marParameters::e_debug_fill_area, chkFillContours->GetValue( ) );
	// PS -> //    ti = 0;
	// PS -> //    ti = radIsoContours->GetValue( ) ? marParameters::ISOCONTOURS: ti;
	// PS -> //    ti = radSnake->GetValue( ) ? marParameters::SNAKE: ti;
	// PS -> //    ti = radDeriche->GetValue( ) ? marParameters::DERICHE: ti;
    ti = marParameters::ISOCONTOURS;
	_mar->_parameters->setIntParam( marParameters::e_algorithm_type, ti );
	
/* // EED borrame
    // Quantification parameters
    ti = 0;
    ti |= chkArea->GetValue( ) ? marParameters::TYPE_AREA: 0;
    ti |= chkPerimeter->GetValue( ) ? marParameters::TYPE_PERIMETER: 0;
    ti |= chkDiameterFromArea->GetValue( ) ? marParameters::TYPE_DIAMETER_FROM_AREA: 0;
    ti |= chkDiameterFromPerimeter->GetValue( ) ? marParameters::TYPE_DIAMETER_FROM_PERIMETER: 0;
    ti |= chkMinimumDiameter->GetValue( ) ? marParameters::TYPE_MINIMUM_DIAMETER: 0;
    ti |= chkMaximumDiameter->GetValue( ) ? marParameters::TYPE_MAXIMUM_DIAMETER: 0;
    ti |= chkAverageDiameter->GetValue( ) ? marParameters::TYPE_AVERAGE_DIAMETER: 0;
    _mar->_parameters->setIntParam( marParameters::e_quantification_type, ti );
    ti = 0;
    ti = radArea->GetValue( ) ? marParameters::TYPE_AREA: ti;
    ti = radPerimeter->GetValue( ) ? marParameters::TYPE_PERIMETER: ti;
    ti = radDiameterFromArea->GetValue( ) ? marParameters::TYPE_DIAMETER_FROM_AREA: ti;
    ti = radDiameterFromPerimeter->GetValue( )? marParameters::TYPE_DIAMETER_FROM_PERIMETER: ti;
    ti = radMinimumDiameter->GetValue( ) ? marParameters::TYPE_MINIMUM_DIAMETER: ti;
    ti = radMaximumDiameter->GetValue( ) ? marParameters::TYPE_MAXIMUM_DIAMETER: ti;
    ti = radAverageDiameter->GetValue( ) ? marParameters::TYPE_AVERAGE_DIAMETER: ti;
    _mar->_parameters->setIntParam( marParameters::e_stenosis_type, ti );
*/

	SetBakEdit();

	if (alertRegenerateAll==true){
                wxCommandEvent ev19999(wxEVT_COMMAND_MENU_SELECTED,19999);
		_parent->ProcessEvent( ev19999 );

/* EED Borrame
		// Clear Interface
		if ( wxwinquan!=NULL		) { wxwinquan->Clean3D(true);	}
		if ( wxwin3DBrowser!=NULL   ) { wxwin3DBrowser->Clean3D();	}
		// Model Regeneration
		_mar->_experiment->RegenerateAxis();
		// Refresh Interface
		if ( wxwinquan!=NULL		) { 
			wxwinquan->AddAxisActors();
			wxwinquan->RefreshAxis();				
		}
		if ( wxwin3DBrowser!=NULL	) { 
			wxwin3DBrowser->AddAxisActors();
			wxwin3DBrowser->RefreshAxis();
		}
*/
	}

	if (alertRegenerateSplineAxe==true){
		wxCommandEvent ev19998(wxEVT_COMMAND_MENU_SELECTED,19998);
		_parent->ProcessEvent( ev19998 );
/* EED Borrame
		// Clear Interface
		if ( wxwinquan!=NULL		) { wxwinquan->Clean3D(true);	}
		if ( wxwin3DBrowser!=NULL   ) { wxwin3DBrowser->Clean3D();	}
		// Model Regeneration
		_mar->_experiment->RecalculateAxis();
		// Refresh Interface
		if ( wxwinquan!=NULL		) { 
			wxwinquan->AddAxisActors();
			wxwinquan->RefreshAxis();				
		}
		if ( wxwin3DBrowser!=NULL	) { 
			wxwin3DBrowser->AddAxisActors();
			wxwin3DBrowser->RefreshAxis();
		}
*/
	}


	if (alertClearContours==true) {
		wxCommandEvent ev19997(wxEVT_COMMAND_MENU_SELECTED,19997);
		_parent->ProcessEvent( ev19997 );
/* EED Borrame
		// Update Interface
		if ( wxwinquan!=NULL   ) { wxwinquan->Clean3D(false);		}
		// Model Regeneration
		_mar->_experiment->ClearContours();
		// Refresh Interface
		if ( wxwinquan!=NULL   ) { wxwinquan->RefreshAxis();	}
*/
	}

	if (alertRegenerateSignal==true) {
		wxCommandEvent ev19996(wxEVT_COMMAND_MENU_SELECTED,19996);
		_parent->ProcessEvent( ev19996 );
/* EED Borrame
		// Update Interface
		if ( wxwinquan!=NULL   ) { wxwinquan->Clean3D(false);		}
		// Model Regeneration
		_mar->_experiment->RegenerateSignal();
		// Refresh Interface
		if ( wxwinquan!=NULL   ) { wxwinquan->RefreshAxis();	}
*/
	}

	


    
	if (!_mar->saveParameters( ))
		return false;


	return true;
	
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::SetBakEdit(){
	_bak_edtThresholdIsoContours_String = edtThresholdIsoContours->GetValue(); 
	_bak_edtFlexionCoef_String			= edtFlexionCoef->GetValue(); 
	_bak_edtTensionCoef_String			= edtTensionCoef->GetValue(); 
	_bak_edtMaskSize_String				= edtMaskSize->GetValue(); 
	_bak_edtDiscreetStep_String			= edtDiscreetStep->GetValue(); 
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::OnOk( wxCommandEvent& WXUNUSED( event ) )
{
    if (Apply( )) {
		EndModal( wxID_OK );
	} else {
		wxMessageDialog(this,_T("Error : Bad Parameters"),_T("Error"),wxOK|wxICON_ERROR).ShowModal();
	}
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::OnCancel( wxCommandEvent& WXUNUSED( event ) )
{
    EndModal( wxID_CANCEL );
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::OnReset( wxCommandEvent& WXUNUSED( event ) )
{
    Reset( );
	
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::OnDefault( wxCommandEvent& WXUNUSED( event ) )
{
	_mar->_parameters->reset();
    Reset( );
	
}
// ----------------------------------------------------------------------------
void wxMaracasParametersDialog::OnApply( wxCommandEvent& WXUNUSED( event ) )
{
    if (!Apply( ))
	{
		wxMessageDialog(this,_T("Error : Bad Parameters"),_T("Error"),wxOK|wxICON_ERROR).ShowModal();
	}
	
}
// ----------------------------------------------------------------------------
// PS -> void wxMaracasParametersDialog::OnBrowseWorkDir( wxCommandEvent& WXUNUSED( event ) )
// PS -> {
// PS -> //    wxString dirHome = edtWorkDir->GetValue( );
// PS -> //    wxDirDialog dialog( this, "Choose a work directory...", ( !dirHome.IsEmpty( ) )? dirHome: wxGetHomeDir( ) );
// PS -> 	
// PS -> //    if( dialog.ShowModal( ) == wxID_OK ) {
// PS -> //        edtWorkDir->SetValue( dialog.GetPath( ) );
// PS ->         //! \todo if dir has change ... should update marGdcm
// PS -> //    }
// PS -> 	
// PS -> }
// ----------------------------------------------------------------------------
// PS -> void wxMaracasParametersDialog::OnBrowseDICOMDir( wxCommandEvent& WXUNUSED( event ) )
// PS -> {
// PS ->     wxString dirHome = edtDICOMDir->GetValue( );
// PS ->     wxDirDialog dialog( this, "Choose a DICOM directory...", ( !dirHome.IsEmpty( ) )? dirHome: wxGetHomeDir( ) );
// PS -> 	
// PS ->     if( dialog.ShowModal( ) == wxID_OK ) 
// PS ->         edtDICOMDir->SetValue( dialog.GetPath( ) );
// PS -> }
// ----------------------------------------------------------------------------
// PS -> void wxMaracasParametersDialog::OnChoose3DColor( wxCommandEvent& WXUNUSED( event ) )
// PS -> {
// PS -> //    wxColourData data;
// PS -> //    data.SetChooseFull( true );
// PS -> //    for( int i = 0; i < 16; i++ )
// PS -> //    {
// PS -> //        wxColour colour( i * 16, i * 16, i * 16 );
// PS -> //        data.SetCustomColour( i, colour );
// PS -> //    } // rof
// PS -> //	
// PS -> //    wxColourDialog dialog ( this, &data );
// PS -> //    dialog.SetTitle( "Choose a 3D background color" );
// PS -> //    if( dialog.ShowModal( ) == wxID_OK )
// PS -> //    {
// PS -> //        wxColourData retData = dialog.GetColourData( );
// PS -> //        wxColour col = retData.GetColour( );
// PS -> //        btn3DBackColor->SetBackgroundColour( col );
// PS -> //    } // fi
// PS -> 	
// PS -> }
// ----------------------------------------------------------------------------
// PS -> void wxMaracasParametersDialog::OnChooseAxisColor( wxCommandEvent& WXUNUSED( event ) )
// PS -> {
// PS -> //    wxColourData data;
// PS -> //    data.SetChooseFull( true );
// PS -> //    for( int i = 0; i < 16; i++ )
// PS -> //   {
// PS -> //        wxColour colour( i * 16, i * 16, i * 16 );
// PS -> //        data.SetCustomColour( i, colour );
// PS -> //    } // rof
// PS -> 	
// PS -> //    wxColourDialog dialog ( this, &data );
// PS -> //    dialog.SetTitle( "Choose an axis color" );
// PS -> //    if( dialog.ShowModal( ) == wxID_OK )
// PS -> //    {
// PS -> //		wxColourData retData = dialog.GetColourData( );
// PS -> //		wxColour col = retData.GetColour( );
// PS -> //		btnAxisColor->SetBackgroundColour( col );
// PS -> //    } // fi
// PS -> }

// EOF - wxGeneralParametersDialog.cxx
