/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasParametersDialog.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __WX__GENERAL__PARAMETERS__DIALOG__
#define __WX__GENERAL__PARAMETERS__DIALOG__

#include <wx/wx.h>
#include <wx/dialog.h>
#include <wx/colordlg.h>
#include <wx/dirdlg.h>

#include <kernel/marInterface.h>
//XRC generated file:
#include "widgets/wxParametersDialog.h"

/**
 *  \brief Dialog class to select parameters
 */
class wxMaracasParametersDialog : public wxParametersDialog
{
public:

    wxMaracasParametersDialog( wxWindow* parent, marInterface* mar );

    void Reset( );
    bool Apply( );

    void OnOk( wxCommandEvent& event );
    void OnCancel( wxCommandEvent& event );
	void OnDefault( wxCommandEvent& event );
    void OnReset( wxCommandEvent& event );
    void OnApply( wxCommandEvent& event );


// PS ->     void OnBrowseWorkDir( wxCommandEvent& event );
// PS ->     void OnBrowseDICOMDir( wxCommandEvent& event );

// PS ->     void OnChoose3DColor( wxCommandEvent& event );
// PS ->     void OnChooseAxisColor( wxCommandEvent& event );

private:
    DECLARE_EVENT_TABLE( );
    marInterface*	_mar;
	wxString		_bak_edtThresholdIsoContours_String;
 	wxString		_bak_edtFlexionCoef_String;
	wxString		_bak_edtTensionCoef_String;
	wxString		_bak_edtMaskSize_String;
	wxString		_bak_edtDiscreetStep_String;
	wxWindow*		_parent;

	void SetBakEdit();

};

#endif // __WX__GENERAL__PARAMETERS__DIALOG__
