/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasProcessingCT.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasProcessingCT.h"


wxMaracasProcessingCT::wxMaracasProcessingCT( wxWindow* parent, marInterfaceCT *mar )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
  // Create the main frame window
  _processingCTWidget = new wxProcessingCTWidget( this, mar );
  wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
  szTop->Add( _processingCTWidget, 1  , wxALL|wxGROW , 0 );
//  szTop->Fit( this );
//  szTop->SetSizeHints( this );
  this->SetSizer( szTop );
  this->SetAutoLayout( true );
  this->Layout();
}
//----------------------------------------------------------------------------
wxMaracasProcessingCT::~wxMaracasProcessingCT( )
{
  // Nothing
}
//----------------------------------------------------------------------------
void wxMaracasProcessingCT::ConfigureVTK( marImageData *marimagedata, int x, int y, int z )
{
  _processingCTWidget->ConfigureVTK(marimagedata,  x,  y,  z );
}
//----------------------------------------------------------------------------
void wxMaracasProcessingCT::SetThreshold(int min,int max)
{
	_processingCTWidget->SetThreshold(min,max);
}
//----------------------------------------------------------------------------
void wxMaracasProcessingCT::GetThreshold(int *min,int *max)
{
	_processingCTWidget->GetThreshold(min,max);
}
//----------------------------------------------------------------------------
void wxMaracasProcessingCT::Refresh()
{
	_processingCTWidget->Refresh();
}
//----------------------------------------------------------------------------


// EOF - wxMaracasProcessingCT.cxx




