/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasQuantification.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracasFrame.h"
#include "wxMaracasQuantification.h"


wxMaracasQuantification::wxMaracasQuantification( wxWindow* parent,
                                                  marInterface* mar, wxWindowID id )
                                                 : wxPanel( parent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

  _mar = mar;

  // Create the main frame window
  _3DQuantif = new wxQuantificationWidget( this, -1 );
  wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
  szTop->Add( _3DQuantif, 1  , wxEXPAND |  wxALL , 0 );
  this->SetAutoLayout( true );
  this->SetSizer( szTop );
  szTop->Fit( this );
  szTop->SetSizeHints( this );
}
//----------------------------------------------------------------------------
wxMaracasQuantification::~wxMaracasQuantification( )
{
}
//----------------------------------------------------------------------------
void wxMaracasQuantification::LoadData( ){
  _3DQuantif->ShowMARACASData( _mar );
}
//----------------------------------------------------------------------------
void wxMaracasQuantification::Do_Quant( ){
  // _3DQuantif->Do_Quant( );
}
//----------------------------------------------------------------------------
void wxMaracasQuantification::SetSlider_Isovalue_Opacity(int isovalue,int opacity){
	_3DQuantif->SetSlider_Isovalue_Opacity(isovalue,opacity);
}
//----------------------------------------------------------------------------
void wxMaracasQuantification::RegenerateAll(bool all){
	if (_3DQuantif!=NULL){
		_3DQuantif->Clean3D(true);
		if (all==true){
			_mar->_experiment->RegenerateAxis();
		} else {
			_mar->_experiment->RecalculateAxis();
		}
		_3DQuantif->AddAxisActors();	
		_3DQuantif->ResetAxis();	
		_3DQuantif->RefreshAxis();	
	}
}
//----------------------------------------------------------------------------
void wxMaracasQuantification::CleanContours(){
	if (_3DQuantif!=NULL){
		_3DQuantif->Clean3D(false);
		_mar->_experiment->ClearContours();
		_3DQuantif->ResetAxis();	
		_3DQuantif->RefreshAxis();	
	}
} 	
//----------------------------------------------------------------------------
void wxMaracasQuantification::RegenerateSignal(){
	if (_3DQuantif!=NULL){
		_3DQuantif->Clean3D(false);
		_mar->_experiment->RegenerateSignal();
		_3DQuantif->ResetAxis();	
		_3DQuantif->RefreshAxis();	
	}
}
//----------------------------------------------------------------------------

// EOF - wxMaracasQuantification.cxx




