/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_ManualContour_Panel.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include <wx/splitter.h>
#include "widgets/pPlotter/mBarRange.h"
#include "wxMaracas_ManualContour_Panel.h"


BEGIN_EVENT_TABLE( wxMaracas_ManualContour_Panel, wxPanel )
	EVT_MENU( 12121, wxMaracas_ManualContour_Panel::OnRefreshView )
END_EVENT_TABLE( );


wxMaracas_ManualContour_Panel::wxMaracas_ManualContour_Panel( wxWindow* parent  )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
  // Create the main frame window

  wxWindow *wxwindow = CreateViewerPanel(this);
  wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
  szTop->Add( wxwindow, 1  , wxEXPAND |  wxALL , 0 );
  szTop->Fit( this );
  szTop->SetSizeHints( this );
  this->SetAutoLayout( true );
  this->SetSizer( szTop );
  this->Layout();
}
//----------------------------------------------------------------------------
wxMaracas_ManualContour_Panel::~wxMaracas_ManualContour_Panel( )
{
  // Nothing
}
//----------------------------------------------------------------------------
void wxMaracas_ManualContour_Panel::ConfigureVTK( marImageData *marimagedata )
{
	vtkMPRBaseData  *vtkmprbasedata  = new vtkMPRBaseData();
	vtkmprbasedata->SetMarImageData(marimagedata);
	vtkmprbasedata->SetX(5);
	vtkmprbasedata->SetY(5);
	vtkmprbasedata->SetZ(5);
//	_vtkplane2Dview->SetVtkBaseData( vtkmprbasedata );
//	_vtkplane2Dview->Configure();
}

//----------------------------------------------------------------------------
void wxMaracas_ManualContour_Panel::OnRefreshView( wxCommandEvent & event)
{
	_vtkplane2Dview->Refresh();
	_vtkplane2Dview->RefreshView();
}

//----------------------------------------------------------------------------

void wxMaracas_ManualContour_Panel::OnActualChange(wxCommandEvent& event)
{
//	wxMessageDialog(this, _T("EED: OnActualChange")).ShowModal();
}


//----------------------------------------------------------------------------
wxWindow* wxMaracas_ManualContour_Panel::CreateViewerPanel(wxWindow* parent)
{
	wxPanel *panel =  new wxPanel(parent,-1);
/*
	// Panel Up Bar
	wxPanel *panelUpBar = new wxPanel(panel,-1);

		int Tmin=0,Tmax=34;
		mBarRange *time_barrange = new mBarRange(panelUpBar,400,10);
		time_barrange -> setVisibleLabels(true);
		time_barrange -> setRepresentedValues (Tmin,Tmax);
		time_barrange -> setDeviceBlitStart (0,0);
		time_barrange -> SetActual((Tmin+Tmax)/2);
		time_barrange -> setActiveStateTo(true);
		time_barrange -> SetInRangeProperty(false);
		Connect(time_barrange->GetId(),wxEVT_TSBAR_ACTUAL  , (wxObjectEventFunction) &wxMaracas_ManualContour_Panel::OnActualChange,NULL,this);

	wxBoxSizer *sizerUpBar= new wxBoxSizer(wxHORIZONTAL);
	wxPanel *tmpPanel = new wxPanel(panel,-1, wxDefaultPosition , wxSize(50,50) );
	sizerUpBar->Add( tmpPanel);
	sizerUpBar->Add( time_barrange	, 1, wxEXPAND, 10 );
	sizerUpBar->SetSizeHints( panelUpBar );   // set size hints to honour minimum size
	panelUpBar->SetSizer(sizerUpBar);
	panelUpBar->SetAutoLayout(true);
	panelUpBar->Layout(); 


// Down
	// Panel Down Bar
	wxPanel *panelDownBar = new wxPanel(panel,-1);

		//z bar
		int Zmin = 0 , Zmax = 34;
		mBarRange *z_barrange = new mBarRange(panelDownBar,50,400);
		z_barrange -> SetBackgroundColour( wxColour(100,100,0) );
		z_barrange -> SetOrientation(false);
		z_barrange -> setVisibleLabels(true);
		z_barrange -> setRepresentedValues (Zmin,Zmax);
	//	z_barrange -> SetActual((min+max)/2);
		z_barrange -> setDeviceBlitStart (0,0);
		z_barrange -> setActiveStateTo(true);
		z_barrange -> SetInRangeProperty(false);
		Connect(z_barrange->GetId(),wxEVT_TSBAR_ACTUAL  , (wxObjectEventFunction) &wxMaracas_ManualContour_Panel::OnActualChange,NULL,this);


	wxFlexGridSizer *sizerDownBar	= new wxFlexGridSizer(5);
	sizerDownBar->AddGrowableCol(2);
	sizerDownBar->AddGrowableRow(0);

	//tmp slider
	wxSlider *tmpSlider				= new wxSlider(panelDownBar,-1,0,0,100,wxDefaultPosition,wxSize(50,50),wxSL_VERTICAL);
	sizerDownBar->Add( tmpSlider	, 1	, wxEXPAND|wxALIGN_BOTTOM , 10 );

	sizerDownBar->Add( z_barrange	, 1	, wxEXPAND| wxALIGN_BOTTOM, 10 );

	sizerDownBar->Add( CreateSplitePanel(panelDownBar)	, 1 , wxGROW , 10 );
	sizerDownBar->SetSizeHints( panelDownBar );   // set size hints to honour minimum size
	panelDownBar->SetSizer(sizerDownBar);
	panelDownBar->SetAutoLayout(true);
	panelDownBar->Layout(); 

	wxBoxSizer *sizer= new wxBoxSizer(wxVERTICAL);
	sizer->Add( panelUpBar		, 0 , wxEXPAND , 10);
	sizer->Add( panelDownBar	, 1 , wxEXPAND, 10 );

	sizer->SetSizeHints( panel );   // set size hints to honour minimum size
	panel->SetSizer(sizer);
	panel->SetAutoLayout(true);
	panel->Layout(); 
*/
	return panel;
}

//----------------------------------------------------------------------------
wxWindow* wxMaracas_ManualContour_Panel::CreateSplitePanel(wxWindow *parent)
{
	// Spliter
	wxSplitterWindow *splitter	= new wxSplitterWindow(parent,-1);

	// Plane Widget
	_vtkplane2Dview				= new vtkPlane2DView( splitter );
	_vtkplane2Dview->SetImgSize( 350 );
	wxWindow *pA = _vtkplane2Dview->GetWxVTKRenderWindowInteractor ();

	wxPanel *pB = new wxPanel(splitter,-1);
	pA->SetBackgroundColour( wxColour(255,0,0) );
	pB->SetBackgroundColour( wxColour(0,0,255) );
	splitter->SplitVertically( pA , pB );
	return splitter;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------





// EOF - wxMaracas_ManualContour_Panel.cxx
