/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_ManualTree_MPRDlg.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "wxMaracas_ManualTree_MPRDlg.h"
#include <wx/splitter.h>


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

wxMaracas_ManualTree_MPRDlg::wxMaracas_ManualTree_MPRDlg( wxWindow* parent, marImageData* marimagedata,double voxelSize)
 : wxDialog( parent, -1,_T("Manual Axis"),wxDefaultPosition,wxDefaultSize,wxCAPTION|wxRESIZE_BORDER  | wxMAXIMIZE_BOX )
{	
//	SetSize(700,700);
	Maximize(true);
	_parent=parent;
	wxSplitterWindow *splitPanel = new wxSplitterWindow(this ,-1);
	_manualTreeMPR = new wxMaracas_ManualTree_MPR(splitPanel,marimagedata,voxelSize);
	wxPanel *panel = new wxPanel (splitPanel, -1);

	wxButton *btnAccept = new wxButton (panel, wxID_OK, _T("Accept"));
	wxButton *btnCancel = new wxButton (panel, wxID_CANCEL, _T("Cancel"));

	wxBoxSizer* sizerH1 = new wxBoxSizer( wxHORIZONTAL );
	sizerH1->Add(btnAccept , 1, wxALL|wxEXPAND, 0);
	sizerH1->Add(btnCancel , 1, wxALL|wxEXPAND, 0);
	panel->SetAutoLayout(true);
	panel->SetSizer(sizerH1);
	Layout();
//EEDxx2.4
//	FitInside();


	splitPanel->SplitHorizontally(_manualTreeMPR,panel );
	splitPanel->SetMinimumPaneSize(50);

	wxBoxSizer* sizer = new wxBoxSizer( wxVERTICAL );
	sizer->Add(splitPanel , 1, wxALL|wxEXPAND, 0);
	SetAutoLayout(true);
	SetSizer(sizer);
	Layout();
//EEDxx2.4
//	FitInside();
}

//----------------------------------------------------------------------------

wxMaracas_ManualTree_MPRDlg::~wxMaracas_ManualTree_MPRDlg()
{
}

//----------------------------------------------------------------------------

void wxMaracas_ManualTree_MPRDlg::ConfigureVTK()
{
	wxBusyCursor wait;
	_manualTreeMPR->ConfigureVTK();
}

//----------------------------------------------------------------------------

void wxMaracas_ManualTree_MPRDlg::SetMarAxis( marAxis *maraxis  )
{
	_maraxis=maraxis;
}

//----------------------------------------------------------------------------
bool wxMaracas_ManualTree_MPRDlg::ExportPoints()
{
	bool ok=false;
	double t,x,y,z;
	manualContourModel *manualcontourmodel = _manualTreeMPR->GetManualContourModel();

	double spc[3];
	_manualTreeMPR->GetVtkMPRBaseData()->GetImageData()->GetSpacing(spc);

	int sizeLstPoints = manualcontourmodel->GetSizeLstPoints(); 

	if ( sizeLstPoints>=2 ){ 
		manualcontourmodel->UpdateSpline();
		int i,max=200;
//JSTG 25-02-08 ---------------------------------------------------
		//double delta = ((double)sizeLstPoints-1) / (double)max;
		for (i=0;i<max;i++)
		{	
			//t=delta*(double)i;
			//manualcontourmodel->GetSplinePoint(t,x,y,z);
			manualcontourmodel->GetSpline_i_Point(i,&x,&y,&z);
//-----------------------------------------------------------------
			x=x*spc[0];
			y=y*spc[1];
			z=z*spc[2];
			_maraxis->AddPointToList(x, y, z,100);		
		}
		ok=true;
	}
	return ok;
}



// EOF - wxMaracas_ManualTree_MPRDlg.cxx




