/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracas_SegmentationFM3D.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:14:56 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/


#include <wx/splitter.h>
#include "wxMaracas_SegmentationFM3D.h"


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
wxMaracas_SegmentationFM3D::wxMaracas_SegmentationFM3D( wxWindow* parent, marImageData* marimagedata,double voxelSize )
: wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{

  // Create the main frame window
	_MPR = new wxSegmentationFM3DWidget( this, marimagedata , voxelSize);
	wxBoxSizer* szTop = new wxBoxSizer( wxVERTICAL );
	szTop->Add( _MPR, 1  , wxEXPAND |  wxALL , 0 );
	this->SetAutoLayout( true );
	this->SetSizer( szTop );
	szTop->Fit( this );
	szTop->SetSizeHints( this );
//EEDxx2.4
//	FitInside();

}
//----------------------------------------------------------------------------
wxMaracas_SegmentationFM3D::~wxMaracas_SegmentationFM3D( )
{
//EEDxx2.4 DELETE
//	delete _MPR;
  // Nothing
}
//----------------------------------------------------------------------------
void wxMaracas_SegmentationFM3D::ConfigureVTK( )
{
  _MPR->ConfigureVTK();
}
//----------------------------------------------------------------------------
vtkMPRBaseData  *wxMaracas_SegmentationFM3D::GetVtkMPRBaseData()
{
	return _MPR->GetVtkMPRBaseData();
}

//----------------------------------------------------------------------------
vtkPlane2DView *wxMaracas_SegmentationFM3D::GetVtkPlane2DView()
{
	return _MPR->GetVtkPlane2DView();
}




// EOF 




