/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*---------------------------------------------------------------
   INCLUDES WXWIDGETS
-----------------------------------------------------------------*/
#include "wx/wxprec.h"
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
/*-----------------------------------------------------------------*/

//disable warnings on 255 char debug symbols
#pragma warning (disable : 4786) 


#include "osgi/framework/Bundle.h"
#include "osgi/framework/BundleContext.h"

#include "MaracasTools.h"
#include "interface/wxWindows/widgets/wxManualSegmentation_MPRWidget.h"

#include <iostream>

using namespace std;

/*----------------------------------------------------
Instance. Singleton pattern in this class
-----------------------------------------------------*/
MaracasTools* MaracasTools::INSTANCE = NULL;


/*----------------------------------------------------
GetInstance method
-----------------------------------------------------*/
MaracasTools* MaracasTools::GetInstance(){
	if (INSTANCE == NULL){
		INSTANCE = new MaracasTools();
	}
	return INSTANCE;
}


/*----------------------------------------------------
Constructor
-----------------------------------------------------*/
MaracasTools::MaracasTools(){
	framework = new Framework();
	if(( logger=freopen("ToolsLogger.txt","w",stdout)) == NULL){
		exit(-1);
	}
	std::cout << "Framework Creado "<<std::endl;
	
	toolsFrame = NULL;
	optionsFrame = NULL;
	currentToolPanel = NULL;
}


/*----------------------------------------------------
It must load all the bundles this class is going to use.
-----------------------------------------------------*/
wxFrame* MaracasTools::GetToolbox(wxWindow* parent){
	
	
	//1. Install ToolboxBundle
	//-----------------------------------------------------------------------------------------------
	std::cout << "Cargando Toolbox..." <<std::endl;
	Bundle* bundle = framework->InstallBundle("ToolboxBundle");
	bundle->Start(); 
	//-----------------------------------------------------------------------------------------------

	
	
	
	//2. Query the OSGi framework for the IToolbox service (should be delivered in 1).
	//-----------------------------------------------------------------------------------------------
	BundleContext* ctx = bundle->getBundleContext();
	const string interfaceName = "ToolboxService";
	ServiceReference* ref = ctx->GetServiceReference(interfaceName); 
	if (ref != NULL){
		toolbox = (IToolbox*)ctx->GetService(ref);
		toolbox->SetClient(this); // ACTIVATE THE CALLBACK: WHEN TOOLBOX NEES TO KNOW ANY PARAMETER
								  // THE METHOD GetParameter ON THE CLIENT WILL BE CALLED.
	}
	//-----------------------------------------------------------------------------------------------


	

	//3.Install tools
	//TODO: Replace for discovery of bundles in the maracas' execute directory.
	//-----------------------------------------------------------------------------------------------
	Bundle* bundle1 = framework->InstallBundle("SimpleSegBundle");
	bundle1->Start();

	Bundle* bundle2 = framework->InstallBundle("FM3DBundle");
	bundle2->Start();
	//-----------------------------------------------------------------------------------------------


	//4.Build Floating bar
	//-----------------------------------------------------------------------------------------------
	//FRAME
	wxSize _size = wxSize(30,600);
	toolsFrame = new wxFrame(parent,-1,_T("Maracas Tools"),wxDefaultPosition,_size);//,wxCAPTION | wxMINIMIZE | wxSTAY_ON_TOP | wxFRAME_TOOL_WINDOW | wxRESIZE_BORDER | wxCLOSE_BOX);

	//SIZER
	wxBoxSizer *sizer= new wxBoxSizer(wxVERTICAL);
	
	//BUTTONS
	wxButton* button = NULL;


	int count = toolbox->GetToolsCount();
	
		
	//Storyboard
	//4.1. MaracasTools asks IToolbox about registered ITools..
	//-----------------------------------------------------------------------------------------------
	int i=0;
//	char* name = "";
	char name[255]="";
	for(i=0;i<count;i++){

		string stName = toolbox->GetToolName(i);
		sprintf(name,"%s",stName.c_str());
	
		button = new wxButton(toolsFrame,-1,_T(name));
		SetIndexForButton(button->GetId());

	    sizer->Add( button,1, wxALL, 0);
		toolsFrame->Connect(button->GetId(),wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxToolsHandler::OnSelectToolEvent,NULL,this);
	}
	//-----------------------------------------------------------------------------------------------
	
	

	//CONFIG FRAME
	//-----------------------------------------------------------------------------------------------
	toolsFrame->SetSize(25,600);
	toolsFrame->SetAutoLayout(true);
	toolsFrame->SetSizer(sizer);
	toolsFrame->Layout();
	

	//BUILD TOOLS OPTIONS FRAME
	//-----------------------------------------------------------------------------------------------
	wxSize optSize = wxSize(300,300);
	optionsFrame = new wxFrame(toolsFrame,-1,_T("Tool"),wxDefaultPosition,optSize);//,wxCAPTION | wxMINIMIZE |  wxSTAY_ON_TOP  | wxRESIZE_BORDER | wxCLOSE_BOX );
	

	return toolsFrame;
	
}





void MaracasTools::OnSelectToolEvent(wxCommandEvent& event){


	int id = event.GetId();

	int idx = GetIndexForButton(id);
	
	const string name = toolbox->GetToolName(idx);

	wxSizer* sizer = optionsFrame->GetSizer();

	if (sizer == NULL){
		sizer= new wxBoxSizer(wxBOTH);
		optionsFrame->SetSizer(sizer);
	}


	if (currentToolPanel != NULL){
		//bool t = sizer->Remove(currentToolPanel);
		currentToolPanel->Destroy();
	}
	

	currentToolPanel = toolbox->GetToolPanel(optionsFrame,idx);
	sizer->Add(currentToolPanel, 1, wxEXPAND, 0);
	sizer->Layout();
	
	optionsFrame->SetTitle(_T(name.c_str()));
	optionsFrame->Layout();
	optionsFrame->Show();


}



int MaracasTools::GetIndexForButton(int _wxbuttonid){
	
	for(int i=0; i < ids.size(); i++){
		if (ids[i] == _wxbuttonid){
			return i;
		}
	}
	return -1; //NOT FOUND.
}


void MaracasTools::SetIndexForButton(int _wxbuttonid){
	ids.push_back(_wxbuttonid);
	int size = ids.size();
}


IParameter* MaracasTools::GetParameter(string name){
	
	

	IParameter* parameter = NULL;

	if (name == string("MARACAS_MPR_XYZ")){

		double* xyz = new double[3];
		xyz[0] =widget->GetVtkMPRBaseData()->GetX();
		xyz[1] =widget->GetVtkMPRBaseData()->GetY();
		xyz[2] =widget->GetVtkMPRBaseData()->GetZ();
		parameter = new IParameter(xyz);
	}

	else if (name == string("MARACAS_MPR_RENDERER")){
		vtkRenderer* renderer = widget->GetRenderer();
		parameter = new IParameter(renderer);
	}

	else if (name == string("MARACAS_MPR_IMAGE")){
		vtkImageData* image = widget->GetVtkMPRBaseData()->GetImageData();
		parameter = new IParameter(image);
	}

	else if (name == string("MARACAS_MPR_REFRESH")){
		widget->Refresh();
	}

	 
	return parameter;
}
