/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*-----------------------------------------------------
  DEFINE
*------------------------------------------------------*/
#if !defined(__TOOLS_MARACAS_TOOLS_H__)
#define __TOOLS_MARACAS_TOOLS_H__

//#include "interface/wxWindows/widgets/wxManualSegmentation_MPRWidget.h"
/*-----------------------------------------------------
  INCLUDE
*------------------------------------------------------*/
#include <vector>

#include "wx/frame.h"
#include "wx/window.h"
#include "wx/event.h"

#include "osgi/impl/Framework.h"
#include "maracas/toolbox/IToolbox.h"
#include "maracas/toolbox/IClient.h"
#include "maracas/toolbox/IParameter.h"




class wxManualSegmentation_MPRWidget;




//using namespace std;
/*-----------------------------------------------------
Class MaracasTools

  Doc goes here.
	  
*------------------------------------------------------*/

class wxToolsHandler: public wxEvtHandler{
public:
	virtual void OnSelectToolEvent(wxCommandEvent& event)=0;
};



class MaracasTools: public wxToolsHandler, public IClient{
	public:
		static MaracasTools* GetInstance();
		wxFrame* GetToolbox(wxWindow* parent);
		IParameter* GetParameter(std::string name);
		void SetMPRWidget(wxManualSegmentation_MPRWidget* pWidget){widget = pWidget;}
		void OnSelectToolEvent(wxCommandEvent& event);
		
	protected:
		MaracasTools();
	private:
		static MaracasTools* INSTANCE;
		
		wxManualSegmentation_MPRWidget* widget;
		
		std::vector<int> ids;
		
		FILE* logger;
    	
		Framework* framework;
		IToolbox* toolbox;
		
		wxFrame* toolsFrame;
		wxFrame* optionsFrame;
		wxPanel* currentToolPanel;
		
		

		
		int GetIndexForButton(int _wxbuttonid);
		void SetIndexForButton(int _wxbuttonid);
};



#endif //__TOOLS_MARACAS_TOOLS_H__



