/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include "ContourView.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

ContourView::ContourView()
{
	_wxvtkbaseview = NULL;
}

// ----------------------------------------------------------------------------
ContourView::~ContourView()
{
	DeleteContours();
}

// ----------------------------------------------------------------------------
void ContourView::DeleteContours()
{
	DeleteVtkObjects();
	contour_mapped.clear();
	contour_actor.clear();
}

// ----------------------------------------------------------------------------
void ContourView::SetWxVtkBaseView(wxVtkBaseView *wxvtkbaseview)
{
	_wxvtkbaseview = wxvtkbaseview;
}

// ----------------------------------------------------------------------------
void ContourView::Refresh()
{
	_wxvtkbaseview->GetRenWin()->Render();
}

// ----------------------------------------------------------------------------
void ContourView::CreateNewContour(vtkPolyData *contour, int type)
{
	contour_mapped.push_back(vtkPolyDataMapper::New());
	contour_mapped.back()->ScalarVisibilityOff( );


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	contour_mapped.back()->ImmediateModeRenderingOn();
	contour_mapped.back()->SetInput(contour);
#else
	contour_mapped.back()->SetInputData(contour);
#endif


	contour_actor.push_back(vtkActor::New());
	contour_actor.back()->SetMapper(contour_mapped.back());
	contour_actor.back()->GetProperty()->BackfaceCullingOff();
	
	switch (type)
	{
	case ContourView::BLUE :	contour_actor.back()->GetProperty()->SetDiffuseColor(0, 0, 1);
								break;
	case ContourView::MAGENTA : contour_actor.back()->GetProperty()->SetDiffuseColor(1, 0, 1);
								break;
	case ContourView::GREEN :	contour_actor.back()->GetProperty()->SetDiffuseColor(0, 1, 0);
								break;
	case ContourView::YELLOW :	contour_actor.back()->GetProperty()->SetDiffuseColor(0, 1, 1);
								break;
	default:					contour_actor.back()->GetProperty()->SetDiffuseColor(0, 0, 1);

	}
	contour_actor.back()->GetProperty()->SetLineWidth(2);
	contour_actor.back()->ApplyProperties();

	_wxvtkbaseview->GetRenderer()->AddActor(contour_actor.back());
	_wxvtkbaseview->GetRenWin()->Render();
}

// ----------------------------------------------------------------------------
void ContourView::DeleteVtkObjects()
{
	int i,size=contour_mapped.size();
	for (i=0;i<size; i++){
		if ( contour_mapped[i]	!= NULL	)	{ 
			contour_mapped[i]  -> Delete(); 
		}
		if ( contour_actor[i]	!= NULL	)	{ 
			_wxvtkbaseview->GetRenderer()->RemoveActor(contour_actor[i]);
			contour_actor[i]  -> Delete(); 
		}
		contour_actor[i] = NULL;
		contour_mapped[i] = NULL;
	}
}
