/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "InteractorStyleMaracas.h"
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

InteractorStyleMaracas::InteractorStyleMaracas()
{
	_active						= true;
	_vtkInteractorStyleBaseView	= NULL;
}
//---------------------------------------------------------------------------
InteractorStyleMaracas::~InteractorStyleMaracas()
{
}

// ----------------------------------------------------------------------------
InteractorStyleMaracas * InteractorStyleMaracas::Clone()  // virtual 
{
	InteractorStyleMaracas * clone = new InteractorStyleMaracas();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void InteractorStyleMaracas::CopyAttributesTo( InteractorStyleMaracas * cloneObject)
{
	// Fathers object
	//<FATHERCLASS>::CopyAttributesTo(cloneObject);

	cloneObject->SetActive( this->GetActive() );
}


//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnChar() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMouseMove() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnLeftButtonDown() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnLeftButtonUp() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool  InteractorStyleMaracas::OnLeftDClick() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMiddleButtonDown()  //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMiddleButtonUp() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMiddleDClick() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnRightButtonDown() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnRightButtonUp() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnRightDClick() //virtual
{
	return true;
}

//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMouseWheelForward() //virtual
{
	return true;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::OnMouseWheelBackward()  //virtual
{
	return true;
}
//---------------------------------------------------------------------------
void InteractorStyleMaracas::SetVtkInteractorStyleBaseView(vtkInteractorStyleBaseView* vtkInteractorStyleBaseView)
{
	_vtkInteractorStyleBaseView = vtkInteractorStyleBaseView;
}
//---------------------------------------------------------------------------
void InteractorStyleMaracas::RemoveVtkInteractorStyleBaseView()
{
	_vtkInteractorStyleBaseView = NULL;
}
//---------------------------------------------------------------------------
void InteractorStyleMaracas::SetActive(bool active)
{
	_active = active;
}
//---------------------------------------------------------------------------
bool InteractorStyleMaracas::GetActive()
{
	return _active;
}


