/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include "LineView.h"




// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
LineView::LineView()
{
	_wxvtkbaseview = NULL;
}

// ----------------------------------------------------------------------------
LineView::~LineView()
{
	DeleteLines();
}

// ----------------------------------------------------------------------------
void LineView::DeleteLines() 
{
	DeleteVtkObjects();
	contour_mapped.clear();
	contour_actor.clear();
}

// ----------------------------------------------------------------------------
void LineView::SetWxVtkBaseView(wxVtkBaseView *wxvtkbaseview)
{
	_wxvtkbaseview = wxvtkbaseview;
}

// ----------------------------------------------------------------------------
void LineView::Refresh()
{
	_wxvtkbaseview->GetRenWin()->Render();
}

// ----------------------------------------------------------------------------
void LineView::CreateNewLine(double x1, double y1, double z1, double x2, double y2, double z2)
{

	vtkPoints*  pointsLine = vtkPoints::New();
	vtkPolyLine* aLine = vtkPolyLine::New();
	vtkUnstructuredGrid* aLineGrid = vtkUnstructuredGrid::New();
	contour_mapped.push_back(vtkDataSetMapper::New());
	contour_actor.push_back(vtkActor::New());

    pointsLine->SetNumberOfPoints(2);
	pointsLine->InsertPoint(0,x1,y1,z1);
	pointsLine->InsertPoint(1,x2,y2,z2);

	(aLine->GetPointIds())->SetNumberOfIds(2);
	(aLine->GetPointIds())->SetId(0,0);
	(aLine->GetPointIds())->SetId(1,1);

	aLineGrid->Allocate(1,1);
	aLineGrid->InsertNextCell(aLine->GetCellType(),aLine->GetPointIds());
	aLineGrid->SetPoints(pointsLine);
	
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	contour_mapped.back()->SetInput(aLineGrid);
	contour_mapped.back()->ImmediateModeRenderingOn();
#else
	contour_mapped.back()->SetInputData(aLineGrid);
#endif


	contour_actor.back()->SetMapper(contour_mapped.back());
	contour_actor.back()->GetProperty()->BackfaceCullingOn();
	contour_actor.back()->GetProperty()->SetDiffuseColor(0, 0, 1);
	contour_actor.back()->ApplyProperties();

	_wxvtkbaseview->GetRenderer()->AddActor(contour_actor.back());
	_wxvtkbaseview->GetRenWin()->Render();

}

// ----------------------------------------------------------------------------
void LineView::DeleteVtkObjects()
{
	int i,size=contour_mapped.size();
	for (i=0;i<size; i++){
		if ( contour_mapped[i]	!= NULL	)	{ 
			contour_mapped[i]  -> Delete(); 
		}
		if ( contour_actor[i]	!= NULL	)	{ 
			_wxvtkbaseview->GetRenderer()->RemoveActor(contour_actor[i]);
			contour_actor[i]  -> Delete(); 
		}
		contour_actor[i] = NULL;
		contour_mapped[i] = NULL;
	}
}

