
#include <cmath>

#include "ModelShowNPoints.h"


//----------------------------------------------------------------------
ModelShowNPoints::ModelShowNPoints()
{
	firsttime=true;
}
//----------------------------------------------------------------------

ModelShowNPoints::~ModelShowNPoints()
{
}

//------------------------------------------------------------------------
void ModelShowNPoints::SetRadio(double radio)
{
	mradio =  radio;
}

//------------------------------------------------------------------------
double ModelShowNPoints::GetRadio()
{
	return mradio;
}

//------------------------------------------------------------------------
std::vector<int> ModelShowNPoints::GetLstPointsX()
{
	return lstPointsX;
}

//------------------------------------------------------------------------
std::vector<int> ModelShowNPoints::GetLstPointsY()
{
	return lstPointsY;
}

//------------------------------------------------------------------------
std::vector<int> ModelShowNPoints::GetLstPointsZ()
{
	return lstPointsZ;
}

//------------------------------------------------------------------------
std::vector<std::string> ModelShowNPoints::GetLstLabels()
{
//	return lstLabels;
	std::vector<std::string> tmpLst;
	int i	,size=lstLabels.size();
	std::string tmp;
	for (i=0; i<size; i++) 
	{
		tmp=lstLabels[i];
		if (tmp.empty()==true) 
		{
			tmp="VOID";	
		}
		tmpLst.push_back( tmp );
	} // for i
	return tmpLst;
}

//------------------------------------------------------------------------
void ModelShowNPoints::SetReferencePoint(std::vector<int> ppoint)
{
	mReferencePoint = ppoint;
}

//------------------------------------------------------------------------
std::vector<int> ModelShowNPoints::GetReferencePoint()
{
	return mReferencePoint;
}

//------------------------------------------------------------------------
void ModelShowNPoints::SetImage(vtkImageData *image)
{
	this->mimage=image;
}


//------------------------------------------------------------------------
std::string ModelShowNPoints::CleanSpaces(std::string ss)
{
	int i;
	while( (i=ss.find(32))>=0 )
	{
		ss.replace(i,1,"_");
	}
	return ss;
}

//------------------------------------------------------------------------
void ModelShowNPoints::GetIdPoint(int id, int *x, int *y, int *z)
{
	*x=lstPointsX[id];
	*y=lstPointsY[id];
	*z=lstPointsZ[id];
}

//------------------------------------------------------------------------
std::string ModelShowNPoints::GetIdLabel(int id)
{
	return lstLabels[id];
}

//------------------------------------------------------------------------
vtkImageData *ModelShowNPoints::GetImage()
{
	return mimage;
}

//------------------------------------------------------------------------
void ModelShowNPoints::AddPoint(int x, int y, int z, std::string label)
{
	lstPointsX.push_back( x );
	lstPointsY.push_back( y );
	lstPointsZ.push_back( z );
	std::string strLabel = CleanSpaces(  label );
	lstLabels.push_back( strLabel );
}

//------------------------------------------------------------------------
double ModelShowNPoints::DistanceSQ(double dX0, double dY0, double dZ0, double dX1, double dY1, double dZ1)//CFT
{
//    return sqrt((dX1 - dX0)*(dX1 - dX0) + (dY1 - dY0)*(dY1 - dY0) + (dZ1 - dZ0)*(dZ1 - dZ0));
        return (dX1 - dX0)*(dX1 - dX0) + (dY1 - dY0)*(dY1 - dY0) + (dZ1 - dZ0)*(dZ1 - dZ0);
}

//------------------------------------------------------------------------
int ModelShowNPoints::InsertPoint(int x, int y, int z, std::string label)
{
	if(lstPointsX.size()>1)
	{
		std::vector<int> dTotal;
		int pos = 1;
		double a,b,c,res;
        int i,j;
		//Calcule distance for each pair of points
		for(i = 0; i<(int)lstPointsX.size()-1 ; i++)
		{
				a = DistanceSQ(x, y, z, lstPointsX[i], lstPointsY[i], lstPointsZ[i]);
				b = DistanceSQ(x, y, z, lstPointsX[i+1], lstPointsY[i+1], lstPointsZ[i+1]);
				res = a + b;		
				dTotal.push_back (res);		
		}
		//Gets the smallest distance 
		int smallTMP = dTotal[0];
	 	for (j = 0; j < (int) dTotal.size(); j++)
		{
			  if(dTotal[j]<smallTMP)
			  {
					  smallTMP=dTotal[j];
						pos = j+1;
			  }
		}
		
        
        //  *************** Open contour case Start *******************
        if (lstPointsX.size()==2)
        {
            double cx,cy,cz,r1,r2;
            i  = 0;
            cx = (lstPointsX[i]+lstPointsX[i+1]) / 2;
            cy = (lstPointsY[i]+lstPointsY[i+1]) / 2;
            cz = (lstPointsZ[i]+lstPointsZ[i+1]) / 2;
            r1 = DistanceSQ( cx,cy,cz,x,y,z );
            r2 = DistanceSQ( cx,cy,cz,lstPointsX[i], lstPointsY[i], lstPointsZ[i] );
            if (r1<r2) // inside circle
            {
                pos=1;
            } else {   // outside circle
                if (a<b)  // befor first point
                {
                    pos=0;
                } else {  // after second point
                pos=2;
                }
            }
        }
        if (lstPointsX.size()>2)
        {
            double r3;
            if ( pos==1)  // first point of the list
            {
                i = 0;
                a = DistanceSQ(x, y, z, lstPointsX[i], lstPointsY[i], lstPointsZ[i]);
                b = DistanceSQ(x, y, z, lstPointsX[i+1], lstPointsY[i+1], lstPointsZ[i+1]);
                r3 = DistanceSQ( lstPointsX[i], lstPointsY[i], lstPointsZ[i],lstPointsX[i+1], lstPointsY[i+1], lstPointsZ[i+1] );
                if (b>r3) // outside circle
                {
                    pos = 0;
                }
            }
            if (pos==lstPointsX.size()-1 )  // last point of the list
            {
                i = lstPointsX.size()-2;
                r3 = DistanceSQ( lstPointsX[i], lstPointsY[i], lstPointsZ[i],lstPointsX[i+1], lstPointsY[i+1], lstPointsZ[i+1] );
                if (a>r3) // outside circle
                {
                    pos = pos+1;
                }
            }
        }
        //  *************** Open contour case End *******************

        
		std::vector<int>::iterator it;
		//Insert the point in the list of points
		it = lstPointsX.begin();
		lstPointsX.insert( it+pos, x );
		it = lstPointsY.begin();
		lstPointsY.insert( it+pos, y );
		it = lstPointsZ.begin();
		lstPointsZ.insert( it+pos, z );

		std::string strLabel = CleanSpaces(  label );
	
		std::vector<std::string>::iterator itS;
		itS = lstLabels.begin();
		//Insert Label in list of labels
		lstLabels.insert( itS+pos, strLabel );
		return pos;
	} else {
		return -1;
	}// if size lst X

}


//------------------------------------------------------------------------
void ModelShowNPoints::SavePoints_(FILE* ff)
{
        std::string tmpLabel;
        int i , size = (int) (lstPointsX.size());
        fprintf(ff,"NumberOfPoints %d \n",size);
        fprintf(ff," X\tY\tZ\tvalue\tLabel\n");
        int x, y, z;
        double value;
        for (i=0; i<size; i++)
        {
            x       = lstPointsX[i];
            y       = lstPointsY[i];
            z       = lstPointsZ[i];
            value   = mimage->GetScalarComponentAsDouble(x,y,z,0);
            if (lstLabels[i]!="")
            {
                tmpLabel=lstLabels[i];
            } else{
                tmpLabel="<_VOID_>";
            }
            fprintf(ff,"%d\t%d\t%d\t%f\t%s\n", x , y , z , value  , tmpLabel.c_str());
        } // for
}

//------------------------------------------------------------------------
void ModelShowNPoints::SavePoints(std::string filename)
{
	FILE* ff = fopen( filename.c_str() , "w+" );
    if (ff!=NULL)
    {
        SavePoints_(ff);
		fclose(ff);
	} else {   // else ff
		printf("ModelShowNPoints::SavePoints  ...Error... creating file\n");
	} //ff
}

//------------------------------------------------------------------------
int ModelShowNPoints::ReadPoints_(FILE* ff)
{
    int i,size;
    char chartmp[256];
    fscanf(ff," %s %d",chartmp,&size);
    fscanf(ff," %s %s %s %s %s",chartmp, chartmp,chartmp,chartmp,chartmp );

    float value;
    int x,y,z;
    for (i=0; i<size; i++)
    {
        fscanf(ff,"%d%d%d%f%s",&x,&y,&z,&value,chartmp );  // x,y,z,value,label
        if (strcmp(chartmp,"<_VOID_>")==0) { strcpy(chartmp,""); }
        AddPoint(x,y,z, chartmp );
    }
    return size;
}

//------------------------------------------------------------------------
int ModelShowNPoints::ReadPoints(std::string filename)
{
    int size=0;
	FILE *ff = fopen( filename.c_str() , "r+" );
	if (ff!=NULL)
	{
        size = ReadPoints_(ff);
		fclose(ff);
	} else {   // else ff
		printf("ModelShowNPoints::LoadPoints  ...Error... reading file");
	} //ff
	return size;
}

//------------------------------------------------------------------------
int ModelShowNPoints::GetNearestPoint()
{
	int id=-1;
	int i, size=(int)(lstPointsX.size());
	double radioMin=10000000;	
	for ( i=0  ; i<size; i++ )
	{
		double rx =  mReferencePoint[0] - lstPointsX [i];
		double ry =  mReferencePoint[1] - lstPointsY [i];
		double rz =  mReferencePoint[2] - lstPointsZ [i];
		double radio = rx*rx + ry*ry + rz*rz;
		if ( radio <= radioMin)
		{
			radioMin=radio;
			id=i;
		}	// if
	} // for			
	return id;
}

//------------------------------------------------------------------------
int ModelShowNPoints::GetLstPointsSize()
{
	return lstPointsX.size();
}

//------------------------------------------------------------------------
void ModelShowNPoints::SetPointId_mReferencePoint(int id)
{
	lstPointsX[id] = mReferencePoint[0];
	lstPointsY[id] = mReferencePoint[1];
	lstPointsZ[id] = mReferencePoint[2];		
}


//------------------------------------------------------------------------	
int ModelShowNPoints::IdInsidePoint()
{
	int id=-1;
	int i, size=(int)( lstPointsX.size() );
    double spc[3];
    double radio2=(mradio+1)*(mradio+1);
	if(mimage ==NULL)
	{
		printf("WidgetShowNPoints::IdInsidePoint  image not set\n");
		return -1;
	}else{
		mimage->GetSpacing(spc);
		for ( i=0  ; i<size; i++ )
		{
			double rx =  spc[0]*(mReferencePoint[0] - lstPointsX [i]);
			double ry =  spc[1]*(mReferencePoint[1] - lstPointsY [i]);
			double rz =  spc[2]*(mReferencePoint[2] - lstPointsZ [i]);
			if ( rx*rx + ry*ry + rz*rz <= radio2)
			{
				id=i;
			}	// if
		} // for
		return id;
	} // if
}

//------------------------------------------------------------------------	
int ModelShowNPoints::RenamePoint(std::string label)
{
	int id=IdInsidePoint();
	if (id>=0)
	{
		std::string strLabel = CleanSpaces( label );
		lstLabels[id] = strLabel;
	}
	return id;
}

//----------------------------------------------------------------------
void ModelShowNPoints::ErasePoint(int id)
{
	lstPointsX.erase( lstPointsX.begin()+id );
	lstPointsY.erase( lstPointsY.begin()+id );
	lstPointsZ.erase( lstPointsZ.begin()+id );
	lstLabels.erase( lstLabels.begin()+id );
}

//----------------------------------------------------------------------
void ModelShowNPoints::SetFirstTime(bool value)
{
	firsttime=value;
}

//----------------------------------------------------------------------
bool ModelShowNPoints::GetFirstTime()
{
	return firsttime;
}


