
#ifndef __ModelShowNPoints_h_INCLUDED__
#define __ModelShowNPoints_h_INCLUDED__


#include <vector>
#include <string>
#include <vtkImageData.h>


class ModelShowNPoints
  {
	public:
	  ModelShowNPoints();
	  ~ModelShowNPoints(); 
	  std::vector<int> 			GetLstPointsX();
	  std::vector<int> 			GetLstPointsY();
	  std::vector<int> 			GetLstPointsZ();
	  void 						GetIdPoint(int id, int *x, int *y, int *z);
	  std::string 				GetIdLabel(int id);
	  std::vector<std::string> 	GetLstLabels();
	  void 						AddPoint(int x, int y, int z, std::string label);
	  double 					DistanceSQ(double dX0, double dY0, double dZ0, double dX1, double dY1, double dZ1);
	  int 						InsertPoint(int x, int y, int z, std::string label);
	  void						SavePoints(std::string filename);
      void                      SavePoints_(FILE* ff);

      int						ReadPoints(std::string filename);
      int                       ReadPoints_(FILE* ff);
	  int 						GetNearestPoint();

	  int 						GetLstPointsSize();
	  void 						SetPointId_mReferencePoint(int id);
	  int 						IdInsidePoint();

	  void 						SetReferencePoint(std::vector<int> ppoint);
	  std::vector<int> 			GetReferencePoint();
	  void 						SetImage(vtkImageData *image);
	  std::string 				CleanSpaces(std::string ss);
	  vtkImageData*				GetImage();
	  void 						SetRadio(double radio);
	  double					GetRadio();
	  int 						RenamePoint(std::string label);
	  void 						ErasePoint(int id);
	  void 						SetFirstTime(bool value);
	  bool						GetFirstTime();

	private:
	  std::vector<int>              lstPointsX;
	  std::vector<int>              lstPointsY;
	  std::vector<int>              lstPointsZ;
	  std::vector<std::string>      lstLabels;
	  std::vector<int>      		mReferencePoint;
	  double                		mradio;
	  vtkImageData          		*mimage;
	  bool 							firsttime;

  };


#endif // __ModelShowNPoints_h_INCLUDED__


