/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "OpenImageDialog.h"
#include "creaWx.h"

#if defined(__GNUC__)
// GCC compiler
// dlopen, dlsym, etc.
  #include <dlfcn.h>
#endif

typedef vtkImageData* (*GETIMAGEDATADIALOG)();

namespace creaMaracasVisuKernel{
	OpenImageDialog::OpenImageDialog(bool usegimmick)
	{
		img = NULL;		
		_filename = "";
		bool gimmickfound = false;

		if(usegimmick){
		#ifdef WIN32
			HINSTANCE gimmickhandle;
			gimmickhandle = LoadLibrary(TEXT("creaImageIO.dll"));
			std::cout<<"imagehandle "<<gimmickhandle<<std::endl;
			if(gimmickhandle!=NULL){

				GETIMAGEDATADIALOG getImageDataDialog;

				getImageDataDialog = (GETIMAGEDATADIALOG)GetProcAddress(gimmickhandle, "getImageDataDialog");

				std::cout<<"imagedatadialog "<<getImageDataDialog<<std::endl;

				if(getImageDataDialog!=NULL){
					img = getImageDataDialog();
					gimmickfound = true;
				}
				if(!FreeLibrary(gimmickhandle)){
					std::cout<<"Error while releasing the handle creaImageIO2.dll"<<std::endl;
				}
			}
		#else
			void * gimmickhandle;	
			GETIMAGEDATADIALOG getImageDataDialog;
			char * erreur;
			int closingerror;
			gimmickhandle = dlopen ("libcreaImageIO.so", RTLD_LAZY);			
			if (! gimmickhandle) {
				erreur = dlerror ();
				std::cout<<erreur<<"imagehandle "<<gimmickhandle<<std::endl;		    
			}else{
				getImageDataDialog = (GETIMAGEDATADIALOG) dlsym (gimmickhandle, "getImageDataDialog");
				if(!getImageDataDialog)
				{
					erreur = dlerror ();
					std::cout<<erreur<<"getImageDataDialog "<<getImageDataDialog<<std::endl;			
				}else{
					img = (*getImageDataDialog)();
					gimmickfound = true;
					
				} // if getImageDataDialog
				/*dlclose returns 0 on success, non-zero on error*/
				closingerror = dlclose(gimmickhandle);
				if(closingerror!=0){
					std::cout<<closingerror<<"error closing handle  "<<gimmickhandle<<std::endl;  
				}else{
					std::cout<<"handle released..."<<std::endl;  
				} // if closingerror
			} // if gimmickhandle

		#endif
		}
		
		if(!gimmickfound || !usegimmick){
			//int i, j, k, extint[6];
			//double spacing[3];
			//unsigned short* ptr1, *ptr2;
			wxFileDialog* FD =
			  new wxFileDialog( 0, _T("Read Image"),wxEmptyString,wxEmptyString, _T("*.mhd"));

			if (FD->ShowModal()==wxID_OK)
			{
				std::string  path= crea::wx2std(FD->GetPath());
				vtkMetaImageReader* reader =  vtkMetaImageReader::New();
				reader->SetFileName(path.c_str());
				reader->Update();
				_filename = path;
				img = vtkImageData::New();
				img->DeepCopy(reader->GetOutput());
				//reader->GetOutput()->Delete();
				reader->Delete();
				/*std::cout<<"image reference count "<<img->GetReferenceCount()<<std::endl;
				reader->GetOutput()->GetSpacing(spacing);
				img->SetSpacing(spacing);
				reader->GetOutput()->GetExtent(extint);
				img->SetExtent(extint);
				img->SetScalarType(reader->GetOutput()->GetScalarType());				
				img->AllocateScalars();
				std::cout<<"image reference count "<<img->GetReferenceCount()<<std::endl;
				for (i=extint[0];i <= extint[1];i++){
					for (j=extint[2];j<=extint[3];j++){
						for (k=extint[4];k<=extint[5];k++){
							
								ptr1=(unsigned short*) reader->GetOutput()->GetScalarPointer(i,j,k); 
								ptr2=(unsigned short*)img->GetScalarPointer(i,j,k);
								*ptr2 = *ptr1;
						}
					}
				}*/
				
				/*std::cout<<"image reference count "<<img->GetReferenceCount()<<std::endl;*/
			}
			//delete FD;
		}
	}

	//-------------------------------------------------------------------
	OpenImageDialog::~OpenImageDialog()
	{
		img = NULL;
	}

	vtkImageData* OpenImageDialog::getImageData(){		
		return img;
	}
	std::string OpenImageDialog::getFilename(){
		return _filename;
	}
}
