/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "PlaneDirectionViewer.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/


PlaneDirectionViewer* PlaneDirectionViewer::instance=NULL;

PlaneDirectionViewer::PlaneDirectionViewer(wxWindow* parent,int radio, double colour[3], int opacity)
:wxPanel(parent)
{
	manager = new PlaneDirectionManager(radio, colour, opacity);	
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	this->SetSizer(sizer);
	this->SetAutoLayout(true);
}

PlaneDirectionViewer* PlaneDirectionViewer::getInstance(wxWindow* parent,int radio, double colour[3], int opacity){
	if(instance==NULL){
		instance = new PlaneDirectionViewer(parent,radio,colour,opacity);
	}
	return instance;
}

PlaneDirectionViewer* PlaneDirectionViewer::getInstance(){
	return instance;
}

PlaneDirectionViewer::~PlaneDirectionViewer(){
	delete manager;
}

void PlaneDirectionViewer::SetRenderer(vtkRenderer* render){
	manager->SetRenderer(render);
}

void PlaneDirectionViewer::SetVectors( std::vector<double> lstPointsx, std::vector<double> lstPointsy, std::vector<double> lstPointsz){
	manager->SetVectors(lstPointsx,lstPointsy,lstPointsz);
}

// EED 2022-08-04	throw
//void PlaneDirectionViewer::UpdateDirections() throw (std::exception)
void PlaneDirectionViewer::UpdateDirections() 
{
	manager->UpdateDirections();
	std::vector<PlaneDirectionManagerData*> vectdata = manager->GetPlanesData();
	int i;
	for(i = 0; i < (int)viewdata.size();i++){
		this->GetSizer()->Remove(i);
		viewdata[i]->Destroy();
	}
	viewdata.clear();	
	for(i = 0; i < (int)vectdata.size(); i++){
		PlaneDirectionViewerPanel* planedirview = new PlaneDirectionViewerPanel(this, vectdata[i],i);
		viewdata.push_back(planedirview);
		this->GetSizer()->Add(planedirview,1);
	}
	this->Layout();	
}

void PlaneDirectionViewer::addRemoveActor(int index, bool addremove){
	manager->addRemoveActor(index, addremove);
}

void PlaneDirectionViewer::changeColor(int index,double r,double g,double b){
	manager->changeColor(index, r,g,b);
}

void PlaneDirectionViewer::WriteInformation(std::string  filename, double* spc){
    manager->WriteInformation(filename,spc);
}

void PlaneDirectionViewer::SetArrowSize(int arrowsize){
	manager->SetArrowSize(arrowsize);
}

