/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "PlaneDirectionViewerPanel.h"
#include "PlaneDirectionViewer.h"

#include "Color.xpm"
#include <wx/colordlg.h>

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

PlaneDirectionViewerPanel::PlaneDirectionViewerPanel(wxWindow* parent, PlaneDirectionManagerData* data, int index)
:wxPanel(parent,-1, wxDefaultPosition, wxDefaultSize,wxBORDER_SUNKEN){	
    wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	_index = index;
	this->SetSizer(sizer);
	
	checkbox = new  wxCheckBox(this,-1,wxString(_T("Show Actor")));
	checkbox->SetValue(true);
	Connect(checkbox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&PlaneDirectionViewerPanel::onCheckBoxChange);

	wxBitmap bitmap(Color_xpm);
	_colorchoose = new wxBitmapButton(this, -1, bitmap,wxDefaultPosition,wxSize(30,30));	
	Connect(_colorchoose->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&PlaneDirectionViewerPanel::onColorChange);			
	

	double* p0 = data->getPoint0();
	double* p1 = data->getPoint1();
	double* p2 = data->getPoint2();
	double* dir = data->GetDirection();

	wxString label(_T("[x, y, z]"));	
	wxString tempstr0;
	tempstr0.Printf(_T("P1 [%f, %f, %f"),p0[0],p0[1],p0[2]);
	wxString tempstr1;
	tempstr1.Printf(_T("P2 [%f, %f, %f"),p1[0],p1[1],p1[2]);
	wxString tempstr2;
	tempstr2.Printf(_T("P3 [%f, %f, %f"),p2[0],p2[1],p2[2]);
	wxString tempstr3;
	tempstr3.Printf(_T("Direction [%f, %f, %f"),dir[0],dir[1],dir[2]);

	wxStaticText* textlabel = new wxStaticText(this, -1, label);
	wxStaticText* textp0 = new wxStaticText(this, -1, tempstr0);
	wxStaticText* textp1 = new wxStaticText(this, -1, tempstr1);
	wxStaticText* textp2 = new wxStaticText(this, -1, tempstr2);
	wxStaticText* textp3 = new wxStaticText(this, -1, tempstr3);
	

	sizer->Add(checkbox,1);
	sizer->Add(_colorchoose,1);
	sizer->Add(textlabel,1);
	sizer->Add(textp0,1);
	sizer->Add(textp1,1);
	sizer->Add(textp2,1);
	sizer->Add(textp3,1);

	this->SetAutoLayout(true);
	this->Layout();

}

void PlaneDirectionViewerPanel::onCheckBoxChange(wxCommandEvent& event){	
	PlaneDirectionViewer::getInstance()->addRemoveActor(this->_index, checkbox->GetValue());
}

void PlaneDirectionViewerPanel::onColorChange(wxCommandEvent& event){
	
	wxColourDialog* colourdiag = new wxColourDialog(this);
	if(colourdiag->ShowModal()==wxID_OK){
		wxColour colour = colourdiag->GetColourData().GetColour();
		_colorchoose->SetBackgroundColour(colour);

		double r = (double)(colour.Red())/255.0;
		double g = (double)(colour.Green())/255.0;
		double b = (double)(colour.Blue())/255.0;
		
		PlaneDirectionViewer::getInstance()->changeColor(this->_index,r,g,b);
	}
	delete colourdiag;

}

PlaneDirectionViewerPanel::~PlaneDirectionViewerPanel(){

}

