/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "PointView.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

PointView::PointView()
{
	_wxvtkbaseview = NULL;
}

// ----------------------------------------------------------------------------
PointView::~PointView()
{
	DeletePoints();
}

// ----------------------------------------------------------------------------
void PointView::DeletePoints()
{
	DeleteVtkObjects();
	point_mapped.clear();
	point_actor.clear();
}

// ----------------------------------------------------------------------------
void PointView::SetWxVtkBaseView(wxVtkBaseView *wxvtkbaseview)
{
	_wxvtkbaseview = wxvtkbaseview;
}

// ----------------------------------------------------------------------------
void PointView::Refresh()
{
	_wxvtkbaseview->GetRenWin()->Render();
}

// ----------------------------------------------------------------------------
void PointView::CreateNewPoint(double x, double y, int type)
{
	vtkSphereSource* aSphere =vtkSphereSource::New();
	aSphere->SetRadius(1);
	aSphere->SetCenter(x,y,0);
	
	point_mapped.push_back(vtkPolyDataMapper::New());
//	point_mapped.back()->ImmediateModeRenderingOn();
	//point_mapped.back()->ScalarVisibilityOff( );


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	point_mapped.back()->SetInput(aSphere->GetOutput());
#else
	point_mapped.back()->SetInputData(aSphere->GetOutput());
#endif

	point_actor.push_back(vtkActor::New());
	point_actor.back()->SetMapper(point_mapped.back());
//	point_actor.back()->GetProperty()->BackfaceCullingOff();

	switch (type)
	{
	case PointView::BLUE :		point_actor.back()->GetProperty()->SetColor(0, 0, 1);
								break;
	case PointView::MAGENTA :	point_actor.back()->GetProperty()->SetColor(1, 0, 1);
								break;
	case PointView::GREEN :		point_actor.back()->GetProperty()->SetColor(0, 1, 0);
								break;
	case PointView::YELLOW :	point_actor.back()->GetProperty()->SetColor(0, 1, 1);
								break;
	default:					point_actor.back()->GetProperty()->SetColor(0, 0, 1);

	}

	//point_actor.back()->GetProperty()->SetColor(0, 1, 0);
	
	point_actor.back()->ApplyProperties();

	_wxvtkbaseview->GetRenderer()->AddActor(point_actor.back());
	_wxvtkbaseview->GetRenWin()->Render();
}

// ----------------------------------------------------------------------------
void PointView::DeleteVtkObjects()
{
	int i,size=point_mapped.size();
	for (i=0;i<size; i++){
		if ( point_mapped[i]	!= NULL	)	{ 
			point_mapped[i]  -> Delete(); 
		}
		if ( point_actor[i]	!= NULL	)	{ 
			_wxvtkbaseview->GetRenderer()->RemoveActor(point_actor[i]);
			point_actor[i]  -> Delete(); 
		}
		point_actor[i] = NULL;
		point_mapped[i] = NULL;
	}
}
