/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file 
 *  \author Eduardo Davila and Claire Mouton.
 *  \brief Class bbtk::ThresholdImageView. 
 *  \date September 2012
 */

#include "ColorLayerImageViewManager.h"



//=========================================================================
//=========================================================================
//=========================================================================
//=========================================================================
ColorLayerImageViewManager::ColorLayerImageViewManager( )
{
	_colorLayerImageViewLst.push_back(NULL);  // 0
	_colorLayerImageViewLst.push_back(NULL);  // 1
	_colorLayerImageViewLst.push_back(NULL);  // 2
}

//=========================================================================
ColorLayerImageViewManager::~ColorLayerImageViewManager()
{
}
//=========================================================================



//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetwxVtkBaseView(int id, wxVtkBaseView *baseview)
{
  if (baseview!=NULL)
  {	
	int size =_colorLayerImageViewLst.size();
	if (   (id>=0) && (id<=size) )
	{
	    if (_colorLayerImageViewLst[id]==NULL)
	    {
			_colorLayerImageViewLst[id] = new ColorLayerImageView();
	    }
	   	_colorLayerImageViewLst[id]->SetwxVtkBaseView(baseview);
	
	} // if id
  } // baseview
}


wxVtkBaseView* 	ColorLayerImageViewManager::GetwxVtkBaseView(int id)
{
	return _colorLayerImageViewLst[id]->GetwxVtkBaseView();
}


//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetX2(int x2)  
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetX2( x2 );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetY2(int y2)  
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetY2( y2 );
	} // if 
  } // for 

}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetZ2(int z2)  
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetZ2( z2 );
	} // if 
  } // for 

}



//----------------------------------------------------------------------------
int ColorLayerImageViewManager::GetX()
{
  int result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetX();
	} // if 
  } // for 
  return result;
}

//----------------------------------------------------------------------------
int ColorLayerImageViewManager::GetY()
{
  int result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetY();
	} // if 
  } // for 
  return result;
}



//----------------------------------------------------------------------------
int ColorLayerImageViewManager::GetZ() // virtual 
{
  int result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetZ();
	} // if 
  } // for 
  return result;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetBaseColors(std::vector<double> & base_color)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetBaseColors( base_color );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetBaseTransparence(std::vector<double> & base_transparence)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetBaseTransparence( base_transparence );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetRangeForColorBar(std::vector<double> &range)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetRangeForColorBar( range );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetColorBarPosition(std::vector<int> &colorbarposition)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetColorBarPosition( colorbarposition );
	} // if 
  } // for 
}




//----------------------------------------------------------------------------
double ColorLayerImageViewManager::GetBaseColors(unsigned int index)
{
  double result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetBaseColors( index );
	} // if 
  } // for 
  return result;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetGreyLevelBoundaries(std::vector<double> & grey_level_boundary)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetGreyLevelBoundaries( grey_level_boundary );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
double ColorLayerImageViewManager::GetGreyLevelBoundaries(unsigned int index)
{  
  double result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetGreyLevelBoundaries( index );
	} // if 
  } // for 
  return result;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetPlainOrGradientColor(bool color_type)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetPlainOrGradientColor( color_type );
	} // if 
  } // for 
} 

//----------------------------------------------------------------------------
int ColorLayerImageViewManager::GetBaseColorNb()
{
  int result;
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   result = _colorLayerImageViewLst[i]->GetBaseColorNb();
	} // if 
  } // for 
  return result;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::Refresh()
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->Refresh();
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::onThreshold()
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->onThreshold();
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::onThresholdChange()
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->onThresholdChange();
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::onThresholdRemove()
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->onThresholdRemove();
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::onThresholdInterpolation(bool interpolation)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->onThresholdInterpolation( interpolation );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetSliceFixDynamic( bool fixdyn )
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetSliceFixDynamic( fixdyn );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::onThresholdChangeOpacity( int opacity)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->onThresholdChangeOpacity( opacity );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetImage(  vtkImageData* img  )
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetImage( img );
	} // if 
  } // for 
}

//----------------------------------------------------------------------------
vtkImageData* ColorLayerImageViewManager::GetImageChangeInformation(int id)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   return _colorLayerImageViewLst[id]->GetImage( );
	} // if 
	return NULL;
}

//----------------------------------------------------------------------------
vtkLookupTable*	ColorLayerImageViewManager::GetLookupTable(int id)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   return _colorLayerImageViewLst[id]->GetThresholdTable( );
	} // if 
	return NULL;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::GetDimensionBase(int id,int *dim)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   _colorLayerImageViewLst[id]->GetDimensionBase( dim );
	} // if 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::GetSpcBase(int id,double *spc)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   _colorLayerImageViewLst[id]->GetSpcBase( spc );
	} // if 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::GetDimensionOriginalLayer(int id,int *dim)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   _colorLayerImageViewLst[id]->GetDimensionOriginalLayer( dim );
	} // if 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::GetSpcOriginalLayer(int id,double *spc)
{
	if (_colorLayerImageViewLst[id]!=NULL)
	{
  	   _colorLayerImageViewLst[id]->GetSpcOriginalLayer( spc );
	} // if 
}

//----------------------------------------------------------------------------
void ColorLayerImageViewManager::SetNewSpacingLayer(double *spc)
{
  int i, size=_colorLayerImageViewLst.size();
  for (i=0;i<size;i++)
  {
	if (_colorLayerImageViewLst[i]!=NULL)
	{
  	   _colorLayerImageViewLst[i]->SetNewSpacingLayer( spc );
	} // if 
  } // for 
}


// EOF

