/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file 
 *  \brief Class ThresholdImageView . 
 */

/**
 * \class ThresholdImageView
 * \brief 
 */
 
#ifndef __ColorLayerImageViewManager_h__
#define __ColorLayerImageViewManager_h__

#include "ColorLayerImageView.h"


class  ColorLayerImageViewManager 
  {
  public: 
	  ColorLayerImageViewManager( );
	  ~ColorLayerImageViewManager( );
	  void 				SetX2(int x2);
	  void 				SetY2(int y2);
	  void 				SetZ2(int z2);
	  virtual int 		GetX();
	  virtual int 		GetY();
	  virtual int 		GetZ();
	  void 				SetwxVtkBaseView(int id, wxVtkBaseView *baseview);
	  wxVtkBaseView* 	GetwxVtkBaseView(int id);
	  void 				SetBaseColors(std::vector<double> & base_color);
	  double 			GetBaseColors(unsigned int index);
	  void 				SetGreyLevelBoundaries(std::vector<double> & grey_level_boundary);
	  void 				SetBaseTransparence(std::vector<double> & base_transparence);
	  void 				SetRangeForColorBar(std::vector<double> & range);
	  void 				SetColorBarPosition(std::vector<int> & colorbarposition);
	  double 			GetGreyLevelBoundaries(unsigned int index);
	  void 				SetPlainOrGradientColor(bool color_type);
	  int 				GetBaseColorNb();
	  void 				Refresh();
	  void 				onThreshold();
	  void 				onThresholdRemove();
	  void 				onThresholdChange();
	  void 				onThresholdInterpolation( bool interpolation );
	  void 				SetSliceFixDynamic( bool fixdin );
	  void 				onThresholdChangeOpacity( int opacity );
	  void 				SetImage( vtkImageData* img );
	  vtkImageData* 	GetImageChangeInformation(int id);

	  void 				GetDimensionBase			(int id,int 	*dim);
	  void 				GetSpcBase					(int id,double 	*spc);
	  void 				GetDimensionOriginalLayer	(int id,int 	*dim);
	  void 				GetSpcOriginalLayer			(int id,double 	*spc);
	  void 				SetNewSpacingLayer			(double *spc);

	  vtkLookupTable*	GetLookupTable(int id);
  private:

	std::vector< ColorLayerImageView* > 	_colorLayerImageViewLst;

  protected:
 };

#endif

