/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/**
 *  \file
 *  \brief ClassThresholdImageViewPanel .
 */


#include "ColorLayerImageViewPanel.h"
#include "OpenImageDialog.h"
#include <wx/string.h>

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

wxDlgTransformByDimensionBySpacingByPixel::wxDlgTransformByDimensionBySpacingByPixel()
{
}

wxDlgTransformByDimensionBySpacingByPixel::~wxDlgTransformByDimensionBySpacingByPixel()
{
}


void wxDlgTransformByDimensionBySpacingByPixel::GetTransformType(
									wxWindow *parent , 
									double baseSpc[3],
									double layerSpc[3],
									int baseDim[3],
									int layerDim[3],
									wxString message,
									int &typeOfTransformation,
									bool &dlgWxOK)
{
	wxDialog* dial			= new wxDialog (parent,-1,_T("Tools"),wxDefaultPosition, wxSize(500,525),wxRESIZE_BORDER);
	wxSizer* buttonsSizer	= dial->CreateSeparatedButtonSizer(wxOK);
	wxBoxSizer *dialSizer	= new wxBoxSizer(wxVERTICAL);

	wxString lstOptOperation[3];
//	lstOptOperation[0]=_T("By Dimension");
//	lstOptOperation[1]=_T("By Spacing");
//	lstOptOperation[2]=_T("By Pixel");

	lstOptOperation[0]=_T("Adapt spacing of the Layer Image");
	lstOptOperation[1]=_T("Keep the spacing of the Layer Image");
	lstOptOperation[2]=_T("Use the same spacing of the Base Image");

	wxRadioBox * radioOpts = new wxRadioBox(dial, -1, _T("Type of spacing transformation"), wxDefaultPosition, wxSize(250,160), 3 , lstOptOperation,  1, wxRA_SPECIFY_COLS);

	wxString str;
	wxString strBaseSpc(str);
	wxString strLayerSpc;
	wxString strBaseDim;
	wxString strLayerDim;

	strBaseSpc.Printf(wxT("Base spacing: %f %f %f")		, baseSpc[0],baseSpc[1],baseSpc[2] 		);
	strLayerSpc.Printf(wxT("Layer spacing: %f %f %f")	, layerSpc[0],layerSpc[1],layerSpc[2] 	);
	strBaseDim.Printf(wxT("Base dimension: %d %d %d")	, baseDim[0],baseDim[1],baseDim[2] 		);
	strLayerDim.Printf(wxT("Layer dimension: %d %d %d")	, layerDim[0],layerDim[1],layerDim[2] 	);

	dialSizer->Add( new wxStaticText(dial,-1,_T(" ")		) 	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1, strBaseSpc	)	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1, strLayerSpc	) 	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1,_T(" ")		)  	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1, strBaseDim 	) 	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1, strLayerDim 	) 	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1,_T(" ")		)  	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1,message		)  	, 0, wxGROW );
	dialSizer->Add( new wxStaticText(dial,-1,_T(" ")		)  	, 0, wxGROW );
	dialSizer->Add(radioOpts,0,wxGROW);
	dialSizer->Add( new wxStaticText(dial,-1,_T(" ")		)  	, 0, wxGROW );
	dialSizer->Add(buttonsSizer,0,wxGROW);
	dial->SetSizer(dialSizer, true);
	dial->Layout();
	dial->ShowModal();

	typeOfTransformation	= -1;
	dlgWxOK					= false;

printf("EED wxDlgTransformByDimensionBySpacingByPixel::GetTransformType AAA\n");

	if (dial->GetReturnCode() == wxID_OK)
	{
		typeOfTransformation  	= radioOpts->GetSelection() + 1;
printf("EED wxDlgTransformByDimensionBySpacingByPixel::GetTransformType BBB %d\n",typeOfTransformation);
		dlgWxOK					= true;
	}
}


//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------


/**
 ** Begin of the threshold panel
 **/
ColorLayerImageViewPanel::ColorLayerImageViewPanel(wxWindow* parent, int min, int max,int opacity, int type)
//: wxPanel(parent, -1, wxDefaultPosition, wxSize(600,100), wxBORDER_SUNKEN)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
	_spcBase[0] = _spcBase[1] = _spcBase[2] = 0;
	_dimBase[0] = _dimBase[1] = _dimBase[2] = 0;
	_cb_ShowHide				= NULL;
	_sl_SliceImageX				= NULL;
	_sl_SliceImageY				= NULL;
	_sl_SliceImageZ				= NULL;
	_histogram					= NULL;
	_histogramMinMaxLevel		= NULL;
	wxFlexGridSizer * sizer		= NULL;
	_colorLayerImageViewManager	= new ColorLayerImageViewManager();
	if (type==1)
	{
		sizer							= new wxFlexGridSizer(1);
		_btn_ReadImage					= new wxButton(this, wxID_ANY, _T("Read Image") );
		_thresholdGo					= true;
		_cb_ShowHide					= new wxCheckBox(this, wxID_ANY, _T("Show/Hide Layer") );
		_cb_ShowHide->SetValue(_thresholdGo);
		_cb_SliceFixDinamic 			= new wxCheckBox(this, wxID_ANY, _T("Fixed/Dynamic Slice") );
		_cb_SliceFixDinamic->SetValue(true);
		_sl_SliceImageX = new wxSlider(this, wxID_ANY, 0, 1000, 1000, 
											wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
		_sl_SliceImageY = new wxSlider(this, wxID_ANY, 0, 1000, 1000, 
											wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
		_sl_SliceImageZ = new wxSlider(this, wxID_ANY, 0, 1000, 1000, 
											wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
		_sl_SliceImageX->Enable(false);
		_sl_SliceImageY->Enable(false);
		_sl_SliceImageZ->Enable(false);
		_interpolationCheckBox = new wxCheckBox(this, -1, _T("Interpole") );
		_interpolationCheckBox->SetValue(true);
		_opacity = new wxSlider(this, wxID_ANY, opacity, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);

	//	_histogram 					= new Histogram(  this , -1, wxPoint(0,0), wxSize(400,400), /*wxNO_BORDER*/ wxBORDER_DEFAULT ); 
	//	_histogramMinMaxLevel 	= new HistogramMinMaxLevel( (HistogramBase*)_histogram );

		Connect( _btn_ReadImage->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &ColorLayerImageViewPanel::onReadImage );
		Connect( _cb_ShowHide->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED  , (wxObjectEventFunction) &ColorLayerImageViewPanel::onThresholdShow );
		Connect( _interpolationCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &ColorLayerImageViewPanel::onThresholdInterpolation );
		Connect( _opacity->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction) &ColorLayerImageViewPanel::onChangeOpacity );
		Connect( _cb_SliceFixDinamic->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceFixDinamic );

		Connect( _sl_SliceImageX->GetId(), wxEVT_SCROLL_THUMBTRACK	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageX->GetId(), wxEVT_SCROLL_LINEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageX->GetId(), wxEVT_SCROLL_LINEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageX->GetId(), wxEVT_SCROLL_PAGEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageX->GetId(), wxEVT_SCROLL_PAGEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );

		Connect( _sl_SliceImageY->GetId(), wxEVT_SCROLL_THUMBTRACK	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageY->GetId(), wxEVT_SCROLL_LINEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageY->GetId(), wxEVT_SCROLL_LINEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageY->GetId(), wxEVT_SCROLL_PAGEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageY->GetId(), wxEVT_SCROLL_PAGEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );

		Connect( _sl_SliceImageZ->GetId(), wxEVT_SCROLL_THUMBTRACK	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageZ->GetId(), wxEVT_SCROLL_LINEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageZ->GetId(), wxEVT_SCROLL_LINEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageZ->GetId(), wxEVT_SCROLL_PAGEUP		, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );
		Connect( _sl_SliceImageZ->GetId(), wxEVT_SCROLL_PAGEDOWN	, (wxObjectEventFunction) &ColorLayerImageViewPanel::onSliceImage );

		sizer -> Add( new wxStaticText(this,-1,_T("Color Image Layer"))  		, 1, wxGROW );
		sizer -> Add( _btn_ReadImage											, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T(" "))  						, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T("Opacity Level"))  			, 1, wxGROW );
		sizer -> Add( _opacity													, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T(" ")) 	 					, 1, wxGROW );
		sizer -> Add( _cb_ShowHide												, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T(" "))  						, 1, wxGROW );
		sizer -> Add( _interpolationCheckBox									, 1, wxGROW );

		sizer -> Add( new wxStaticText(this,-1,_T(" "))  						, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T("Slice "))  					, 1, wxGROW );
		sizer -> Add( _sl_SliceImageX									 		, 1, wxGROW );
		sizer -> Add( _sl_SliceImageY				 					 		, 1, wxGROW );
		sizer -> Add( _sl_SliceImageZ				 					 		, 1, wxGROW );
		sizer -> Add( _cb_SliceFixDinamic		 					 			, 1, wxGROW );
	//	sizer -> Add( _histogramMinMaxLevel->GetWindow()						, 1, wxGROW );

	} // type==1

	if (type==2)
	{
		sizer							= new wxFlexGridSizer(2);
		_interpolationCheckBox = new wxCheckBox(this, -1, _T("Interpolate") );
		_interpolationCheckBox->SetValue(true);
		_opacity = new wxSlider(this, wxID_ANY, opacity, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
		Connect( _interpolationCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &ColorLayerImageViewPanel::onThresholdInterpolation );
		Connect( _opacity->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction) &ColorLayerImageViewPanel::onChangeOpacity );
//		sizer -> Add( new wxStaticText(this,-1,_T("Opacity Level"))  			, 1, wxEXPAND );
		sizer -> Add( _opacity 					, 1, wxGROW );
		sizer -> Add( _interpolationCheckBox	, 1, wxGROW );
		sizer->AddGrowableCol(0);

	} // type==2

	this->SetSizer( sizer );
//	this->SetAutoLayout( true );
//	this->Layout();
     
	//CM Sets the default fitting mode to Pixel mode.
	_fitting_mode = 3;
	// EO CM  EED
}

//----------------------------------------------------------------------------
ColorLayerImageViewPanel::~ColorLayerImageViewPanel()
{
}

//----------------------------------------------------------------------------
ColorLayerImageViewManager* ColorLayerImageViewPanel::GetColorLayerImageViewManager()
{
   return _colorLayerImageViewManager;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::SetImage(vtkImageData *img)
{
    if (img!=NULL)
    {		
		if (_histogramMinMaxLevel!=NULL) 
		{
			_histogramMinMaxLevel->Configure( img );
		}
        _colorLayerImageViewManager->SetImage( img );
        double 	spcOriginalLayer[3];
        int 	dimensionOriginalLayer[3];
        double 	spcBase[3];
        int 	dimensionBase[3];
        double 	newSpc[3];
		GetColorLayerImageViewManager()->GetSpcOriginalLayer(0,spcOriginalLayer);		
		GetColorLayerImageViewManager()->GetDimensionOriginalLayer(0,dimensionOriginalLayer);		
		GetColorLayerImageViewManager()->GetSpcBase(0,spcBase);		
		GetColorLayerImageViewManager()->GetDimensionBase(0,dimensionBase);		
		if (_sl_SliceImageX!=NULL)
		{
		    _sl_SliceImageX->SetRange( 0 , dimensionOriginalLayer[0] );
		    _sl_SliceImageY->SetRange( 0 , dimensionOriginalLayer[1] );
		    _sl_SliceImageZ->SetRange( 0 , dimensionOriginalLayer[2] );
		}

        if ( 	(spcOriginalLayer[0]!=spcBase[0]) || 
				(spcOriginalLayer[1]!=spcBase[1]) || 
				(spcOriginalLayer[2]!=spcBase[2]) ||
     	        (dimensionOriginalLayer[0]!=dimensionBase[0]) || 
				(dimensionOriginalLayer[1]!=dimensionBase[1]) || 
				(dimensionOriginalLayer[2]!=dimensionBase[2])
            )
        {
 	  		// CM
	  		int typeOfTransformation;	
	  		// In case of the option is set to create a dialog box.
	  		if (_fitting_mode == -1)
	  		{
				bool transformOkDlg;
	    		wxString msg = _T("The image resolution of both images are not compatible. How do you want to tranform it? ");
	    		wxDlgTransformByDimensionBySpacingByPixel dlg;
	    		dlg.GetTransformType(this , spcBase , spcOriginalLayer , dimensionBase ,dimensionOriginalLayer ,msg,typeOfTransformation,transformOkDlg);
	    		// CM Reset the default value (Pixel i.e. 3) if the dialog box returned an inappropriate value.
	    		if (transformOkDlg == false)
				{
	    			typeOfTransformation = 3;
				} 
	   		} else {
	    		typeOfTransformation = _fitting_mode;
	  		} // _fitting_mode -1

	  		//EO CM
            if (typeOfTransformation==1)  // Adapt spacing 
            {
                newSpc[0] = spcBase[0] * dimensionBase[0] / dimensionOriginalLayer[0];
                newSpc[1] = spcBase[1] * dimensionBase[1] / dimensionOriginalLayer[1];
                newSpc[2] = spcBase[2] * dimensionBase[2] / dimensionOriginalLayer[2];
            }

            if (typeOfTransformation==2)  // keep spacing of the Layer Image
            {
                newSpc[0] = spcOriginalLayer[0];
                newSpc[1] = spcOriginalLayer[1];
                newSpc[2] = spcOriginalLayer[2];
            }

            if (typeOfTransformation==3)  // Use the spacing of the Base Image
            {
                newSpc[0] = spcBase[0];
                newSpc[1] = spcBase[1];
                newSpc[2] = spcBase[2];
            }
			GetColorLayerImageViewManager()->SetNewSpacingLayer(newSpc);
        } else {
                newSpc[0] = spcOriginalLayer[0];
                newSpc[1] = spcOriginalLayer[1];
                newSpc[2] = spcOriginalLayer[2];
		} // spc !_spcBase   dim!__dimBase

		GetColorLayerImageViewManager()->SetNewSpacingLayer(newSpc);

    } // _firsttime_mode

	if (_active==true)
	{
	    _colorLayerImageViewManager->onThreshold();
	 	RefreshView();
	} // _ative 	
}

void ColorLayerImageViewPanel::RefreshView()
{
//EED01 	_colorLayerImageView->Refresh();
 	_colorLayerImageViewManager->Refresh();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::SetFittingMode(int fitting_mode)
{
  // CM Sets the fitting mode if an appropriate value is provided.
  if (fitting_mode == -1 || fitting_mode == 1 || fitting_mode == 2 || fitting_mode == 3)
    {
      _fitting_mode = fitting_mode;
    }
  //Otherwise, an exception should be thrown (value 0 is fine, it corresponds to an empty field i.e. the default value is kept).
  else if (fitting_mode != 0)
    std::cout << "CM ERROR!!! The fitting mode provided has an inappropriate value. It should be an int between -1 ; 1 ; 2 ; 3, but its value is :" << fitting_mode << ". The default value will be set instead, i.e. Pixel transformation (3)." <<  std::endl;
  //EO CM
}

//----------------------------------------------------------------------------
int ColorLayerImageViewPanel::GetFittingMode()
{
  return _fitting_mode;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onReadImage(wxCommandEvent& event)
{
// EED ???
//      creaImageIO::WxSimpleDlg w(0,_T("Select your image"),"creaContours_Descriptor.dscp","creatisContours DB");
//      w.ShowModal();
	printf("EED ColorLayerImageViewPanel::onReadImage ....WARNING... Read dlg. all images creaImageIO ... ???\n");

	int 	ext[6];
	double 	spc[6];
	double 	origin[3];
	origin[0]	= 0;
	origin[1]	= 0;
	origin[2]	= 0;

	creaMaracasVisuKernel::OpenImageDialog 	diag 	= creaMaracasVisuKernel::OpenImageDialog();
	vtkImageChangeInformation 				*change = vtkImageChangeInformation::New();
	vtkImageData 							*img 	= diag.getImageData();
	img		-> GetExtent( ext );	
	img		-> GetSpacing( spc );	
	change	-> SetInputData( img );
	change	-> SetOutputSpacing( spc[0] , spc[1] , spc [2] );
	change	-> SetOutputExtentStart(0,0,0);
	change	-> SetOutputOrigin( origin );
	change	-> Modified();    	//important
	change	-> Update();    	//important
	SetImage( change->GetOutput() );
	_colorLayerImageViewManager->onThreshold();
	RefreshView();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onThresholdChange(wxCommandEvent& event)
{
           	if (_thresholdGo)
          	{
             	 _colorLayerImageViewManager->onThresholdChange();
		      	 RefreshView();
              	//std::cout<< "Valor Min: " << minVal << " & Valor Max: " << maxVal  << std::endl;
          } // _thresholdGo
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onThresholdShow(wxCommandEvent& event)
{
        _thresholdGo = _cb_ShowHide->GetValue();
			_active = _thresholdGo;
        if (_thresholdGo)
        {
	            _colorLayerImageViewManager->onThreshold();
        }else{
           	    _colorLayerImageViewManager->onThresholdRemove( );
        }
	     RefreshView();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onThresholdStop()
{
	        if (_thresholdGo)
	        {
	            _colorLayerImageViewManager->onThresholdRemove( );
	            _thresholdGo=false;
	        }
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onThresholdInterpolation(wxCommandEvent& event)
{
	   _colorLayerImageViewManager->onThresholdInterpolation(_interpolationCheckBox->GetValue());
		RefreshView();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onSliceFixDinamic(wxCommandEvent& event)
{
        bool fixdin = _cb_SliceFixDinamic->GetValue();
        _colorLayerImageViewManager->SetSliceFixDynamic( fixdin );
        if (fixdin==false)
        {
            _colorLayerImageViewManager->SetX2( _sl_SliceImageX->GetValue() );
            _colorLayerImageViewManager->SetY2( _sl_SliceImageY->GetValue() );
            _colorLayerImageViewManager->SetZ2( _sl_SliceImageZ->GetValue() );
        }
        _sl_SliceImageX->Enable(!fixdin);
        _sl_SliceImageY->Enable(!fixdin);
        _sl_SliceImageZ->Enable(!fixdin);
        _colorLayerImageViewManager->onThreshold();
	RefreshView();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onSliceImage(wxScrollEvent& event)
{
   _colorLayerImageViewManager->SetX2( _sl_SliceImageX->GetValue() );
   _colorLayerImageViewManager->SetY2( _sl_SliceImageY->GetValue() );
   _colorLayerImageViewManager->SetZ2( _sl_SliceImageZ->GetValue() );
   _colorLayerImageViewManager->onThreshold();
 	RefreshView();
}

//----------------------------------------------------------------------------
int ColorLayerImageViewPanel::GetOpacity()
{
	return _opacity->GetValue();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::ChangeOpacity()
{
	int opacity = _opacity->GetValue();
	_colorLayerImageViewManager->onThresholdChangeOpacity(opacity);
	RefreshView();
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::onChangeOpacity(wxScrollEvent& event)
{
	ChangeOpacity();
//	int opacity = _opacity->GetValue();
//	_colorLayerImageViewManager->onThresholdChangeOpacity(opacity);
//	RefreshView();
}


//----------------------------------------------------------------------------
bool ColorLayerImageViewPanel::IsVisible()
{
	return _thresholdGo;
}

//----------------------------------------------------------------------------
void ColorLayerImageViewPanel::SetActive(bool active)
{
	_active=active;
	if (_cb_ShowHide!=NULL)
	{
		_cb_ShowHide->SetValue( _active );
	}
}


// EOF

