/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/**
 *  \file 
 *  \brief Class bbtk::ThresholdImageView . 
 */

#include "ThresholdImageView.h"
#include <vtkImageReslice.h>
#include <vtkLookupTable.h>
#include <vtkImageData.h>


  //=========================================================================
  //=========================================================================
  //=========================================================================
  //=========================================================================
	ThresholdImageView::ThresholdImageView( )
  {
	  _minValue					=	0;
	  _maxValue					=	1000;
	  _baseColorR				=	1;
	  _baseColorG				=	0;
	  _baseColorB				=	0;
  }

  //=========================================================================
  ThresholdImageView::~ThresholdImageView()
  {
  }
  //=========================================================================



//----------------------------------------------------------------------------
void ThresholdImageView::SetminMaxValue(int min, int max)
{
	_minValue = min;
	_maxValue = max;
}


//----------------------------------------------------------------------------
void ThresholdImageView::ConfigLookupTable()  // virtual
{
	double range[2];
	
	GetImage()->GetScalarRange(range);
	if (range[1]==0)
	{
		range[1]=255;
	}
	
	int minTot = floor (range[0]);
	int maxTot = ceil (range[1]);
	
	int minVal = floor (_minValue);
	int maxVal = floor (_maxValue);

	vtkLookupTable *thresholdTable = GetThresholdTable();
	thresholdTable->SetNumberOfTableValues( (maxTot-minTot) );
	thresholdTable->SetAlphaRange(0, 1);
	thresholdTable->SetValueRange(0, 1);
	thresholdTable->SetSaturationRange(0, 0); 
	thresholdTable->SetRampToLinear( );

	//Assign a fake color for the upper image, and set the white as transparent
	int i;
	int minVal2;
	int maxVal2;
	int minTot2;
	int maxTot2;

	minVal2=minVal-minTot;
	maxVal2=maxVal-minTot;
	minTot2=minTot-minTot;
	maxTot2=maxTot-minTot;

//	thresholdTable->SetTableRange(minVal,maxVal); 
//EED  You need to do this loop just the first time
//	for(i = minTot2; i <= maxTot2; i++)
//	{
//		thresholdTable->SetTableValue(i,_baseColorR,_baseColorG,_baseColorB, 1);
//	} // for
	
	thresholdTable->SetTableRange(range); 
	for(i = minTot2; i <= maxTot2; i++)
	{
		if( i >= minVal2 && i <= maxVal2 )
		{
			thresholdTable->SetTableValue(i,_baseColorR,_baseColorG,_baseColorB, 1);
		} else if( i >= minTot2 && i < minVal2 )
		{
			thresholdTable->SetTableValue(i, 1.0, 1.0, 1.0, 0); //transparent
		} else if( i > maxVal2 && i < maxTot2 )
		{
			thresholdTable->SetTableValue(i, 1.0, 1.0, 1.0, 0); //transparent
		} else {
			thresholdTable->SetTableValue(i, 1.0, 1.0, 1.0, 0); //transparent
		}
	} // for
	thresholdTable->Build( );
}


//----------------------------------------------------------------------------
void ThresholdImageView::SetBaseColor(double r, double g, double b)
{
	_baseColorR = r;
	_baseColorG = g;
	_baseColorB = b;
}


// EOF

