 /*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



/**
 *  \file 
 *  \brief ClassThresholdImageViewPanel . 
 */


#include "ThresholdImageViewPanel.h"



/**
 ** Begin of the threshold panel
 **/
ThresholdImageViewPanel::ThresholdImageViewPanel(wxWindow* parent, int min, int max, int start, int end, int type)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize, wxBORDER_SUNKEN)
{
	_thresholdImageView = new ThresholdImageView();

//	wxButton *thresholdGoBtn = new wxButton(this,wxID_ANY,_T("Show/Hide Color"), wxDefaultPosition, wxSize(200,30) );
	
	_thresholdGo = true;
	_cb_ShowHide = new wxCheckBox(this, wxID_ANY, _T("Show/Hide layer") );
	_cb_ShowHide->SetValue(_thresholdGo);
	
	_interpolationCheckBox = new wxCheckBox(this, -1, _T("Image interpolation") );
	_interpolationCheckBox->SetValue(true);	
	_opacity = new wxSlider(this, wxID_ANY, 50, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL|wxSL_LABELS, wxDefaultValidator);
	
//	double range[2];
//	interfMainPanel::getInstance()->getImageRange(range);
	
//	int min = (int)floor (range[0]);
//	int max = (int)ceil (range[1]);

	if (type==0)
	{
	}
	
	if (type==1)
	{
		_mBarThreshold	=  new mBarRange(this,70,65);
		_mBarThreshold-> SetMin(0);
		_mBarThreshold-> SetStart(0);
		_mBarThreshold-> SetOrientation( true );
		_mBarThreshold-> setActiveStateTo(true);
		_mBarThreshold-> setVisibleLabels( true );
		_mBarThreshold-> setDeviceEndMargin(10);
		_mBarThreshold-> setRepresentedValues( min , max );
		_mBarThreshold-> setDeviceBlitStart(10,10); 
		_mBarThreshold-> setIfWithActualDrawed( false );
		_mBarThreshold-> SetStart( start );
		_mBarThreshold-> SetEnd( end );  
	}
	
	
	Connect( _cb_ShowHide->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED , (wxObjectEventFunction) &ThresholdImageViewPanel::onThresholdShow ); 
	Connect( _interpolationCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &ThresholdImageViewPanel::onThresholdInterpolation );
	Connect( _opacity->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction) &ThresholdImageViewPanel::onChangeOpacity );
	
	wxFlexGridSizer * sizer		= new wxFlexGridSizer(1);
	if (type==1)
	{
		sizer -> Add( new wxStaticText(this,-1,_T("Image Threshold"))  , 1, wxGROW );
		sizer -> Add( _mBarThreshold, 1, wxGROW );
		sizer -> Add( new wxStaticText(this,-1,_T(" "))  , 1, wxGROW );
	}
	sizer -> Add( new wxStaticText(this,-1,_T("Opacity Level"))  , 1, wxGROW );
	sizer -> Add( _opacity, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1,_T(" "))  , 1, wxGROW );
	sizer -> Add( _cb_ShowHide, 1, wxGROW );
	sizer -> Add( new wxStaticText(this,-1,_T(" "))  , 1, wxGROW );
	sizer -> Add( _interpolationCheckBox, 1, wxGROW );
	
	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout();
}

//----------------------------------------------------------------------------
ThresholdImageViewPanel::~ThresholdImageViewPanel()
{
}


//----------------------------------------------------------------------------
void ThresholdImageViewPanel::SetThresholdImageView(ThresholdImageView* thresholdImageView)
{
	_thresholdImageView = thresholdImageView;
}


//----------------------------------------------------------------------------
void ThresholdImageViewPanel::onThresholdChange(wxCommandEvent& event)
{
	if (_thresholdGo)
	{
		_thresholdImageView->SetminMaxValue( _mBarThreshold->GetStart(), _mBarThreshold->GetEnd() );
		_thresholdImageView->onThresholdChange();
		_thresholdImageView->GetwxVtkBaseView()->Refresh();
		//std::cout<< "Valor Min: " << minVal << " & Valor Max: " << maxVal  << std::endl;
	}
}

//----------------------------------------------------------------------------
void ThresholdImageViewPanel::onThresholdShow(wxCommandEvent& event)
{
	_thresholdGo = _cb_ShowHide->GetValue();
	if (_thresholdGo)
	{
		_thresholdImageView->onThreshold();
	}
	else
	{	
		_thresholdImageView->onThresholdRemove( );
	}
	_thresholdImageView->GetwxVtkBaseView()->Refresh();
}

//----------------------------------------------------------------------------
void ThresholdImageViewPanel::onThresholdStop()
{
	if (_thresholdGo)
	{	
		_thresholdImageView->onThresholdRemove( );
		_thresholdGo=false;		
	}
}

//----------------------------------------------------------------------------
void ThresholdImageViewPanel::onThresholdInterpolation(wxCommandEvent& event)
{
	_thresholdImageView->onThresholdInterpolation(_interpolationCheckBox->GetValue());
	_thresholdImageView->GetwxVtkBaseView()->Refresh();

}

//----------------------------------------------------------------------------
void ThresholdImageViewPanel::onChangeOpacity(wxScrollEvent& event)
{
	int opacity = _opacity->GetValue();
	_thresholdImageView->onThresholdChangeOpacity(opacity);
	_thresholdImageView->GetwxVtkBaseView()->Refresh();
}


//----------------------------------------------------------------------------
bool ThresholdImageViewPanel::IsVisible()
{
	return _thresholdGo;
}


BEGIN_EVENT_TABLE(ThresholdImageViewPanel, wxPanel)
  EVT_COMMAND(wxID_ANY, wxEVT_TSBAR_START, ThresholdImageViewPanel::onThresholdChange)
  EVT_COMMAND(wxID_ANY, wxEVT_TSBAR_END, ThresholdImageViewPanel::onThresholdChange)
  EVT_COMMAND(wxID_ANY, wxEVT_TSBAR_MOVED, ThresholdImageViewPanel::onThresholdChange)	

//EED Borrame
//  EVT_SCROLL(ThresholdImageViewPanel::onChangeOpacity)

END_EVENT_TABLE()



// EOF

