

#include "ViewShowNPoints.h"


//----------------------------------------------------------------------
ViewShowNPoints::ViewShowNPoints(ModelShowNPoints* modelShowNPoints)
{
    renderer                    = NULL;
    mmodelShowNPoints           = modelShowNPoints;
}
//----------------------------------------------------------------------

ViewShowNPoints::~ViewShowNPoints()
{
}


//------------------------------------------------------------------------
    
void ViewShowNPoints::RefreshPoint(int id)
{
    double spc[3];
    int x,y,z;
    GetModelShowNPoints()->GetIdPoint(id,&x,&y,&z);
    GetModelShowNPoints()->GetImage()->GetSpacing(spc);
    std::string label     = GetModelShowNPoints()->GetIdLabel(id);
    double radio         = GetModelShowNPoints()->GetRadio();
    lstActorsSphere[id]->SetPosition( spc[0]*x , spc[1]*y , spc[2]*z );
    lstActorsSphere[id]->GetProperty()->SetColor( mcolour[0] , mcolour[1] , mcolour[2] );
    lstActorsSphere[id]->GetProperty()->SetOpacity( mopacity );
    lstSourceSphere[id]->SetRadius( radio );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
    // ..
#else
    lstSourceSphere[id]->Update();
#endif
    lstActorsText[id]->SetInput( label.c_str()  );
    lstActorsText[id]->SetPosition(  radio+spc[0]*x , spc[1]*y , spc[2]*z );
}

//------------------------------------------------------------------------
void ViewShowNPoints::RefreshEachPoint()
{
    int id,size=lstActorsSphere.size();
    for (id=0;id<size;id++)
    {
        RefreshPoint(id);
    } // for
}

//------------------------------------------------------------------------
void ViewShowNPoints::RefreshPoints()
{
    RefreshEachPoint();
    renderer->GetRenderWindow()->Render();
}

//------------------------------------------------------------------------
void ViewShowNPoints::AddVtkPoint()
{
    // Sphere
    vtkSphereSource *vtksphere = vtkSphereSource::New();
    vtksphere->SetThetaResolution (10);
    vtksphere->SetPhiResolution (10);
    vtksphere->SetRadius( 1 );
    //NTU: For updating points
    lstSourceSphere.push_back(vtksphere);
    vtkPolyDataMapper *sphereMapper    = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
    sphereMapper->SetInput( vtksphere->GetOutput() );
#else
    vtksphere->Update();
    sphereMapper->SetInputData( vtksphere->GetOutput() );
#endif

    vtkActor *sphereActor    = vtkActor::New();
    sphereActor->SetMapper(sphereMapper);
    sphereActor->SetOrigin(0, 0, 0);

    lstActorsSphere.push_back(sphereActor);
    
    if(renderer==NULL){
    // EED 2022-05-19
    //    wxMessageDialog dialog(this, _T("Renderer Not Set"),_T("Renderer Not Set"),wxICON_ERROR);
    //    dialog.ShowModal();
        printf("EED ShowNPoints Warning: Renderer Not Set\n");
        return;
    }
    
    renderer->AddActor( sphereActor );
    // Actor
    vtkTextActor3D *textActor = vtkTextActor3D::New();
//    textActor->SetInput( strLabel.c_str()  );
    renderer->AddActor( textActor );
    lstActorsText.push_back(textActor);
}

//------------------------------------------------------------------------
void ViewShowNPoints::AddPoint()
{
    AddVtkPoint();
    RefreshPoint(lstActorsSphere.size()-1);
}

//------------------------------------------------------------------------
void ViewShowNPoints::Render()
{
    renderer->GetRenderWindow()->Render();
}

//------------------------------------------------------------------------
void ViewShowNPoints::ErasePoint(int id)
{
    if (this->renderer!=NULL)
    {
        if (id>=0)
        {
            renderer->RemoveActor( lstActorsSphere[id] );
            renderer->RemoveActor( lstActorsText[id] );
            lstActorsSphere[id]->Delete();
            lstActorsText[id]->Delete();
            lstSourceSphere[id]->Delete();
            lstActorsSphere.erase( lstActorsSphere.begin()+id );
            lstActorsText.erase( lstActorsText.begin()+id );
            lstSourceSphere.erase( lstSourceSphere.begin()+id );
        } // if id
    } // if renderer
}

//------------------------------------------------------------------------
ModelShowNPoints* ViewShowNPoints::GetModelShowNPoints()
{
    return mmodelShowNPoints;
}

//------------------------------------------------------------------------
void ViewShowNPoints::SetModelShowNPoints( ModelShowNPoints*  modelShowNPoints)
{
    mmodelShowNPoints = modelShowNPoints;
}
