
#ifndef __ViewShowNPoints_h_INCLUDED__
#define __ViewShowNPoints_h_INCLUDED__


#include "vtkActor.h"
#include <vtkTextActor3D.h>
#include <vtkRenderer.h>
#include <vtkSphereSource.h>
#include "vtkProperty.h"
#include "vtkPolyDataMapper.h"
#include "vtkRenderWindow.h"
#include <vtkTextProperty.h>

#include "ModelShowNPoints.h"

class ViewShowNPoints
  {
	public:
	  ViewShowNPoints(ModelShowNPoints* modelShowNPoints);
	  ~ViewShowNPoints();
      ModelShowNPoints* GetModelShowNPoints();
      void SetModelShowNPoints(ModelShowNPoints* modelShowNPoints);
      void RefreshPoint(int id);
      void RefreshEachPoint();
      void RefreshPoints();
      void AddVtkPoint();
      void AddPoint();
      void Render();
      void ErasePoint(int id);
      
      std::vector<vtkActor*>            lstActorsSphere;//NTU changed from prop3D to Actor
      std::vector<vtkTextActor3D*>      lstActorsText;
      std::vector<vtkSphereSource*>     lstSourceSphere;
      std::vector<double>               mcolour;
      double                            mopacity;
      vtkRenderer*                      renderer;
	private:
      ModelShowNPoints*                 mmodelShowNPoints;
  };

#endif // __ViewShowNPoints_h_INCLUDED__


