

#include "vtkSphereSource.h"
#include "vtkRenderer.h"
#include "vtkTextActor3D.h"



#include <wx/button.h>
#include <wx/sizer.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>
#include <wx/notebook.h>

#include "WidgetShowNPoints.h"


//----------------------------------------------------------------------
//----------------------------------------------------------------------
//----------------------------------------------------------------------
//----------------------------------------------------------------------
//----------------------------------------------------------------------
  WidgetShowNPoints::WidgetShowNPoints(wxWindow *parent, int type)
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
  {
	// EED 2022-05-19
    //  mmodelShowNPoints 				 = new ModelShowNPoints();
                        mActualCollection= 0;
    ModelShowNPoints*   modelShowNPoints = new ModelShowNPoints();
    lstModelShowNPoints.push_back( modelShowNPoints );
    lstViewShowNPoints.push_back( new  ViewShowNPoints( modelShowNPoints ) );
      
    mtype							= type;
    SetType(mtype);
    wxPanel*    panelParent         = this;
    wxSizer*    sizer				= NULL;
    wxSizer*    MNPsizer            = NULL;

    wxNotebook* bookSetPoints       = NULL;
    wxNotebook* bookGroupManager    = NULL;
    wxPanel*    panel               = NULL;
    wxPanel*    panel2              = NULL;
                txtNrCollections    = NULL;

      bookSetPoints     = new wxNotebook(panelParent,
                          -1,
                          wxDefaultPosition,
                          wxDefaultSize,
                          wxNB_TOP );
      panel  = new wxPanel(bookSetPoints);
      txtNrCollections = NULL;

    // Group Manager
    if (mtype==4)
    {
          bookGroupManager   = new wxNotebook(panelParent, //bbGetWxParent(),
                              -1,
                              wxDefaultPosition,
                              wxDefaultSize,
                              wxNB_TOP );
          panel2  = new wxPanel(bookGroupManager);
          txtNrCollections                      = new wxStaticText(panel2,-1, _T("1   /  1 "));
          wxButton *btnBackCollection           = new wxButton( panel2, -1, _T("<"));
          wxButton *btnNextCollection           = new wxButton( panel2, -1, _T(">"));
          wxButton *btnInsertCollectionBefore   = new wxButton( panel2, -1, _T("+ <"));
          wxButton *btnInsertCollectionAfter    = new wxButton( panel2, -1, _T("+ >"));
          wxButton *btnDeleteCollection         = new wxButton( panel2, -1, _T("Delete"));
          wxButton *btnSaveCollection           = new wxButton( panel2, -1, _T("Save"));
          wxButton *btnLoadCollection           = new wxButton( panel2, -1, _T("Load"));
          wxButton *btnResetCollection          = new wxButton( panel2, -1, _T("Reset"));
          wxFlexGridSizer *sizer1               = new wxFlexGridSizer(1);
          wxFlexGridSizer *sizer2               = new wxFlexGridSizer(2);
          wxFlexGridSizer *sizer3               = new wxFlexGridSizer(3);
          wxFlexGridSizer *sizer4               = new wxFlexGridSizer(3);
          wxFlexGridSizer *sizer5               = new wxFlexGridSizer(2);
          wxStaticText* txOpacity               = new wxStaticText(panel2, -1, wxString(_T("Opacity")));
        
          wxSize sizeSlider;
          sizeSlider.Set( 120  ,  -1 );
          sdrOpacity                            = new wxSlider(panel2, -1, 0, 0, 100, wxDefaultPosition, sizeSlider, wxSL_LABELS);
          wxStaticText* txRadio                 = new wxStaticText(panel2, -1, wxString(_T("Radius  ")));
          sdrRadio                              = new wxSlider(panel2, -1, 0, 1, 50, wxDefaultPosition, sizeSlider, wxSL_LABELS);

          Connect(btnBackCollection->GetId()        , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnBackCollection           );
          Connect(btnNextCollection->GetId()        , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnNextCollection           );
          Connect(btnInsertCollectionBefore->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnInsertCollectionBefore   );
          Connect(btnInsertCollectionAfter->GetId() , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnInsertCollectionAfter    );
          Connect(btnDeleteCollection->GetId()      , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnDeleteCollection         );
          Connect(sdrOpacity->GetId()               , wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints                );
          Connect(sdrRadio->GetId()                 , wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints                );
          Connect(btnSaveCollection->GetId()        , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnSaveCollections          );
          Connect(btnLoadCollection->GetId()        , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnLoadCollections          );
          Connect(btnResetCollection->GetId()       , wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnResetCollections         );

        
          sizer2->Add( btnBackCollection );
          sizer2->Add( btnNextCollection );
          sizer3->Add( btnInsertCollectionBefore );
          sizer3->Add( btnInsertCollectionAfter );
          sizer3->Add( btnDeleteCollection );
          sizer4->Add( btnSaveCollection );
          sizer4->Add( btnLoadCollection );
          sizer4->Add( btnResetCollection );
          sizer5->Add( txRadio ,wxGROW );
          sizer5->Add( txOpacity ,wxGROW );
          sizer5->Add( sdrRadio ,wxGROW );
          sizer5->Add( sdrOpacity ,wxGROW );

          sizer1->Add( txtNrCollections );
          sizer1->Add( sizer2 );
          sizer1->Add( sizer3 );
          sizer1->Add( sizer4 );
          sizer1->Add( sizer5 ,wxGROW );

    
          MNPsizer                        = sizer1;
          panel2->SetSizer( MNPsizer );
          panel2->SetAutoLayout(true);
          panel2->Layout();
          bookGroupManager->AddPage(panel2 , _T("Groups") );
    } // if mtype 4

	if ( (mtype==0) || (mtype==3) || (mtype==4) )
	{
		// Widget interface
		askPointLabel					= new wxStaticText(panel, -1, _T("Point label :")); // JPR
		textCtrl						= new wxTextCtrl(panel, -1);
		wxButton    *btnAddPoint		= new wxButton( panel, -1, _T("Add"));
		wxButton    *btnInsertPoint		= new wxButton( panel, -1, _T("Insert"));//CFT
		wxButton    *btnSetPositionPoint= new wxButton( panel, -1, _T("Set nearest"));
                     cbTrackPoint       = new wxCheckBox(panel,-1, _T("Track") );
        wxButton    *btnRenamePoint		= new wxButton( panel, -1, _T("Rename"));
        wxButton    *btnErasePoint      = new wxButton( panel, -1, _T("Erase"));
		wxButton    *btnEraseLastPoint	= new wxButton( panel, -1, _T("Erase Last"));
		wxButton    *btnDeleteAllPoints	= new wxButton( panel, -1, _T("Erase all"));
		wxButton    *btnSavePoints		= NULL;
		wxButton    *btnLoadPoints		= NULL;
		if ( mtype==0 )
		{
			btnSavePoints				= new wxButton( panel, -1, _T("Save points"));
			btnLoadPoints				= new wxButton( panel, -1, _T("Load points"));
            Connect(btnSavePoints->GetId()    , wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnSavePoints);
            Connect(btnLoadPoints->GetId()    , wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnLoadPoints);
		} // if mtype
		txtNrPoints						= new wxStaticText(panel,-1, _T(" "));

        wxStaticText* txOpacity;
        wxStaticText* txRadio;
        if ( (mtype==0) || (mtype==3) )
        {
            //NTU: Sliders for opacity and radio change
            txOpacity         = new wxStaticText(panel, -1, wxString(_T("  Points Opacity  ")));
            sdrOpacity        = new wxSlider(panel, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
            txRadio           = new wxStaticText(panel, -1, wxString(_T("  Points Radius  ")));
            sdrRadio          = new wxSlider(panel, -1, 0, 1, 50, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
            //NTU: Slider events
            Connect(sdrOpacity->GetId()          , wxEVT_COMMAND_SLIDER_UPDATED    , (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints);
            Connect(sdrRadio->GetId()            , wxEVT_COMMAND_SLIDER_UPDATED    , (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints);
        } // if mtype 0 3

		Connect(btnAddPoint->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnAddPoint);
		Connect(btnInsertPoint->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnInsertPoint);//CFT
		Connect(btnSetPositionPoint->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnSetPoint);
		Connect(btnRenamePoint->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnRenamePoint);
		Connect(btnEraseLastPoint->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnEraseLastPoint);
		Connect(btnErasePoint->GetId()		, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnErasePoint);
		Connect(btnDeleteAllPoints->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnDeleteAllPoints);
        Connect(cbTrackPoint->GetId()       , wxEVT_CHECKBOX  , (wxObjectEventFunction) &WidgetShowNPoints::OnTrackPoint);


        wxFlexGridSizer *sizer0 = new wxFlexGridSizer(1);
        wxFlexGridSizer *sizer1 = new wxFlexGridSizer(2);
        wxFlexGridSizer *sizer2 = new wxFlexGridSizer(2);
        wxFlexGridSizer *sizer3 = new wxFlexGridSizer(2);
        wxFlexGridSizer *sizer4 = new wxFlexGridSizer(2);

        sizer1->Add(textCtrl);
        sizer1->Add(btnRenamePoint);
        sizer2->Add(btnAddPoint);
        sizer2->Add(btnInsertPoint);//CFT
        sizer3->Add(cbTrackPoint);
        sizer3->Add(btnSetPositionPoint);
        sizer4->Add(btnErasePoint);
        sizer4->Add(btnEraseLastPoint);
        sizer4->Add(btnDeleteAllPoints);

		sizer0->Add(askPointLabel); // JPR
        sizer0->Add(sizer1);
        sizer0->Add(sizer2);
		sizer0->Add(sizer3);
        sizer0->Add(sizer4);
		sizer0->Add(txtNrPoints);
        
        if ( (mtype==0) || (mtype==3) )
        {
            wxFlexGridSizer *sizer5 = new wxFlexGridSizer(2);
            sizer5->Add(txRadio);
            sizer5->Add(txOpacity);
            sizer5->Add(sdrRadio,1,wxGROW );
            sizer5->Add(sdrOpacity,1,wxGROW );
            sizer0->Add(sizer5);
        }  // if mtype 0 3
        if ( mtype==0 )
		{
            wxFlexGridSizer *sizer6 = new wxFlexGridSizer(2);
			sizer6->Add(btnSavePoints);
			sizer6->Add(btnLoadPoints);
            sizer0->Add(sizer6);
		} // if mtype 0
		sizer = sizer0;
	}

	  if (mtype==1)
	  {
		  // Widget interface
		  wxButton *btnSetPositionPoint		= new wxButton( panel, -1, _T("Set nearest point"));
		  txtNrPoints						= new wxStaticText(panel,-1, _T(" "));

		  //NTU: Sliders for opacity and radio change
		  wxStaticText* txOpacity			= new wxStaticText(panel, -1, wxString(_T("  Points Opacity  ")));
		  sdrOpacity						= new wxSlider(panel, -1, 0, 0, 100, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
		  wxStaticText* txRadio				= new wxStaticText(panel, -1, wxString(_T("  Points Radio  ")));
		  sdrRadio							= new wxSlider(panel, -1, 0, 1, 50, wxDefaultPosition, wxDefaultSize, wxSL_LABELS);
		  Connect(btnSetPositionPoint->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &WidgetShowNPoints::OnSetPoint);
		  Connect(sdrOpacity->GetId()   , wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints);
		  Connect(sdrRadio->GetId()     , wxEVT_COMMAND_SLIDER_UPDATED	, (wxObjectEventFunction) &WidgetShowNPoints::UpdatePoints);

          wxFlexGridSizer *sizer1            = new wxFlexGridSizer(1);
		  sizer1->Add(btnSetPositionPoint);
		  sizer1->Add(txtNrPoints);
		  sizer1->Add(txRadio);
		  sizer1->Add(sdrRadio,1,wxGROW );
          sizer1->Add(txOpacity);
          sizer1->Add(sdrOpacity,1,wxGROW );
		  sizer = sizer1;
	  }
    
    if (mtype == 2) 
	{
		askPointLabel 						= new wxStaticText(panel, -1, _T("\nPOINT CONTROLS:")); // JPR
      	wxButton 		*btnAddPoint 		= new wxButton(panel, -1,        _T("      Add  Point      "));
        wxButton 		*btnDeleteAllPoints = new wxButton(panel, -1, _T("      Delete All      "));
        wxStaticText	*spacer 			= new wxStaticText(panel, -1, _T("\n")); // JPR
        				 textCtrl 			= new wxTextCtrl(panel, -1);
        Connect(btnAddPoint->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnAddPoint);
        Connect(btnDeleteAllPoints->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction) & WidgetShowNPoints::OnDeleteAllPoints);    
        wxFlexGridSizer *sizer1             = new wxFlexGridSizer(1);
        sizer1->Add(askPointLabel);
        sizer1->Add(btnAddPoint);
        sizer1->Add(btnDeleteAllPoints);
        sizer1->Add(spacer);
        sizer1->Add(textCtrl);
      //  sdrOpacity                          = new wxSlider();
      //  sdrRadio                            = new wxSlider();
        txtNrPoints                         = new wxStaticText(panel, -1, _T("\n\n\n"));
        sizer                               = sizer1;
	} // bbGetInputType 2

            
      panel->SetSizer(sizer);
      panel->SetAutoLayout(true);
      panel->Layout();
      bookSetPoints->AddPage(panel , _T("Points") );

    if ((mtype >= 0) && (mtype <= 3) )
    {
        if (sizer!=NULL)
        {
            wxFlexGridSizer *sizerParent             = new wxFlexGridSizer(1);
            sizerParent->Add( bookSetPoints );
            panelParent->SetSizer( sizerParent );
            panelParent->SetAutoLayout(true);
            panelParent->Layout();
        } // if sizer
    } // if  mtype 0 1 2 3
      
    if (mtype == 4)
    {
        if ((sizer!=NULL) && (MNPsizer!=NULL))
        {
            wxFlexGridSizer *sizerG             = new wxFlexGridSizer(2);
            sizerG->Add(bookGroupManager);
            sizerG->Add(bookSetPoints);
            panelParent->SetSizer(sizerG);
            panelParent->SetAutoLayout(true);
            panelParent->Layout();
        } // if sizer
    } // if mtype 4
}

//------------------------------------------------------------------------
WidgetShowNPoints::~WidgetShowNPoints()
{
}

//------------------------------------------------------------------------
ModelShowNPoints* WidgetShowNPoints::GetModelShowNPoints()
{
    // EED 2022-05-19
    // return mmodelShowNPoints;
    return lstModelShowNPoints[ mActualCollection ];
}

// EED 2022-05-19
//------------------------------------------------------------------------
ViewShowNPoints* WidgetShowNPoints::GetViewShowNPoints()
{
    return lstViewShowNPoints[ mActualCollection ];
}


//------------------------------------------------------------------------
void WidgetShowNPoints::SetRadio(double radio)
{
    // EED 2022-05-19
    // GetModelShowNPoints()->SetRadio(radio);
    int i,size = lstModelShowNPoints.size();
    for (i=0;i<size;i++)
    {
        lstModelShowNPoints[i]->SetRadio( radio );
    } // for i
	//NTU: For Slider
	sdrRadio->SetValue(radio);
}

//------------------------------------------------------------------------
void WidgetShowNPoints::SetColour(std::vector<double> colour)
{
    // EED 2022-05-19
    //this->mcolour = colour;
    int i,size = lstViewShowNPoints.size();
    for (i=0 ; i<size ; i++)
    {
        lstViewShowNPoints[i]->mcolour = colour;
    } // for i
}

//------------------------------------------------------------------------
void WidgetShowNPoints::SetImage(vtkImageData* image)
{
    // EED 2022-05-19
	//GetModelShowNPoints()->SetImage(image);
    int i,size = lstModelShowNPoints.size();
    for (i=0 ; i<size ; i++)
    {
        lstModelShowNPoints[i]->SetImage(image);
    } // for i
}

//------------------------------------------------------------------------
void WidgetShowNPoints::SetOpacity(double opacity)
{
    // EED 2022-05-19
	//this->mopacity=opacity;
    int i,size = lstViewShowNPoints.size();
    for (i=0 ; i<size ; i++)
    {
        lstViewShowNPoints[i]->mopacity = opacity;
    } // for i
	//NTU: For Slider
	sdrOpacity->SetValue( opacity*100.0 );
}


//------------------------------------------------------------------------
void  WidgetShowNPoints::SetRenderer(vtkRenderer *renderer)
{
    // EED 2022-05-19
	//this->renderer	= renderer;
    int i,size = lstViewShowNPoints.size();
    for (i=0 ; i<size ; i++)
    {
        lstViewShowNPoints[i]->renderer = renderer;
    } // for i
}

/* EED 2022-05-19
//------------------------------------------------------------------------
	
void WidgetShowNPoints::RefreshPoint(int id)
{
	double spc[3];
	int x,y,z;
	GetModelShowNPoints()->GetIdPoint(id,&x,&y,&z);
	GetModelShowNPoints()->GetImage()->GetSpacing(spc);
	std::string label 	= GetModelShowNPoints()->GetIdLabel(id);
	double radio 		= GetModelShowNPoints()->GetRadio();
    lstActorsSphere[id]->SetPosition( spc[0]*x , spc[1]*y , spc[2]*z );
    lstActorsSphere[id]->GetProperty()->SetColor( mcolour[0] , mcolour[1] , mcolour[2] );
    lstActorsSphere[id]->GetProperty()->SetOpacity( mopacity );
    lstSourceSphere[id]->SetRadius( radio );
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	// ..
#else
    lstSourceSphere[id]->Update();
#endif
    lstActorsText[id]->SetInput( label.c_str()  );
    lstActorsText[id]->SetPosition(  radio+spc[0]*x , spc[1]*y , spc[2]*z );
}

//------------------------------------------------------------------------
void WidgetShowNPoints::RefreshPoints()
{
	int id,size=lstActorsSphere.size();
	for (id=0;id<size;id++)
	{
		RefreshPoint(id);
	} // for
	renderer->GetRenderWindow()->Render();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::AddVtkPoint()
{
	// Sphere
	vtkSphereSource *vtksphere = vtkSphereSource::New();
	vtksphere->SetThetaResolution (20);
	vtksphere->SetPhiResolution (20);
	vtksphere->SetRadius( 1 );
	//NTU: For updating points
	lstSourceSphere.push_back(vtksphere);
	vtkPolyDataMapper *sphereMapper	= vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	sphereMapper->SetInput( vtksphere->GetOutput() );
#else
	vtksphere->Update();
	sphereMapper->SetInputData( vtksphere->GetOutput() );
#endif

	vtkActor *sphereActor	= vtkActor::New();
	sphereActor->SetMapper(sphereMapper);
	sphereActor->SetOrigin(0, 0, 0);

	lstActorsSphere.push_back(sphereActor);
	if(renderer==NULL){
		wxMessageDialog dialog(this, _T("Renderer Not Set"),_T("Renderer Not Set"),wxICON_ERROR);
		dialog.ShowModal();		
		return;
	}
	renderer->AddActor( sphereActor );
	// Actor
	vtkTextActor3D *textActor = vtkTextActor3D::New();
//	textActor->SetInput( strLabel.c_str()  );
	renderer->AddActor( textActor );
	lstActorsText.push_back(textActor);
}
 */


//------------------------------------------------------------------------
void WidgetShowNPoints::AddPoint(int x, int y, int z, std::string label)
{
	GetModelShowNPoints()->AddPoint(x,y,z, label );
    // EED 2022-05-19
    //AddVtkPoint();
    //RefreshPoint(lstActorsSphere.size()-1);
    GetViewShowNPoints()->AddPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::InsertPoint(int x, int y, int z, std::string label)//CFT
{
    // EED 2022-05-19
	//if ( GetModelShowNPoints()->InsertPoint(x,y,z,label) != -1 )
	//{
    //    AddVtkPoint();
	//} else {
	//	AddPoint(x,y,z,label);
	//}
	//RefreshPoints();
    if ( GetModelShowNPoints()->InsertPoint(x,y,z,label) != -1 )
    {
        GetViewShowNPoints()->AddVtkPoint();
    } else {
        AddPoint(x,y,z,label);
    }
    GetViewShowNPoints()->RefreshPoints();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnInsertPoint_()
{
    // EED 2022-05-19
    //if (this->renderer==NULL)
    if (GetViewShowNPoints()->renderer==NULL)
    {
        return;
    }

    std::vector<int> point = GetModelShowNPoints()->GetReferencePoint();
    if (point.size()==3)
    {
        InsertPoint(point[0],point[1],point[2], (const char*) ( textCtrl->GetValue().mb_str() ) );
        SetOutputBox();
    } else {//mpoint.size
        printf("creaMaracasVisu::ShowNPoints (not match point) \n");
    }
}



//------------------------------------------------------------------------
void WidgetShowNPoints::OnAddPoint_()
{	
    // EED 2022-05-19
	//if (this->renderer==NULL)
    if (GetViewShowNPoints()->renderer==NULL)
	{
		return;
	}

	std::vector<int> point = GetModelShowNPoints()->GetReferencePoint();
	if (point.size()==3)
	{
		AddPoint(point[0],point[1],point[2], (const char*) ( textCtrl->GetValue().mb_str() ) );
		SetOutputBox();
        // EED 2022-05-19
        //renderer->GetRenderWindow()->Render();
        GetViewShowNPoints()->Render();
	} else {//mpoint.size
		printf("creaMaracasVisu::ShowNPoints (not match point) \n");
	}
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnAddPoint (wxCommandEvent& event)
{
    OnAddPoint_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnInsertPoint (wxCommandEvent& event)//CFT
{
    OnInsertPoint_();
}


//------------------------------------------------------------------------
	void WidgetShowNPoints::SetOutputBox()
	{
//EED		renderer->GetRenderWindow()->Render();
		wxString strTmp;
		strTmp.Printf(_T("Nbr of points: %d"), GetModelShowNPoints()->GetLstPointsSize() );
		txtNrPoints->SetLabel( strTmp );
		//--BBTK

//EED 2017-06-03
//		mbbShowNPoints->bbSetOutputlstPointsX( GetModelShowNPoints()->GetLstPointsX() );
//		mbbShowNPoints->bbSetOutputlstPointsY( GetModelShowNPoints()->GetLstPointsY() );
//		mbbShowNPoints->bbSetOutputlstPointsZ( GetModelShowNPoints()->GetLstPointsZ() );
//		mbbShowNPoints->bbSetOutputlstLabels( GetModelShowNPoints()->GetLstLabels() );
//		mbbShowNPoints->bbSignalOutputModification();
	}


//------------------------------------------------------------------------
	void WidgetShowNPoints::OnSavePoints(wxCommandEvent& event)
	{

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		wxFileDialog* FD = new wxFileDialog( 0,
                                            _T("Save points .."),
                                            _T(""),
                                            _T(""),
                                            _T("(*.xls)|*.xls"),
                                            wxSAVE | wxOVERWRITE_PROMPT,
                                            wxDefaultPosition);
#else
		wxFileDialog* FD = new wxFileDialog( 0,
                                            _T("Save points .."),
                                            _T(""),
                                            _T(""),
                                            _T("(*.xls)|*.xls"),
                                            wxFD_SAVE | wxFD_OVERWRITE_PROMPT,
                                            wxDefaultPosition);
#endif

		int result_FD = FD->ShowModal();
		// This line is need it by windows //EED
		FD->SetReturnCode( result_FD );
		if (FD->GetReturnCode()==wxID_OK)
		{
			std::string filename= (const char*) ( FD->GetPath().mb_str() );	
			GetModelShowNPoints()->SavePoints( filename );
		} 	// dialog box
	}


//------------------------------------------------------------------------
	void WidgetShowNPoints::OnLoadPoints(wxCommandEvent& event)
	{

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		wxFileDialog* FD = new wxFileDialog( 0,
                                             _T("Load points .."),
                                             _T(""),
                                             _T(""),
                                             _T("(*.xls)|*.xls"),
                                             wxOPEN | wxFILE_MUST_EXIST,
                                             wxDefaultPosition);
#else
		wxFileDialog* FD = new wxFileDialog( 0,
                                             _T("Load points .."),
                                             _T(""),
                                             _T(""),
                                             _T("(*.xls)|*.xls"),
                                             wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                             wxDefaultPosition);
#endif
		int i;
		//EED
		int result_FD = FD->ShowModal();
		// This line is need it by windows //EED
		FD->SetReturnCode( result_FD );
		if (FD->GetReturnCode()==wxID_OK)
		{

			std::string filename= (const char*) ( FD->GetPath().mb_str() );	
			int numberPointsRead = GetModelShowNPoints()->ReadPoints( filename );
			for (i=0;i<numberPointsRead;i++)
			{
                // EED 2022-05-19
                //AddVtkPoint();
                GetViewShowNPoints()->AddVtkPoint();
			}// for
			SetOutputBox();
            // EED 2022-05-19
			//RefreshPoints();
            GetViewShowNPoints()->RefreshPoints();
		} 	// dialog box
	}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnSetPoint_()
{
    int id=GetModelShowNPoints()->GetNearestPoint();
    if((id==-1) && (mtype==1))
    {
        id=0;
        AddPoint(0,0,0,"");
        SetOutputBox();
    }
    if (id>=0)
    {
        GetModelShowNPoints()->SetPointId_mReferencePoint(id);
        // EED 2022-05-19
        //RefreshPoint(id);
        //renderer->GetRenderWindow()->Render();
        GetViewShowNPoints()->RefreshPoint(id);
        GetViewShowNPoints()->Render();
    } // if id
    SetOutputBox();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnSetPoint(wxCommandEvent& event)
{
    OnSetPoint_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::TrackingPoint( )
{
    if ( cbTrackPoint->GetValue() == true )
    {
        int id = GetModelShowNPoints()->IdInsidePoint();
        if (id>=0)
        {
            idTrack=id;
        }
        
        if (idTrack>=0)
        {
            GetModelShowNPoints()->SetPointId_mReferencePoint(idTrack);
            GetViewShowNPoints()->RefreshPoint(idTrack);
            GetViewShowNPoints()->Render();
        } // if id
    } // if trackPointFlag
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnTrackPoint_tool()
{
    cbTrackPoint->SetValue( !cbTrackPoint->GetValue() );
    OnTrackPoint_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnTrackPoint_()
{
    idTrack         =   -1;
    if ( cbTrackPoint->GetValue() == true )
    {
        idTrack = GetModelShowNPoints()->IdInsidePoint();
    } // if trackPointFlag
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnTrackPoint(wxCommandEvent& event)
{
    OnTrackPoint_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::StopTrackPoint( )
{
    cbTrackPoint->SetValue(false);
    idTrack=-1;
}

//------------------------------------------------------------------------
	void WidgetShowNPoints::OnRenamePoint(wxCommandEvent& event)
	{
		int id = GetModelShowNPoints()->RenamePoint( (const char*) ( textCtrl->GetValue().mb_str() ) );
		if (id>=0)
		{
            // EED 2022-05-19
			//lstActorsText[id]->SetInput(  (const char*) ( textCtrl->GetValue().mb_str() ) );
			//renderer->GetRenderWindow()->Render();
            GetViewShowNPoints()->lstActorsText[id]->SetInput(  (const char*) ( textCtrl->GetValue().mb_str() ) );
            GetViewShowNPoints()->Render();
            SetOutputBox();
		}
	}

//------------------------------------------------------------------------
	void WidgetShowNPoints::ErasePoint(int id)
	{
        // EED 2022-05-19
		//if (this->renderer!=NULL)
        if (GetViewShowNPoints()->renderer!=NULL)
		{
			if (id>=0)
			{
                // EED 2022-05-19
				//renderer->RemoveActor( lstActorsSphere[id] );
				//renderer->RemoveActor( lstActorsText[id] );
				//lstActorsSphere[id]->Delete();
				//lstActorsText[id]->Delete();
				//lstSourceSphere[id]->Delete();
				//lstActorsSphere.erase( lstActorsSphere.begin()+id );
				//lstActorsText.erase( lstActorsText.begin()+id );
				//lstSourceSphere.erase( lstSourceSphere.begin()+id );
                GetViewShowNPoints()->ErasePoint(id);
				GetModelShowNPoints()->ErasePoint(id);
			} // if id
		} // if renderer
	}

//------------------------------------------------------------------------
    void WidgetShowNPoints::OnErasePoint_()
    {
        ErasePoint( GetModelShowNPoints()->IdInsidePoint() );
        SetOutputBox();
        // EED 2022-05-19
        //renderer->GetRenderWindow()->Render();
        GetViewShowNPoints()->Render();
        StopTrackPoint();
    }

//------------------------------------------------------------------------
	void WidgetShowNPoints::OnErasePoint(wxCommandEvent& event)
	{
		OnErasePoint_();
	}

//------------------------------------------------------------------------
	void WidgetShowNPoints::OnEraseLastPoint(wxCommandEvent& event)
	{
        // EED 2022-05-19
        //ErasePoint( lstActorsSphere.size()-1 );
        //renderer->GetRenderWindow()->Render();
        int id = GetViewShowNPoints()->lstActorsSphere.size()-1;
        ErasePoint( id );
        GetViewShowNPoints()->Render();
        SetOutputBox();
        StopTrackPoint();
	}

//------------------------------------------------------------------------
void WidgetShowNPoints::DeleteAllPoints()
{
    // EED 2022-05-19
    //int id,size=lstActorsSphere.size();
    int id,size=GetViewShowNPoints()->lstActorsSphere.size();
    for (id=size-1;id>=0;id--)
    {
        ErasePoint(id);
    }
    SetOutputBox();
    // EED 2022-05-19
    //renderer->GetRenderWindow()->Render();
    GetViewShowNPoints()->Render();
}


//------------------------------------------------------------------------
void WidgetShowNPoints::OnDeleteAllPoints(wxCommandEvent& event)
{
	DeleteAllPoints();
}

//NTU: Method for updating points opacity and Radio

//------------------------------------------------------------------------
void WidgetShowNPoints::UpdatePoints_()
{
    // EED 2022-05-19
    //this->mopacity = sdrOpacity->GetValue()/100.0;
    //GetModelShowNPoints()->SetRadio( sdrRadio->GetValue() ) ;
    //RefreshPoints();

    double opacity  = sdrOpacity->GetValue()/100.0;
    double radio    = sdrRadio->GetValue();
    int i,size      = lstViewShowNPoints.size();
    for (i=0 ; i<size ; i++)
    {
        lstViewShowNPoints[i]->mopacity = opacity;
        lstModelShowNPoints[i]->SetRadio( radio ) ;
    } // for i
//    GetViewShowNPoints()->RefreshPoints();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::UpdatePoints(wxCommandEvent &event)
{
    RefreshColourCollection();
}

//------------------------------------------------------------------------
void  WidgetShowNPoints::SetReferencePoint(std::vector<int> point)
{
	GetModelShowNPoints()->SetReferencePoint(point);
    int i,size=lstModelShowNPoints.size();
    for (i=0;i<size;i++)
    {
        lstModelShowNPoints[i]->SetReferencePoint(point);    // All collection
    } // for i
}

//------------------------------------------------------------------------
void  WidgetShowNPoints::SetInitLstPoints( std::vector<int> initLstPointsX,  std::vector<int> initLstPointsY, std::vector<int> initLstPointsZ, std::vector<std::string> initLstLabels )
{
    // EED 2022-05-19
	//if (this->renderer==NULL)
    if (GetViewShowNPoints()->renderer==NULL)
	{
		return;
	}
	int i,sizeX,sizeY,sizeZ,sizeLabels;
	sizeX = (int)initLstPointsX.size();
	sizeY = (int)initLstPointsY.size();
	sizeZ = (int)initLstPointsZ.size();
	sizeLabels = (int)initLstLabels.size();
	int x,y,z;
	std::string label;
	if ( (sizeX==sizeY) && (sizeX==sizeZ) )
	{
		for (i=0;i<sizeX;i++)
		{
			x		= initLstPointsX[i];
			y		= initLstPointsY[i];
			z		= initLstPointsZ[i];
			if (i<sizeLabels) 
			{
				label	= initLstLabels[i];
			} else {
				label="";
			}
			AddPoint( x,y,z,label );
		} // for i
		//	SetOutputBox();	
		//	renderer->GetRenderWindow()->Render();
	} // if size
}

//------------------------------------------------------------------------
void WidgetShowNPoints::SetType(int type)
{
	mtype=type;
}

//------------------------------------------------------------------------
int WidgetShowNPoints::GetType()
{
	return mtype;
}


//------------------------------------------------------------------------
double WidgetShowNPoints::GetRadio()
{
	return sdrRadio->GetValue();
}
//------------------------------------------------------------------------
double WidgetShowNPoints::GetOpacity()
{
	return sdrOpacity->GetValue()/100;
}

//------------------------------------------------------------------------
void WidgetShowNPoints::InsertCollection()
{
    ModelShowNPoints*   model   = new ModelShowNPoints();
    ViewShowNPoints*    view    = new ViewShowNPoints( model );
    model->SetImage( lstModelShowNPoints[0]->GetImage() );
    view->mopacity = lstViewShowNPoints[0]->mopacity;
    view->renderer = lstViewShowNPoints[0]->renderer;
    lstModelShowNPoints.insert( lstModelShowNPoints.begin()+mActualCollection , model );
    lstViewShowNPoints.insert( lstViewShowNPoints.begin()+mActualCollection , view );
    RefreshCollectionText();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnInsertCollectionBefore(wxCommandEvent &event)
{
    InsertCollection();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnInsertCollectionAfter_()
{
    mActualCollection++;
    InsertCollection();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnInsertCollectionAfter(wxCommandEvent &event)
{
    OnInsertCollectionAfter_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::DeleteCollection_()
{
    if ( lstModelShowNPoints.size()>1 )
    {
        DeleteAllPoints();  // Actual Collection
        lstModelShowNPoints.erase( lstModelShowNPoints.begin()+mActualCollection );
        lstViewShowNPoints.erase( lstViewShowNPoints.begin()+mActualCollection );
        if ( mActualCollection>=lstModelShowNPoints.size() )
        {
            mActualCollection--;
        } // if
    } else {
        DeleteAllPoints();  // Actual Collection
    } // if
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnDeleteCollection_()
{
    DeleteCollection_();
    RefreshCollectionText();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnDeleteCollection(wxCommandEvent &event)
{
    OnDeleteCollection_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnResetCollections_()
{
    printf("EED WidgetShowNPoints::OnResetCollections_  \n");
    int i,size=lstModelShowNPoints.size();
    for (i=0;i<size;i++)
    {
        DeleteCollection_();
    }
    RefreshCollectionText();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnResetCollections(wxCommandEvent &event)
{
    OnResetCollections_();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnBackCollection(wxCommandEvent &event)
{
    mActualCollection--;
    if ( mActualCollection <0  )
    {
        mActualCollection=0;
    } //if <=0
    RefreshCollectionText();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnNextCollection(wxCommandEvent &event)
{
    mActualCollection++;
    if ( mActualCollection >=lstModelShowNPoints.size() )
    {
        mActualCollection = lstModelShowNPoints.size()-1;
    } //if <=0
    RefreshCollectionText();
    RefreshColourCollection();
    StopTrackPoint();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::DetectCollectionActive()
{
    int id;
    int i,size=lstModelShowNPoints.size();
    for (i=0;i<size;i++)
    {
        id = lstModelShowNPoints[i]->IdInsidePoint();
        if (id>=0)
        {
            mActualCollection=i;
        } // if id>=0
    } // for i
    RefreshCollectionText();
    RefreshColourCollection();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::RefreshColourCollection()
{
    UpdatePoints_();
    std::vector<double> colourAll;
    colourAll.push_back(1);
    colourAll.push_back(0);
    colourAll.push_back(0);
    std::vector<double> colourActual;
    colourActual.push_back(1);
    colourActual.push_back(1);
    colourActual.push_back(0);
    SetColour( colourAll );                                             // For all collections
    int i,size=lstViewShowNPoints.size();
    for (i=0;i<size;i++)
    {
        lstViewShowNPoints[i] -> mcolour = colourAll;    // All collection
        lstViewShowNPoints[i]->RefreshEachPoint();
    } // for i
    lstViewShowNPoints[mActualCollection] -> mcolour = colourActual;    // Actual collection
    lstViewShowNPoints[mActualCollection] -> RefreshEachPoint();
    lstViewShowNPoints[mActualCollection] -> renderer->GetRenderWindow()->Render();
}

//------------------------------------------------------------------------
void WidgetShowNPoints::RefreshCollectionText()
{
    if ((mtype==4) && (txtNrCollections!=NULL))  // Just for Collection interface
    {
        wxString strTmp;
        strTmp.Printf(_T("%d   /  %d "),  (int)mActualCollection+1, (int)lstModelShowNPoints.size() );
        txtNrCollections->SetLabel( strTmp );
        SetOutputBox();
    } // if mtype 4
}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnSaveCollections(wxCommandEvent &event)
{
    //EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
    #if wxMAJOR_VERSION <= 2
            wxFileDialog* FD = new wxFileDialog( 0,
                                                _T("Save groups of points .."),
                                                _T(""),
                                                _T(""),
                                                _T("(*.xls)|*.xls"),
                                                wxSAVE | wxOVERWRITE_PROMPT,
                                                wxDefaultPosition);
    #else
            wxFileDialog* FD = new wxFileDialog( 0,
                                                _T("Save groups of points .."),
                                                _T(""),
                                                _T(""),
                                                _T("(*.xls)|*.xls"),
                                                wxFD_SAVE | wxFD_OVERWRITE_PROMPT,
                                                wxDefaultPosition);
    #endif

            int result_FD = FD->ShowModal();
            // This line is need it by windows //EED
            FD->SetReturnCode( result_FD );
            if (FD->GetReturnCode()==wxID_OK)
            {
                std::string filename= (const char*) ( FD->GetPath().mb_str() );

                FILE *ff;
                ff = fopen( filename.c_str() , "w+" );
                if (ff!=NULL)
                {
                    int i,size=lstModelShowNPoints.size();
                    fprintf(ff,"NumberOfGroups %d \n",size);

                    for (i=0;i<size;i++)
                    {
                        lstModelShowNPoints[i]->SavePoints_(ff);
                    } // for i

                    fclose(ff);
                } else {   // else ff
                    printf("WidgetShowNPoints::Save Groups Points  ...Error... creating file \n");
                } //ff

                
            }     // dialog box
    StopTrackPoint();

}

//------------------------------------------------------------------------
void WidgetShowNPoints::OnLoadCollections(wxCommandEvent &event)
{
    //EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
    #if wxMAJOR_VERSION <= 2
            wxFileDialog* FD = new wxFileDialog( 0,
                                                 _T("Load groups of points .."),
                                                 _T(""),
                                                 _T(""),
                                                 _T("(*.xls)|*.xls"),
                                                 wxOPEN | wxFILE_MUST_EXIST,
                                                 wxDefaultPosition);
    #else
            wxFileDialog* FD = new wxFileDialog( 0,
                                                 _T("Load groups of points .."),
                                                 _T(""),
                                                 _T(""),
                                                 _T("(*.xls)|*.xls"),
                                                 wxFD_OPEN | wxFD_FILE_MUST_EXIST,
                                                 wxDefaultPosition);
    #endif
            bool okEraseFirstGrout=false;

            int result_FD = FD->ShowModal();
            // This line is need it by windows //EED
            FD->SetReturnCode( result_FD );
            if (FD->GetReturnCode()==wxID_OK)
            {
                if (lstModelShowNPoints.size()==1)
                {
                    if (GetModelShowNPoints()->GetLstPointsSize()==0) { okEraseFirstGrout=true; }
                }
                std::string filename= (const char*) ( FD->GetPath().mb_str() );
                FILE *ff = fopen( filename.c_str() , "r+" );
                if (ff!=NULL)
                {
                    int i;
                    int iGroup,sizeGroups;
                    int iPoint,numberPointsRead;
                    char chartmp[256];
                    fscanf(ff," %s %d",chartmp,&sizeGroups);
                    for (iGroup=0;iGroup<sizeGroups;iGroup++)
                    {
                        mActualCollection = lstModelShowNPoints.size();
                        InsertCollection();

                        int numberPointsRead= lstModelShowNPoints[mActualCollection]->ReadPoints_(ff);
                        for (i=0;i<numberPointsRead;i++)
                        {
                            // EED 2022-05-19
                            //AddVtkPoint();
                            GetViewShowNPoints()->AddVtkPoint();
                        }// for
                    } // for i

                    fclose(ff);
                } else {   // else ff
                    printf("WidgetShowNPoints::Load Group of Points  ...Error... reading file");
                } //ff
                if (okEraseFirstGrout==true)
                {
                    mActualCollection=0;
                    DeleteCollection_();
                    mActualCollection = lstModelShowNPoints.size()-1;
                }
                RefreshCollectionText();
                RefreshColourCollection();
            }     // dialog box
    StopTrackPoint();
}


//------------------------------------------------------------------------
std::vector<int> WidgetShowNPoints::GetLstPointsX()
{
    if (mtype!=4)
    {
        return GetModelShowNPoints()->GetLstPointsX();
    } else {
        std::vector<int> lst;
        int iP,s;
        int iG,sG=lstModelShowNPoints.size();
        for (iG=0 ; iG<sG ; iG++)
        {
            std::vector<int> lstTmp = lstModelShowNPoints[iG]->GetLstPointsX();
            s = lstTmp.size();
            for (iP=0 ; iP<s ; iP++)
            {
                lst.push_back( lstTmp[iP] );
            } // for iP
        } // for iG
        return lst;
    } // if 4
}

//------------------------------------------------------------------------
std::vector<int> WidgetShowNPoints::GetLstPointsY()
{
    if (mtype!=4)
    {
        return GetModelShowNPoints()->GetLstPointsY();
    } else {
        std::vector<int> lst;
        int iP,s;
        int iG,sG=lstModelShowNPoints.size();
        for (iG=0 ; iG<sG ; iG++)
        {
            std::vector<int> lstTmp = lstModelShowNPoints[iG]->GetLstPointsY();
            s = lstTmp.size();
            for (iP=0 ; iP<s ; iP++)
            {
                lst.push_back( lstTmp[iP] );
            } // for iP
        } // for iG
        return lst;
    }
}

//------------------------------------------------------------------------
std::vector<int> WidgetShowNPoints::GetLstPointsZ()
{
    if (mtype!=4)
    {
        return GetModelShowNPoints()->GetLstPointsZ();
    } else {
        std::vector<int> lst;
        int iP,s;
        int iG,sG=lstModelShowNPoints.size();
        for (iG=0 ; iG<sG ; iG++)
        {
            std::vector<int> lstTmp = lstModelShowNPoints[iG]->GetLstPointsZ();
            s = lstTmp.size();
            for (iP=0 ; iP<s ; iP++)
            {
                lst.push_back( lstTmp[iP] );
            } // for iP
        } // for iG
        return lst;

    }
}

//------------------------------------------------------------------------
std::vector<std::string> WidgetShowNPoints::GetLstLabels()
{
    if (mtype!=4)
    {
        return GetModelShowNPoints()->GetLstLabels();
    } else {
        std::vector< std::string > lst;
        int iP,s;
        int iG,sG=lstModelShowNPoints.size();
        for (iG=0 ; iG<sG ; iG++)
        {
            std::vector< std::string > lstTmp = lstModelShowNPoints[iG]->GetLstLabels();
            s = lstTmp.size();
            for (iP=0 ; iP<s ; iP++)
            {
                lst.push_back( lstTmp[iP] );
            } // for iP
        } // for iG
        return lst;
    }
}

//------------------------------------------------------------------------
std::vector<int> WidgetShowNPoints::GetLstIndexs()
{
    std::vector<int> lstIndexs;
    if (mtype!=4)
    {
        lstIndexs.push_back( GetModelShowNPoints()->GetLstPointsSize() );
    } else {
        int iG,sG=lstModelShowNPoints.size();
        for (iG=0 ; iG<sG ; iG++)
        {
            lstIndexs.push_back( lstModelShowNPoints[iG]->GetLstPointsSize() );
        } // for iG
    }
    return lstIndexs;
}

//------------------------------------------------------------------------
int WidgetShowNPoints::GetLstModelShowNPointsSize()
{
    return lstModelShowNPoints.size();
}
