
#ifndef __WidgetShowNPoints_h_INCLUDED__
#define __WidgetShowNPoints_h_INCLUDED__

#include "ModelShowNPoints.h"
#include "ViewShowNPoints.h"

#include <wx/panel.h>
#include <wx/textctrl.h>
#include <wx/slider.h>
#include <wx/stattext.h>
#include <wx/checkbox.h>


class WidgetShowNPoints : public wxPanel
{
  public:
	  WidgetShowNPoints( wxWindow *parent , int type );
	  ~WidgetShowNPoints(); 
	  void OnAddPoint(wxCommandEvent &event);   
      void OnAddPoint_();
	  void OnInsertPoint(wxCommandEvent& event);//CFT
      void OnSetPoint_();
	  void OnSetPoint(wxCommandEvent& event);
      void OnTrackPoint(wxCommandEvent& event);
      void OnTrackPoint_();
      void OnTrackPoint_tool();
      void TrackingPoint();
      void StopTrackPoint();
      void DetectCollectionActive();

	  void OnRenamePoint(wxCommandEvent& event);
      void OnErasePoint_();
	  void OnErasePoint(wxCommandEvent& event);
	  void OnEraseLastPoint(wxCommandEvent &event); 
	  void OnDeleteAllPoints(wxCommandEvent &event);
    
	  void OnSavePoints(wxCommandEvent &event);   
	  void OnLoadPoints(wxCommandEvent &event);

	  virtual void UpdatePoints(wxCommandEvent &event);
      void UpdatePoints_();

      void InsertCollection();
      void OnInsertCollectionBefore(wxCommandEvent &event);
      void OnInsertCollectionAfter_();
      void OnInsertCollectionAfter(wxCommandEvent &event);
      void OnDeleteCollection_();
      void OnDeleteCollection(wxCommandEvent &event);
      void DeleteCollection_();
      void OnBackCollection(wxCommandEvent &event);
      void OnNextCollection(wxCommandEvent &event);
      void OnSaveCollections(wxCommandEvent &event);
      void OnLoadCollections(wxCommandEvent &event);
      void OnResetCollections(wxCommandEvent &event);
      void OnResetCollections_();

      void RefreshCollectionText();
      void RefreshColourCollection();

    
      // EED 2022-05-19
	  //void RefreshPoint(int id);
      //void RefreshPoints();
      //void AddVtkPoint();

	  void SetColour(std::vector<double> colour);
	  void SetOpacity(double opacity);
	  void SetRadio(double radio);
	  void SetImage(vtkImageData *image);
	  void SetRenderer(vtkRenderer *renderer);
	  void SetReferencePoint(std::vector<int> point);

	  void AddPoint(int x, int y, int z, std::string label);
      void OnInsertPoint_();
	  void InsertPoint(int x, int y, int z, std::string label);//CFT
	  void DeleteAllPoints();

      int GetLstModelShowNPointsSize();
	  ModelShowNPoints* GetModelShowNPoints();
      ViewShowNPoints* GetViewShowNPoints();
	  void SetInitLstPoints( std::vector<int> initLstPointsX,  std::vector<int> initLstPointsY, std::vector<int> initLstPointsZ, std::vector<std::string> initLstLabels );

		void SetType(int type);
		int  GetType();

		double GetRadio();
		double GetOpacity();

    virtual void                      SetOutputBox();
    void                              ErasePoint(int id);

    
    
    std::vector<int> GetLstPointsX();
    std::vector<int> GetLstPointsY();
    std::vector<int> GetLstPointsZ();
    std::vector<std::string> GetLstLabels();
    std::vector<int> GetLstIndexs();

    

  protected:

  private:
    
      // EED 2022-05-19
      //vtkRenderer                       *renderer;
	  //std::vector<vtkActor*>            lstActorsSphere;//NTU changed from prop3D to Actor
	  //std::vector<vtkTextActor3D*>      lstActorsText;
      //std::vector<vtkSphereSource*>     lstSourceSphere;
      //std::vector<double>               mcolour;
      //ModelShowNPoints*                 mmodelShowNPoints;
      //double                            mopacity;
      std::vector<ViewShowNPoints*>       lstViewShowNPoints;

    
	  //NTU: For updating points
	  wxStaticText          		    * askPointLabel;
	  wxTextCtrl            		    * textCtrl;
      wxStaticText                      * txtNrCollections;
      wxStaticText          		    * txtNrPoints;
	  wxSlider              		    * sdrOpacity;
	  wxSlider              		    * sdrRadio;
      wxCheckBox                        * cbTrackPoint;
    
      std::vector<ModelShowNPoints*>    lstModelShowNPoints;
	  int							    mtype;
      int                               mActualCollection;
//      bool                              trackPointFlag;
      int                               idTrack;
};






#endif // __WidgetShowNPoints_h_INCLUDED__

