/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "boxSurfaceObserver.h"
#include "vtkBoxWidget.h"

void boxSurfaceObserver::Execute(vtkObject *wdg, unsigned long eventId, void* calldata) {  // virtual
	vtkBoxWidget *boxwidget = reinterpret_cast<vtkBoxWidget*>(wdg);
	boxwidget->GetPlanes(_planes);

	if ((_mCubes!=NULL)&&(_tissueStripper!=NULL)&&(_tissueClipper!=NULL))
	{
			_mCubes->Update();
			_tissueStripper->Update();
			_tissueClipper->Update();
	} // if surface


	if ( _vtkVolumeRayCastMapper != NULL )
	{
		_vtkVolumeRayCastMapper->RemoveAllClippingPlanes();
		_vtkVolumeRayCastMapper->SetClippingPlanes(_planes);
	} // if volume


//	_actor->VisibilityOn();

}
//-------------------------------------------------------------------
void boxSurfaceObserver::SetPlanes(vtkPlanes *planes){
	_planes = planes;
}
//-------------------------------------------------------------------
void boxSurfaceObserver::SetActor(vtkProp *actor){
	_actor = actor;
}

//-------------------------------------------------------------------
#if (VTK_MAJOR_VERSION <= 7) 
	void boxSurfaceObserver::SetvtkVolumeRayCastMapper(vtkVolumeRayCastMapper *vtkvolumeraycastmapper)
#else 
	void boxSurfaceObserver::SetvtkFixedPointVolumeRayCastMapper(vtkFixedPointVolumeRayCastMapper *vtkvolumeraycastmapper)
#endif
{
	_vtkVolumeRayCastMapper = vtkvolumeraycastmapper;
}

//-------------------------------------------------------------------
void boxSurfaceObserver::SetFilters(vtkAlgorithm *mCubes , vtkAlgorithm *tissueStripper , vtkAlgorithm *tissueClipper)
{
	_mCubes			= mCubes;
	_tissueStripper	= tissueStripper;
	_tissueClipper	= tissueClipper;


}

