/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef BOXSURFACEOBSERVER_H_
#define BOXSURFACEOBSERVER_H_

#include <vtkVersionMacros.h>
#include "vtkPlanes.h"
#include "vtkProp.h"

#if (VTK_MAJOR_VERSION <= 7) 
	#include "vtkVolumeRayCastMapper.h"
#else 
	#include <vtkFixedPointVolumeRayCastMapper.h>
#endif

#include "vtkObject.h"
#include "vtkCommand.h"


// Callback for the interaction
class boxSurfaceObserver : public vtkCommand
{
	public:
		vtkPlanes							*_planes;
		vtkProp								*_actor;

		vtkAlgorithm 						*_mCubes;
		vtkAlgorithm 						*_tissueStripper;
		vtkAlgorithm 						*_tissueClipper;
#if (VTK_MAJOR_VERSION <= 7) 
		vtkVolumeRayCastMapper				*_vtkVolumeRayCastMapper;
#else 
		vtkFixedPointVolumeRayCastMapper	*_vtkVolumeRayCastMapper;
#endif

		boxSurfaceObserver() 
		{  
			_mCubes								= NULL;
			_tissueStripper						= NULL;
			_tissueClipper						= NULL;
			_vtkVolumeRayCastMapper			 	= NULL;
			
		}

		virtual char const *GetClassName() const { return "boxSurfaceObserver";}

		static boxSurfaceObserver *New(){
			boxSurfaceObserver 	*result;
			result 				= new boxSurfaceObserver();
			return result;
		}

		virtual void Execute(vtkObject *wdg, unsigned long eventId, void* calldata) ;
		void SetPlanes(vtkPlanes *planes);
		void SetActor(vtkProp *actor);
#if (VTK_MAJOR_VERSION <= 7) 
		void SetvtkVolumeRayCastMapper(vtkVolumeRayCastMapper *vtkvolumeraycastmapper);
#else 
		void SetvtkFixedPointVolumeRayCastMapper(vtkFixedPointVolumeRayCastMapper *vtkvolumeraycastmapper);
#endif
		void SetFilters(vtkAlgorithm *_mCubes , vtkAlgorithm *_tissueStripper , vtkAlgorithm *_tissueClipper);
};


#endif /*BOXSURFACEOBSERVER_H_*/
