/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonContainerController.cxx
 * @brief This contains the ButtonContainerController class implementation
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonContainerController.h"

namespace creaButtonContainer
{
	namespace controller
	{
		// ----------------------------------------------------------------------------------
		ButtonContainerController::ButtonContainerController(BCPanel* panel)
		{
			this->m_BCPanel = panel;
		}
		// ----------------------------------------------------------------------------------
		ButtonContainerController::~ButtonContainerController()
		{
		}
		// ----------------------------------------------------------------------------------
		void ButtonContainerController::AddEvents()
		{
			try
			{
				//Adding ButtonManagerEvents
				for (GroupManagerList::iterator it =
						this->m_BCPanel->m_GroupManagerList.begin();
						it != this->m_BCPanel->m_GroupManagerList.end(); ++it)
				{
					this->Connect((*it).first, wxEVT_COMMAND_BUTTON_CLICKED,
							(wxObjectEventFunction)
									& ButtonContainerController::ButtonExpEvent);
				} //rof

				//Adding ButtonEvents
				for (ButtonGroupList::iterator it =
						this->m_BCPanel->m_ButtonGroupList.begin();
						it != this->m_BCPanel->m_ButtonGroupList.end(); ++it)
				{
					KeyList keylist = (*it)->GetButtonIdContainer();
					for (KeyList::iterator it2 = keylist.begin(); it2 != keylist.end();
							++it2)
					{
						this->Connect((*it2), wxEVT_COMMAND_BUTTON_CLICKED,
								(wxObjectEventFunction)
										& ButtonContainerController::ButtonEvent);
					} //rof
				} //rof
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr << "ButtonContainerController::AddEvents( ) exception: "
						<< e.what() << std::endl;
			} //hctac
		}
		// ----------------------------------------------------------------------------------
		void ButtonContainerController::ButtonExpEvent(wxCommandEvent& event)
		{
			long id = event.GetId();

			try
			{
				//changing the button label when its clicked and then hide the buttons of the group.
				if (this->m_BCPanel->m_GroupManagerList[id]->GetButton()->GetLabel().Cmp(
						_("+")) == 0)
				{
					this->m_BCPanel->m_GroupManagerList[id]->GetButton()->SetLabel(
							_("-"));
					this->m_BCPanel->m_GroupManagerList[id]->HideSubPanel(false);
				} //fi
				else if (this->m_BCPanel->m_GroupManagerList[id]->GetButton()->GetLabel().Cmp(
						_("-")) == 0)
				{
					this->m_BCPanel->m_GroupManagerList[id]->GetButton()->SetLabel(
							_("+"));
					this->m_BCPanel->m_GroupManagerList[id]->HideSubPanel(true);
				} //fi esle
				this->m_BCPanel->FitSizer();
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "ButtonContainerController::ButtonExpEvent( wxCommandEvent& event ) exception: "
						<< e.what() << std::endl;
			} //hctac
		}
		// ----------------------------------------------------------------------------------
		void ButtonContainerController::ButtonEvent(wxCommandEvent& event)
		{
			try
			{
				for (ButtonGroupList::iterator it =
						this->m_BCPanel->m_ButtonGroupList.begin();
						it != this->m_BCPanel->m_ButtonGroupList.end(); ++it)
				{
					if ((*it)->GetButton(event.GetId()) != NULL)
					{
						(*it)->GetButton(event.GetId())->Execute();
					} //fi
				} //rof
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "ButtonContainerController::ButtonEvent( wxCommandEvent& event ) exception: "
						<< e.what() << std::endl;
			} //hctac
		}
	// ----------------------------------------------------------------------------------

	}//ecapsename
} //ecapsename

