/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file buttonContainerController.h
 * @brief Contains the ButtonContainerController class
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTONCONTAINERCONTROLLER_H_
#define BUTTONCONTAINERCONTROLLER_H_

#include <wx/event.h>
#include <iostream>
#include <exception>
#include "buttonContainerPanel.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		//Predefinition of ButtonContainerPanel FriendClass!!
		/*! @class ButtonContainerPanel buttonContainerPanel.h "buttonContainerPanel.h"
		 *  @brief This class is the container of the creaButtonContainer.
		 *  @details This class derives from wxScrolledWindow and manages the view of the buttonContainer.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxscrolledwindow.html">wxScrolledWindow</a>
		 */
		class ButtonContainerPanel;
	}
	/*!	@namespace<creaButtonContainer::controller>
	 *	@brief Contains the implementation of the controller in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace controller
	{
		/*! @class ButtonContainerController buttonContainerController.h "buttonContainerController.h"
		 *	@brief This class contains the ButtonContainerPanel controller.
		 *  @details This class describes the button events, it derives from wxEvtHandler.
		 *  @see <a href="http://docs.wxwidgets.org/stable/wx_wxevthandler.html">wxEvtHandler</a>
		 */
		class ButtonContainerController : public wxEvtHandler
		{
			public:
				//typedef definitions
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonGroup ButtonGroup
				 *	@brief Defines the ButtonGroup type
				 */
				typedef creaButtonContainer::view::ButtonGroup ButtonGroup;
				// ----------------------------------------------------------------------------------
				/*!	@typedef typedef creaButtonContainer::view::GroupManager GroupManager
				 *	@brief Defines the GroupManager type
				 */
				typedef creaButtonContainer::view::GroupManager GroupManager;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::list< ButtonGroup* > ButtonGroupList
				 *	@brief Defines the ButtonGroupList type
				 */
				typedef std::list< ButtonGroup* > ButtonGroupList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::map< long, GroupManager* > GroupManagerList
				 * 	@brief Defines the GroupManagerList type
				 */
				typedef std::map< long, GroupManager* > GroupManagerList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef wxFlexGridSizer Sizer
				 *	@brief Defines the Sizer type
				 */
				typedef wxFlexGridSizer Sizer;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::list< long > KeyList
				 *	@brief Defines the KeyList type
				 */
				typedef std::list< long > KeyList;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::model::ContainerSettings ButtonGroupSettings
				 *	@brief Defines the ButtonGroupSettings type
				 */
				typedef creaButtonContainer::model::ContainerSettings
				    ButtonGroupSettings;
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::ButtonContainerPanel BCPanel
				 *	@brief Defines the BCPanel type
				 */
				typedef creaButtonContainer::view::ButtonContainerPanel BCPanel;
				// ----------------------------------------------------------------------------------
				//end of typedef definition
			public:
				// ----------------------------------------------------------------------------------
				/*!	@fn ButtonContainerController( BCPanel* );
				 *	@brief This is the Parameterized constructor.
				 * 	@param BCPanel* The connection with the view (wxPanel link).
				 */
				ButtonContainerController( BCPanel* );
				// ----------------------------------------------------------------------------------
				/*! @fn ~ButtonContainerController( );
				 *	@brief This is the destructor.
				 */
				virtual
				~ButtonContainerController( );

				// ----------------------------------------------------------------------------------
				/*! @fn void AddEvents( );
				 *	@brief This method connect every buttonEvents to the view.
				 *	@exception std::bad_alloc
				 */
				void
				AddEvents( );
				// ----------------------------------------------------------------------------------
				/*! @fn void ButtonExpEvent( wxCommandEvent& event );
				 *	@brief This method is the button group "+" "-" event.
				 *	@exception std::bad_alloc
				 * 	@param event Button action event.
				 */
				void
				ButtonExpEvent( wxCommandEvent& event );
				// ----------------------------------------------------------------------------------
				/*! @fn void ButtonEvent( wxCommandEvent& event );
				 *	@brief This method calls the events of the buttonContainer buttons
				 *	@exception std::bad_alloc
				 * 	@param event Button action event.
				 */
				void
				ButtonEvent( wxCommandEvent& event );
				// ----------------------------------------------------------------------------------

			private:
				BCPanel* m_BCPanel; //! <ButtonContainerPanel View pointer.
		};
	}//ecapsename
}//ecapsename

#endif //BUTTONCONTAINERCONTROLLER_H_
