/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file buttonGroupFactory.cxx
 * @brief Implements the ButtonGroupFactory class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonGroupFactory.h"

namespace creaButtonContainer
{
	namespace model
	{
		// ----------------------------------------------------------------------------------
		ButtonGroupFactory::ButtonGroupFactory( )
		{
		}
		// ----------------------------------------------------------------------------------
		ButtonGroupFactory::~ButtonGroupFactory( )
		{
		}
		
		// ----------------------------------------------------------------------------------
		ButtonGroupFactory::ButtonGroupContainer ButtonGroupFactory::CreateButtonGroupContainer( wxWindow* parent,  ButtonGroupModel* settings )
		{
			ButtonGroupContainer groupView;
			try
			{
				ButtonGroupMap map = settings->GetButtonGroupContainer( );
				for( ButtonGroupMap::iterator it = map.begin( ); it != map.end( ); ++it )
				{
					wxString groupNameAux( ( *it ).first.c_str( ), wxConvUTF8 );
					wxStaticText* wxGroupName = new wxStaticText( parent, -1, groupNameAux, wxDefaultPosition, wxDefaultSize, 0, _T("GroupText") );
					ButtonGroup* group = new ButtonGroup( wxGroupName, this->GetButtons( parent, ( *it ).second ) );
					groupView.push_back( group );
				}//rof
			}//yrt
			catch ( const std::exception& e )
			{
				std::cerr
				    << "ButtonGroupFactory::CreateButtonGroupContainer( wxWindow* parent,   ButtonGroupModel* settings )"
				    << " exception: " << e.what( ) << std::endl;
			}//chtac
			return ( groupView );
		}
		
		
		// ----------------------------------------------------------------------------------
		ButtonGroupFactory::ButtonContainer ButtonGroupFactory::GetButtons( wxWindow* parent, ButtonList buttonModel )
		{
			ButtonContainer buttonList;

			try
			{
				for( ButtonList::iterator it = buttonModel.begin( ); it
				    != buttonModel.end( ); ++it )
				{
					long id = wxNewId( );
					buttonList[ id ] = new Button( parent, id, *it );
				}//rof
				//return ( buttonList ); // JPR
			}//yrt
			catch ( const std::exception& e )
			{
				std::cerr
				    << "ButtonGroupFactory::GetButtons( wxWindow* parent, ButtonList buttonModel )"
				    << "exception: " << e.what( ) << std::endl;
			}//chtac
			
			return ( buttonList );	 // JPR
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
}//ecapseman

