/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file containerSettings.cxx
 * @brief Implements the ContainerSettings class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "containerSettings.h"

namespace creaButtonContainer
{
	namespace model
	{
		// ----------------------------------------------------------------------------------
		ContainerSettings::ContainerSettings()
		{

		}
		// ----------------------------------------------------------------------------------
		ContainerSettings::~ContainerSettings()
		{
		}

		// ----------------------------------------------------------------------------------
		ButtonGroupMap ContainerSettings::GetButtonGroupContainer()
		{
			return (this->m_ButtonGroupContainer);
		}
		// ----------------------------------------------------------------------------------
		KeyMapList ContainerSettings::GetGroupNameList()
		{
			return (this->m_GroupNameList);
		}

		// ----------------------------------------------------------------------------------
		void ContainerSettings::SetButtonGroupContainer(ButtonGroupMap bgContainer)
		{
			this->m_ButtonGroupContainer = bgContainer;
		}
		// ----------------------------------------------------------------------------------
		void ContainerSettings::SetGroupNameList(KeyMapList gNameList)
		{
			this->m_GroupNameList = gNameList;
		}

		// ----------------------------------------------------------------------------------

		void ContainerSettings::AddButton(const StringType & groupName,
				const StringType &buttonName, const wxBitmap &icon,
				const StringType &buttonDescription, FunctionEventType event)
		{

			ButtonPair* pair = new ButtonPair(new ButtonInfo(buttonName, icon),
					new ButtonAction(buttonDescription, event));
			try
			{
				for (KeyMapList::iterator it = this->m_GroupNameList.begin();
						it != this->m_GroupNameList.end(); ++it)
				{
					if ((*it).compare(groupName) == 0)
					{

						this->m_ButtonGroupContainer[groupName].push_back(pair);
						return;
					} //fi
				} //rof
				this->m_GroupNameList.push_back(groupName);
				this->m_ButtonGroupContainer[groupName].push_back(pair);
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "ContainerSettings::AddButton( const std::string & groupName,"
						<< "const std::string buttonName, const std::string iconpath,"
						<< "const std::string buttonDescription, FunctionEventType event ) exception: "
						<< e.what() << std::endl;
			} //hctac
		}
		// ----------------------------------------------------------------------------------
		void ContainerSettings::AddButton(BCSettingsStruct* info)
		{

			ButtonPair* pair = new ButtonPair(
					new ButtonInfo(info->buttonName, info->icon),
					new ButtonAction(info->buttonDescription, info->eventFunction));
			try
			{
				for (KeyMapList::iterator it = this->m_GroupNameList.begin();
						it != this->m_GroupNameList.end(); ++it)
				{
					if ((*it).compare(info->groupName) == 0)
					{
						this->m_ButtonGroupContainer[info->groupName].push_back(pair);
						return;
					} //fi
				} //rof
				this->m_GroupNameList.push_back(info->groupName);
				this->m_ButtonGroupContainer[info->groupName].push_back(pair);
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "void ContainerSettings::AddButton( BCSettingsStruct* info ) "
						<< "exception: " << e.what() << std::endl;
			} //hctac
		}
		// ----------------------------------------------------------------------------------
		void ContainerSettings::AddButtons(BCStructVectorType infoList)
		{

			try
			{
				for (BCStructVectorType::iterator it = infoList.begin();
						it != infoList.end(); ++it)
				{
					this->AddButton(*it);
				} //rof
			} //yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "ContainerSettings::AddButtons( BCStructVectorType infoList ) "
						<< "exception: " << e.what() << std::endl;
			} //hctac
		}

	// ----------------------------------------------------------------------------------
	}//ecapseman
} //ecapseman
