/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file button.cxx
 * @brief Implements the Button class implementation.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "button.h"

namespace creaButtonContainer
{
	namespace view
	{
		// ----------------------------------------------------------------------------------
		Button::Button( wxWindow* parent, long id, ButtonPair* pair ) 		
		{
			this->m_ButtonPair			= pair;
			StringType wXbuttonName		= this->m_ButtonPair->first->first;
			BitmapType wXicon		= this->m_ButtonPair->first->second;
			StringType wXdescription	= this->m_ButtonPair->second->first;
			wxString buttonName( wXbuttonName.c_str( ), wxConvUTF8 );
			wxString description( wXdescription.c_str( ), wxConvUTF8 );
			//creating the button.
			this->Create( parent, id,wXicon,
			    wxDefaultPosition, wxDefaultSize,wxBU_AUTODRAW, wxDefaultValidator,
			    buttonName );
			this->SetToolTip( description );
		}

		// ----------------------------------------------------------------------------------
		Button::~Button( )
		{
		}
		
		// ----------------------------------------------------------------------------------
		StringType
		Button::GetButtonName( )
		{
			return ( this->m_ButtonPair->first->first );
		}

		// ----------------------------------------------------------------------------------
		BitmapType
		Button::GetIcon( )
		{
			return ( this->m_ButtonPair->first->second );
		}		

		// ----------------------------------------------------------------------------------
		/*StringType
		Button::GetIconPath( )
		{
			return ( this->m_ButtonPair->first->second );
		}*/
		
		// ----------------------------------------------------------------------------------
		StringType
		Button::GetDescription( )
		{
			return ( this->m_ButtonPair->second->first );
		}
		
		// ----------------------------------------------------------------------------------
		void
		Button::Execute( )
		{
			try
			{
				TFunctor* vTable[ ] =
				{ this->m_ButtonPair->second->second };

				vTable[ 0 ]->Call( this->m_ButtonPair->first->first );
			}//yrt
			catch ( const std::exception& e )
			{
				std::cerr << "Button::Execute( ) exception: " << e.what( ) << std::endl;
			}//hctac
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
}//ecapseman
