/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonGroup.cxx
 * @brief Implements the ButtonGroup class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonContainerPanel.h"

namespace creaButtonContainer
{
	namespace view
	{
		BEGIN_EVENT_TABLE(ButtonContainerPanel,wxScrolledWindow)
		//(*EventTable(ButtonContainerPanel)
		//*)
		END_EVENT_TABLE()

		// ----------------------------------------------------------------------------------
		ButtonContainerPanel::ButtonContainerPanel( wxWindow* parent, ButtonGroupSettings* settings )
		: wxScrolledWindow(parent,-1, wxDefaultPosition,wxDefaultSize, wxTAB_TRAVERSAL | wxVSCROLL | wxHSCROLL | wxFULL_REPAINT_ON_RESIZE, _T("creaButtonContainer") )
		{

			ButtonGroupFactory factory;

			this->SetButtonGroupContainer( factory.CreateButtonGroupContainer( this, settings ) );

			this->PanelInit( );
			this->m_ButtonCController = new BCController( this );
			this->m_ButtonCController->AddEvents( );
			this->SetEventHandler( this->m_ButtonCController );
		}

		// ----------------------------------------------------------------------------------
		ButtonContainerPanel::~ButtonContainerPanel()
		{
		}

		// ----------------------------------------------------------------------------------
		void ButtonContainerPanel::SetButtonGroupContainer(
				ButtonGroupList groupContainer)
		{

			this->m_ButtonGroupList = groupContainer;
		}

		// ----------------------------------------------------------------------------------
		void ButtonContainerPanel::PanelInit()
		{
			try
			{

// EED 20/01/2012  flag 01
				this->m_Sizer = new Sizer(0, 1, 0, 0);

				for (ButtonGroupList::iterator it = this->m_ButtonGroupList.begin();
						it != this->m_ButtonGroupList.end(); ++it)
				{
					GroupManager* manager = new GroupManager(this, *it);
					this->m_GroupManagerList[manager->GetButtonID()] = manager;
					this->m_Sizer->Add(manager, 1, wxALL | wxALIGN_LEFT | wxALIGN_TOP, 5);
				}

				this->SetSizer(this->m_Sizer);
				this->Layout();
				this->FitSizer();
			}		//yrt
			catch (const std::exception& e)
			{
				std::cerr << "ButtonContainerPanel::PanelInit( ) " << "exception: "
						<< e.what() << std::endl;
			}		//hctac
		}

		// ----------------------------------------------------------------------------------
		void ButtonContainerPanel::FitSizer()
		{
			this->m_Sizer->Fit(this);
			this->m_Sizer->FitInside(this);
			this->SetScrollRate(20, 20);
			this->m_Sizer->SetSizeHints(this);
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
}		//ecapseman
