/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonGroup.cxx
 * @brief Implements the ButtonGroup class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonGroup.h"

namespace creaButtonContainer
{
	namespace view
	{
		// ----------------------------------------------------------------------------------
		ButtonGroup::ButtonGroup(wxStaticText* groupName,
				ButtonContainer cartoButtons)
		{
			this->m_GroupName = groupName;
			this->m_Buttons = cartoButtons;
		}

		// ----------------------------------------------------------------------------------
		ButtonGroup::~ButtonGroup()
		{
		}

		// ----------------------------------------------------------------------------------
		ButtonGroup::ButtonContainer ButtonGroup::GetButtonContainer()
		{
			return (this->m_Buttons);
		}

		// ----------------------------------------------------------------------------------
		wxStaticText*
		ButtonGroup::GetGroupName()
		{
			return (this->m_GroupName);
		}

		// ----------------------------------------------------------------------------------
		ButtonGroup::IdButtonContainer ButtonGroup::GetButtonIdContainer()
		{
			IdButtonContainer idContainer;
			try
			{
				for (ButtonContainer::iterator it = this->m_Buttons.begin();
						it != this->m_Buttons.end(); ++it)
				{
					idContainer.push_back((*it).first);
				} //rof
			} //yrt
			catch (std::exception& e)
			{
				std::cerr << "ButtonGroup::GetButtonIdContainer( )" << "exception: "
						<< e.what() << std::endl;
			} //hctac
			return (idContainer);
		}

		// ----------------------------------------------------------------------------------
		Button*
		ButtonGroup::GetButton(long id)
		{
			try
			{
				//return ( this->m_Buttons[ id ] ); // JPR
			} //yrt
			catch (std::exception& e)
			{
				std::cerr << "ButtonGroup::GetButton( long id )" << "exception: "
						<< e.what() << std::endl;
			} //hctac
			return (this->m_Buttons[id]); // JPR
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
} //ecapseman
