/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*!
 * @file buttonGroup.h
 * @brief This contains the ButtonGroup class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#ifndef BUTTONGROUP_H
#define BUTTONGROUP_H

//Library Definition
#include <wx/stattext.h>

#include <map>
#include <list>
#include <exception>

#include "button.h"

/*!	@namespace <creaButtonContainer>
 *	@brief Contains the creaButtonContainer library included in creaMaracasVisu.
 */
namespace creaButtonContainer
{
	/*! @namespace <creaButtonContainer::view>
	 *	@brief Contains the implementation of the view in creaButtonContainer library.
	 *	@see <a href="http://en.wikipedia.org/wiki/Model-view-controller">MVC Software Architecture</a>
	 */
	namespace view
	{
		/*! @class ButtonGroup buttonGroup.h "buttonGroup.h"
		 *	@brief This class contains the group of buttons.
		 */
		class ButtonGroup
		{
			public:
				//Typedef definition
				// ----------------------------------------------------------------------------------
				/*!	@typedef creaButtonContainer::view::Button Button;
				 *	@brief Defines the Button type.
				 */
				typedef creaButtonContainer::view::Button Button;
				// ----------------------------------------------------------------------------------
				/*!	@typedef std::map< long, Button* > ButtonContainer;
				 *	@brief Defines the ButtonContainer type.
				 */
				typedef std::map< long, Button* > ButtonContainer;
				// ----------------------------------------------------------------------------------
				/*!	typedef std::list< long > IdButtonContainer;
				 *	@brief Defines the IdButtonContainer type.
				 */
				typedef std::list< long > IdButtonContainer;
			public:
				// ----------------------------------------------------------------------------------
				/*! @fn ButtonGroup( wxStaticText* groupName, ButtonContainer buttons );
				 *	@brief This is the parameterized constructor.
				 * @param groupName wxStatigText* with the name of the group.
				 * @param buttons A container with buttons.
				 */
				ButtonGroup( wxStaticText* groupName, ButtonContainer buttons );
				// ----------------------------------------------------------------------------------
				/*! @fn ~ButtonGroup( );
				 * @brief This is the destructor.
				 */
				virtual
				~ButtonGroup( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButton( long id );
				 * @brief This method returns a Button*
				 * @param id The ID of the button.
				 * @return Button*
				 */
				Button*
				GetButton( long id );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButtonContainer( );
				 * @brief This method returns the button container.
				 * @exception std::bad_alloc
				 * @return ButtonContainer.
				 */
				ButtonContainer
				GetButtonContainer( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetButtonIdContainer( );
				 * @brief This method returns a list of button IDs.
				 * @exception std::bad_alloc
				 * @return
				 */
				IdButtonContainer
				GetButtonIdContainer( );
				// ----------------------------------------------------------------------------------
				/*! @fn GetGroupName( );
				 * @brief This method returns the name of the group.
				 * @return
				 */
				wxStaticText*
				GetGroupName( );
				// ----------------------------------------------------------------------------------
			private:
				wxStaticText* m_GroupName; //!<A pointer with the wxStaticText of name of the group.
				ButtonContainer m_Buttons; //!<A container with buttons.
		};
	}//ecapseman
}//ecapseman

#endif // BUTTONGROUP_H
