/*# ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant�)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */

/*!
 * @file buttonManager.cxx
 * @brief Implements the ButtonManager class.
 * @author Diego CACERES (diego.caceres[AT]creatis.insa-lyon.fr)
 * @date  2011-06-02
 */

#include "buttonManager.h"

namespace creaButtonContainer
{
	namespace view
	{
		// ----------------------------------------------------------------------------------
		ButtonManager::ButtonManager()
				: wxFlexGridSizer(0, 1, 0, 0)
		{
		}

//EED 20/01/2012  Flag03		
		// ----------------------------------------------------------------------------------
		ButtonManager::ButtonManager(ButtonGroup* buttonGroup)
				: wxFlexGridSizer(0, 1, 0, 0)
		{
			try
			{
				this->SetGroupName(buttonGroup->GetGroupName());
				this->SetButtonManager(buttonGroup->GetButtonContainer());
			}		//yrt
			catch (const std::exception& e)
			{
				std::cerr << "Button::Execute( ) exception: " << e.what() << std::endl;
			}		//hctac
		}

		// ----------------------------------------------------------------------------------
		ButtonManager::~ButtonManager()
		{
		}

		// ----------------------------------------------------------------------------------
		void ButtonManager::SetGroupName(wxStaticText* groupName)
		{
			this->m_GroupName = groupName;
			this->Add(this->m_GroupName, -1, wxALL | wxALIGN_LEFT | wxALIGN_TOP, 5);
		}

		// ----------------------------------------------------------------------------------
		void ButtonManager::SetButtonManager(ButtonContainer buttonContainer)
		{
			try
			{
				if (this->m_GroupName != NULL)
				{
					this->m_GridSizer = new wxGridSizer(0, 3, 0, 0);
					for (ButtonContainer::iterator it = buttonContainer.begin();
							it != buttonContainer.end(); ++it)
					{
						this->m_GridSizer->Add((*it).second, -1,
								wxALL | wxALIGN_LEFT | wxALIGN_TOP, 5);
					}
					this->Add(m_GridSizer, -1, wxALL | wxALIGN_LEFT | wxALIGN_TOP, 5);
				}		//fi
			}		//yrt
			catch (const std::exception& e)
			{
				std::cerr
						<< "ButtonManager::SetButtonManager( ButtonContainer buttonContainer )"
						<< "exception: " << e.what() << std::endl;
			}		//hctac
		}
		// ----------------------------------------------------------------------------------

		void ButtonManager::ShowButtonManager()
		{
			this->Show(this->m_GridSizer, true, false);
		}
		// ----------------------------------------------------------------------------------
		void ButtonManager::HideButtonManager()
		{
			this->Show(this->m_GridSizer, false, false);
		}
	// ----------------------------------------------------------------------------------
	}//ecapseman
}		//ecapseman
